/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.puffbug.ai;

import com.teamabnormals.blueprint.core.endimator.PlayableEndimation;
import com.teamabnormals.blueprint.core.util.MathUtil;
import com.teamabnormals.blueprint.core.util.NetworkUtil;
import com.teamabnormals.endergetic.common.entity.puffbug.PuffBug;
import com.teamabnormals.endergetic.core.other.EEPlayableEndimations;
import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class PuffBugRotateToFireGoal
extends Goal {
    private final PuffBug puffbug;
    private final RandomSource random;
    private int ticksPassed;
    private int ticksToRotate;

    public PuffBugRotateToFireGoal(PuffBug puffbug) {
        this.puffbug = puffbug;
        this.random = puffbug.m_217043_();
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return !this.puffbug.m_20159_() && !this.puffbug.isEndimationPlaying(EEPlayableEndimations.PUFF_BUG_TELEPORT_FROM) && this.puffbug.isInflated() && this.puffbug.getLaunchDirection() != null;
    }

    public boolean m_8045_() {
        return this.m_8036_() && this.ticksPassed <= this.ticksToRotate;
    }

    public void m_8056_() {
        this.ticksToRotate = this.random.m_188503_(5) + 12;
    }

    public void m_8041_() {
        if (this.puffbug.getLaunchDirection() != null && this.ticksPassed >= this.ticksToRotate) {
            Vec3 launch = this.puffbug.getLaunchDirection();
            float yaw = (float)launch.m_7098_() - this.puffbug.m_146908_();
            float pitch = Mth.m_14118_((float)((float)launch.m_7096_()), (float)0.0f);
            float x = -Mth.m_14031_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
            float y = -Mth.m_14031_((float)(pitch * ((float)Math.PI / 180)));
            float z = Mth.m_14089_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
            Vec3 motion = new Vec3((double)x, (double)(-y), (double)z).m_82541_();
            this.puffbug.m_20256_(this.puffbug.m_20184_().m_82549_(motion.m_82490_(1.0)));
            this.puffbug.setFireDirection((float)launch.m_7096_(), (float)launch.m_7098_());
            this.puffbug.removeLaunchDirection();
            this.puffbug.setInflated(false);
            NetworkUtil.setPlayingAnimation((Entity)this.puffbug, (PlayableEndimation)EEPlayableEndimations.PUFF_BUG_FLY);
            Vec3 pos = this.puffbug.m_20182_();
            double posX = pos.m_7096_();
            double posY = pos.m_7098_();
            double posZ = pos.m_7094_();
            for (int i = 0; i < 3; ++i) {
                float particleX = Mth.m_14031_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
                float particleY = -Mth.m_14031_((float)(pitch * ((float)Math.PI / 180)));
                float particleZ = -Mth.m_14089_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
                Vec3 particleMotion = new Vec3((double)particleX, (double)particleY, (double)particleZ).m_82541_().m_82490_(0.5);
                NetworkUtil.spawnParticle((String)"endergetic:short_poise_bubble", (double)posX, (double)posY, (double)posZ, (double)(particleMotion.m_7096_() + MathUtil.makeNegativeRandomly((double)(this.random.m_188501_() * 0.25f), (RandomSource)this.random)), (double)(particleMotion.m_7098_() + (double)(this.random.m_188501_() * 0.05f)), (double)MathUtil.makeNegativeRandomly((double)(particleMotion.m_7094_() + (double)(this.random.m_188501_() * 0.25f)), (RandomSource)this.random));
            }
        }
        this.ticksPassed = 0;
        this.ticksToRotate = 0;
    }

    public void m_8037_() {
        ++this.ticksPassed;
        this.puffbug.m_21573_().m_26573_();
        Vec3 launchDirection = this.puffbug.getLaunchDirection();
        this.puffbug.getRotationController().rotate((float)Mth.m_14175_((double)(launchDirection.m_7098_() - this.puffbug.m_20186_())), (float)launchDirection.m_7096_() + 90.0f, 0.0f, 10);
    }

    public boolean m_183429_() {
        return true;
    }
}

