/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.eetle.ai.glider;

import com.teamabnormals.blueprint.common.world.storage.tracking.IDataManager;
import com.teamabnormals.endergetic.common.entity.eetle.GliderEetle;
import com.teamabnormals.endergetic.common.entity.eetle.flying.TargetFlyingRotations;
import com.teamabnormals.endergetic.core.other.EEDataProcessors;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;

public class GliderEetleGrabGoal
extends Goal {
    private final GliderEetle glider;
    private Path path;
    private int delayCounter;
    private int swoopTimer;

    public GliderEetleGrabGoal(GliderEetle glider) {
        this.glider = glider;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.glider.isGrounded()) {
            return false;
        }
        LivingEntity target = this.glider.m_5448_();
        if (target == null || !target.m_6084_() || GliderEetle.isEntityLarge((Entity)target) || (Integer)((IDataManager)target).getValue(EEDataProcessors.CATCHING_COOLDOWN) > 0 || target.m_20202_() instanceof GliderEetle || !this.glider.m_20197_().isEmpty()) {
            return false;
        }
        this.path = this.glider.m_21573_().m_6570_((Entity)target, 0);
        return this.path != null;
    }

    public void m_8056_() {
        GliderEetle glider = this.glider;
        if (!glider.isFlying()) {
            glider.setFlying(true);
        }
        glider.m_21573_().m_26536_(this.path, 1.375);
        glider.m_21561_(true);
        this.delayCounter = 0;
    }

    public boolean m_8045_() {
        if (this.glider.isGrounded()) {
            return false;
        }
        if (this.swoopTimer > 0 && !this.glider.m_20197_().isEmpty()) {
            return true;
        }
        LivingEntity target = this.glider.m_5448_();
        if (target == null || !target.m_6084_() || GliderEetle.isEntityLarge((Entity)target) || (Integer)((IDataManager)target).getValue(EEDataProcessors.CATCHING_COOLDOWN) > 0 || target.m_20202_() instanceof GliderEetle || !this.glider.m_20197_().isEmpty()) {
            return false;
        }
        return !this.glider.m_21573_().m_26571_();
    }

    public void m_8037_() {
        double reachRange;
        GliderEetle glider = this.glider;
        if (this.swoopTimer > 0) {
            --this.swoopTimer;
            glider.m_20256_(glider.m_20184_().m_82490_(1.0625));
            glider.m_21573_().m_26573_();
            glider.setTargetFlyingRotations(new TargetFlyingRotations(-30.0f, glider.getTargetFlyingRotations().getTargetFlyRoll()));
            return;
        }
        this.delayCounter = Math.max(this.delayCounter - 1, 0);
        LivingEntity target = glider.m_5448_();
        glider.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        double distanceToTargetSq = glider.m_20280_((Entity)target);
        if (glider.m_21574_().m_148306_((Entity)target) && this.delayCounter <= 0 && glider.m_217043_().m_188501_() < 0.05f) {
            this.delayCounter = 4 + glider.m_217043_().m_188503_(9);
            PathNavigation pathNavigator = glider.m_21573_();
            if (distanceToTargetSq > 1024.0) {
                this.delayCounter += 10;
            } else if (distanceToTargetSq > 256.0) {
                this.delayCounter += 5;
            }
            float blocksFromTarget = Mth.m_14116_((float)((float)distanceToTargetSq));
            if (blocksFromTarget >= 3.0f) {
                Path path = pathNavigator.m_7864_(GliderEetleGrabGoal.getAirPosAboveTarget(glider.m_9236_(), target), 0);
                if (path == null || !pathNavigator.m_26536_(path, 1.25)) {
                    this.delayCounter += 15;
                }
            } else if (!glider.m_21573_().m_5624_((Entity)target, 1.25)) {
                this.delayCounter += 15;
            }
        }
        if (distanceToTargetSq <= (reachRange = (double)(glider.m_20205_() * 2.0f * glider.m_20205_() * 2.0f + target.m_20205_())) && glider.m_142582_((Entity)target) && target.m_7998_((Entity)glider, true)) {
            RandomSource random = glider.m_217043_();
            float yaw = glider.m_146908_() + (random.m_188501_() * 15.0f - random.m_188501_() * 15.0f);
            float xMotion = -Mth.m_14031_((float)(yaw * ((float)Math.PI / 180)));
            float zMotion = Mth.m_14089_((float)(yaw * ((float)Math.PI / 180)));
            glider.m_20256_(glider.m_20184_().m_82520_((double)(xMotion * 0.3f), (double)0.45f, (double)(zMotion * 0.3f)));
            this.swoopTimer = 10;
        }
    }

    public void m_8041_() {
        GliderEetle glider = this.glider;
        LivingEntity livingentity = glider.m_5448_();
        if (!EntitySelector.f_20406_.test(livingentity)) {
            glider.m_6710_(null);
        }
        glider.m_21561_(false);
        glider.m_21573_().m_26573_();
    }

    public boolean m_183429_() {
        return true;
    }

    public static BlockPos getAirPosAboveTarget(Level world, LivingEntity target) {
        BlockPos.MutableBlockPos mutable = target.m_20183_().m_122032_();
        for (int y = 0; y < 4; ++y) {
            mutable.m_122184_(0, 1, 0);
            if (world.m_46859_((BlockPos)mutable)) continue;
            mutable.m_122184_(0, -1, 0);
            break;
        }
        return mutable;
    }
}

