/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.booflo.ai;

import com.teamabnormals.endergetic.common.entity.booflo.Booflo;
import com.teamabnormals.endergetic.common.entity.puffbug.PuffBug;
import com.teamabnormals.endergetic.core.registry.EEItems;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.pathfinder.Path;

public class BoofloHuntPuffBugGoal
extends Goal {
    private static final float SPEED = 1.0f;
    private final Booflo booflo;
    private Path path;
    private int delayCounter;

    public BoofloHuntPuffBugGoal(Booflo booflo) {
        this.booflo = booflo;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.booflo.isBoofed() || this.booflo.isPregnant() || !(this.booflo.getBoofloAttackTarget() instanceof PuffBug) || !this.booflo.getBoofloAttackTarget().m_6084_() || this.booflo.hasCaughtPuffBug()) {
            return false;
        }
        this.path = this.booflo.m_21573_().m_6570_(this.booflo.getBoofloAttackTarget(), 0);
        return this.path != null;
    }

    public boolean m_8045_() {
        Entity target = this.booflo.getBoofloAttackTarget();
        return this.booflo.m_20197_().isEmpty() && !this.booflo.hasCaughtPuffBug() && this.booflo.isBoofed() && !this.booflo.isPregnant() && target != null && target.m_6084_() && target instanceof PuffBug;
    }

    public void m_8056_() {
        this.booflo.m_21573_().m_26536_(this.path, 1.0);
        this.booflo.m_21561_(true);
        this.delayCounter = 0;
        if (this.booflo.hasCaughtFruit()) {
            this.booflo.setCaughtFruit(false);
            this.booflo.m_19998_((ItemLike)EEItems.BOLLOOM_FRUIT.get());
        }
    }

    public void m_8037_() {
        PuffBug target = (PuffBug)this.booflo.getBoofloAttackTarget();
        if (target == null) {
            return;
        }
        double distToEnemySqr = this.booflo.m_20275_(target.m_20185_(), target.m_20191_().f_82289_, target.m_20189_());
        --this.delayCounter;
        if (this.delayCounter <= 0 || this.booflo.m_217043_().m_188501_() < 0.05f) {
            this.booflo.m_21563_().m_24950_(target.m_20185_(), target.m_20186_(), target.m_20189_(), 10.0f, 10.0f);
            this.delayCounter = 4 + this.booflo.m_217043_().m_188503_(7);
            if (distToEnemySqr > 256.0) {
                this.delayCounter += 5;
            }
            if (!this.booflo.m_21573_().m_26519_(target.m_20185_(), target.m_20186_(), target.m_20189_(), 1.0)) {
                this.delayCounter += 5;
            }
        }
        if (this.booflo.m_20197_().isEmpty() && this.booflo.m_217043_().m_188501_() < 0.1f) {
            this.tryToCatch(target, distToEnemySqr);
        }
    }

    public void m_8041_() {
        this.booflo.m_21561_(false);
        this.booflo.m_21573_().m_26573_();
    }

    protected void tryToCatch(PuffBug enemy, double distToEnemySqr) {
        double attackRange = (this.booflo.m_20205_() * 2.0f * this.booflo.m_20205_() * 2.0f + enemy.m_20205_()) * 0.75f;
        if (distToEnemySqr <= attackRange) {
            this.booflo.catchPuffBug(enemy);
        }
    }

    public boolean m_183429_() {
        return true;
    }
}

