/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.teamabnormals.blueprint.client.BlueprintRenderTypes;
import com.teamabnormals.endergetic.client.model.corrock.CorrockCrownStandingModel;
import com.teamabnormals.endergetic.client.model.corrock.CorrockCrownWallModel;
import com.teamabnormals.endergetic.common.block.CorrockCrownStandingBlock;
import com.teamabnormals.endergetic.common.block.entity.CorrockCrownTileEntity;
import com.teamabnormals.endergetic.core.other.EEModelLayers;
import com.teamabnormals.endergetic.core.registry.EEBlocks;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CorrockCrownTileEntityRenderer
implements BlockEntityRenderer<CorrockCrownTileEntity> {
    public CorrockCrownStandingModel standingModel;
    public CorrockCrownWallModel wallModel;
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("endergetic:textures/tile/end_corrock_crown.png"), new ResourceLocation("endergetic:textures/tile/nether_corrock_crown.png"), new ResourceLocation("endergetic:textures/tile/overworld_corrock_crown.png")};

    public CorrockCrownTileEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.standingModel = new CorrockCrownStandingModel(context.m_173582_(EEModelLayers.CORROCK_CROWN_STANDING));
        this.wallModel = new CorrockCrownWallModel(context.m_173582_(EEModelLayers.CORROCK_CROWN_WALL));
    }

    public void render(CorrockCrownTileEntity te, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        BlockState state = te.m_58900_();
        boolean isStanding = state.m_60734_() instanceof CorrockCrownStandingBlock;
        matrixStack.m_85836_();
        if (isStanding) {
            matrixStack.m_252880_(0.5f, 1.5f, 0.5f);
            angle = -((float)((Integer)state.m_61143_((Property)StandingSignBlock.f_56987_) * 360) / 16.0f);
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(angle));
        } else {
            matrixStack.m_252880_(0.5f, 1.5f, 0.5f);
            angle = -((Direction)state.m_61143_((Property)WallSignBlock.f_58064_)).m_122424_().m_122435_();
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(angle));
            matrixStack.m_252880_(0.0f, -0.4f, 0.05f);
        }
        if (isStanding && ((Boolean)state.m_61143_((Property)CorrockCrownStandingBlock.UPSIDE_DOWN)).booleanValue()) {
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            matrixStack.m_252880_(0.0f, 2.0f, 0.0f);
        }
        matrixStack.m_85841_(1.0f, -1.0f, -1.0f);
        VertexConsumer ivertexbuilder = buffer.m_6299_(BlueprintRenderTypes.getUnshadedCutoutEntity((ResourceLocation)TEXTURES[this.getTexture(te)], (boolean)true));
        if (isStanding) {
            this.standingModel.renderAll(matrixStack, ivertexbuilder, 240, combinedOverlay);
        } else {
            this.wallModel.renderAll(matrixStack, ivertexbuilder, 240, combinedOverlay);
        }
        matrixStack.m_85849_();
    }

    public int getTexture(CorrockCrownTileEntity te) {
        Block block = te.m_58900_().m_60734_();
        if (block == EEBlocks.END_CORROCK_CROWN.get() || block == EEBlocks.END_WALL_CORROCK_CROWN.get() || block == EEBlocks.PETRIFIED_END_CORROCK_CROWN.get() || block == EEBlocks.PETRIFIED_END_WALL_CORROCK_CROWN.get()) {
            return 0;
        }
        if (block == EEBlocks.NETHER_CORROCK_CROWN.get() || block == EEBlocks.NETHER_WALL_CORROCK_CROWN.get() || block == EEBlocks.PETRIFIED_NETHER_CORROCK_CROWN.get() || block == EEBlocks.PETRIFIED_NETHER_WALL_CORROCK_CROWN.get()) {
            return 1;
        }
        return 2;
    }

    public int m_142163_() {
        return 256;
    }
}

