/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.api.entity.util;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RayTraceHelper {
    public static HitResult rayTrace(Entity entity, double distance, float delta) {
        return entity.m_9236_().m_45547_(new ClipContext(entity.m_20299_(delta), entity.m_20299_(delta).m_82549_(entity.m_20252_(delta).m_82490_(distance)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
    }

    public static HitResult rayTraceWithCustomDirection(Entity entity, float pitch, float yaw, double distance, float delta) {
        return entity.m_9236_().m_45547_(new ClipContext(entity.m_20299_(delta), entity.m_20299_(delta).m_82549_(RayTraceHelper.getVectorForRotation(pitch, yaw).m_82490_(distance)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
    }

    public static EntityHitResult rayTraceEntityResult(Entity entity, float pitch, float yaw, double distance, double sqDistance, float delta) {
        Vec3 look = RayTraceHelper.getVectorForRotation(pitch, yaw);
        Vec3 endVec = entity.m_20299_(delta).m_82549_(look.m_82490_(distance));
        AABB axisalignedbb = entity.m_20191_().m_82369_(look.m_82490_(distance)).m_82377_(1.0, 1.0, 1.0);
        return RayTraceHelper.getEntityHitResult(entity, entity.m_20299_(delta), endVec, axisalignedbb, result -> !result.m_5833_() && result.m_6087_(), sqDistance);
    }

    public static final Vec3 getVectorForRotation(float pitch, float yaw) {
        float f = pitch * ((float)Math.PI / 180);
        float f1 = -yaw * ((float)Math.PI / 180);
        float f2 = Mth.m_14089_((float)f1);
        float f3 = Mth.m_14031_((float)f1);
        float f4 = Mth.m_14089_((float)f);
        float f5 = Mth.m_14031_((float)f);
        return new Vec3((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }

    @Nullable
    public static EntityHitResult getEntityHitResult(Entity p_221273_0_, Vec3 p_221273_1_, Vec3 p_221273_2_, AABB p_221273_3_, Predicate<Entity> p_221273_4_, double p_221273_5_) {
        Level world = p_221273_0_.m_9236_();
        double d0 = p_221273_5_;
        Entity entity = null;
        Vec3 Vector3d = null;
        for (Entity entity1 : world.m_6249_(p_221273_0_, p_221273_3_, p_221273_4_)) {
            Vec3 Vector3d1;
            double d1;
            AABB axisalignedbb = entity1.m_20191_().m_82400_((double)entity1.m_6143_());
            Optional optional = axisalignedbb.m_82371_(p_221273_1_, p_221273_2_);
            if (axisalignedbb.m_82390_(p_221273_1_)) {
                if (!(d0 >= 0.0)) continue;
                entity = entity1;
                Vector3d = optional.orElse(p_221273_1_);
                d0 = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((d1 = p_221273_1_.m_82557_(Vector3d1 = (Vec3)optional.get())) < d0) && d0 != 0.0) continue;
            if (entity1.m_20201_() == p_221273_0_.m_20201_()) {
                if (d0 != 0.0) continue;
                entity = entity1;
                Vector3d = Vector3d1;
                continue;
            }
            entity = entity1;
            Vector3d = Vector3d1;
            d0 = d1;
        }
        if (entity == null) {
            return null;
        }
        return new EntityHitResult(entity, Vector3d);
    }
}

