/*
 * Decompiled with CFR 0.152.
 */
package com.crabmod.hotbath.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class SoundHandler {
    public static void playEnterWaterSound(Player player, RandomSource rand) {
        player.m_9236_().m_5594_(player, player.m_20183_(), SoundEvents.f_12277_, SoundSource.PLAYERS, rand.m_188501_() * 0.5f, rand.m_188501_() * 0.5f + 0.75f);
    }

    public static void playUnderwaterEnterSound(Player player, RandomSource rand) {
        player.m_9236_().m_5594_(player, player.m_20183_(), SoundEvents.f_12537_, SoundSource.BLOCKS, rand.m_188501_() * 0.5f, rand.m_188501_() * 0.5f + 0.75f);
    }

    public static void playUnderwaterLoopSound(Player player, RandomSource rand) {
        player.m_9236_().m_5594_(player, player.m_20183_(), SoundEvents.f_12643_, SoundSource.PLAYERS, 1.0f, rand.m_188501_() * 0.5f + 0.75f);
    }

    public static void playExitWaterSound(Player player, RandomSource rand) {
        player.m_9236_().m_5594_(player, player.m_20183_(), SoundEvents.f_12590_, SoundSource.PLAYERS, rand.m_188501_() * 0.5f + 0.75f, rand.m_188501_() * 0.5f + 0.75f);
    }

    public static void stopUnderwaterLoopSound(Player player) {
        if (player instanceof LocalPlayer) {
            SoundManager soundManager = Minecraft.m_91087_().m_91106_();
            soundManager.m_120386_(SoundEvents.f_12643_.m_11660_(), SoundSource.PLAYERS);
        }
    }

    public static void playAmbientWaterSound(Level worldIn, BlockPos pos, RandomSource rand) {
        if (rand.m_188503_(64) == 0) {
            double maxDistance = 3.0;
            double maxDistanceSquared = maxDistance * maxDistance;
            for (Player player : worldIn.m_6907_()) {
                double distance;
                float volume;
                double distanceSquared = player.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                if (distanceSquared > maxDistanceSquared || !((volume = (float)((maxDistance - (distance = Math.sqrt(distanceSquared))) / maxDistance)) > 0.0f)) continue;
                worldIn.m_5594_(player, pos, SoundEvents.f_12540_, SoundSource.BLOCKS, volume, rand.m_188501_() * 0.5f + 0.75f);
            }
        }
    }
}

