/*
 * Decompiled with CFR 0.152.
 */
package com.crabmod.hotbath.fluid_details;

import com.crabmod.hotbath.fluid_details.BaseFluidType;
import com.crabmod.hotbath.fluid_details.FluidsColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class HotbathFluidType {
    public static final ResourceLocation WATER_STILL_RL = new ResourceLocation("block/water_still");
    public static final ResourceLocation WATER_FLOWING_RL = new ResourceLocation("block/water_flow");
    public static final ResourceLocation WATER_OVERLAY_RL = new ResourceLocation("block/water_overlay");
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"hotbath");

    public static RegistryObject<FluidType> getHotBathFluidType(String name, int color, ResourceLocation STILL_RL_TEXTURE, ResourceLocation FLOWING_RL_TEXTURE) {
        return HotbathFluidType.register(name, FluidType.Properties.create().lightLevel(2).density(15).viscosity(5).canExtinguish(true).supportsBoating(true).fallDistanceModifier(0.0f).canDrown(true).canSwim(true).pathType(BlockPathTypes.WATER).adjacentPathType(BlockPathTypes.WATER_BORDER).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.f_11937_).canHydrate(true), color, STILL_RL_TEXTURE, FLOWING_RL_TEXTURE);
    }

    private static RegistryObject<FluidType> register(String name, FluidType.Properties properties, int FLUID_COLOR, ResourceLocation STILL_RL_TEXTURE, ResourceLocation FLOWING_RL_TEXTURE) {
        return FLUID_TYPES.register(name, () -> new BaseFluidType(STILL_RL_TEXTURE, FLOWING_RL_TEXTURE, WATER_OVERLAY_RL, FLUID_COLOR, FluidsColor.DEFAULT_FOG_COLOR, properties));
    }

    public static void register(IEventBus eventBus) {
        FLUID_TYPES.register(eventBus);
    }
}

