/*
 * Decompiled with CFR 0.152.
 */
package com.crabmod.hotbath.events.enter_fluid_events;

import com.crabmod.hotbath.util.CustomFluidHandler;
import com.crabmod.hotbath.util.EffectRemovalHandler;
import com.crabmod.hotbath.util.HealthRegenHandler;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="hotbath")
public class PeonyBathEvents {
    static final String PEONY_BATH_ENTERED_NUMBER = "PeonyBathEnteredNumber";
    static final String PEONY_BATH_STAYED_TIME = "PeonyBathStayedTime";
    static final String HAS_ENTERED_PEONY_BATH = "HasEnteredPeonyBath";
    static final String PEONY_BATH_EXITED_TIME = "PeonyBathExitedTime";
    private static final int TICK_NUMBER = 20;
    private static final int PEONY_BATH_ENTERED_COUNT_TRIGGER_NUMBER = 100;
    private static final int PEONY_BATH_STAYED_EFFECT_TRIGGER_TIME_SECONDS = 5;
    private static final int KNOCKBACK_RESISTANCE_DURATION = 600;
    private static final int ATTACK_SPEED_DURATION = 300;
    private static final int LUCK_DURATION = 900;
    private static final int LUCK_THRESHOLD = 50;
    private static final UUID ATTACK_SPEED_MODIFIER_UUID = UUID.randomUUID();
    private static final UUID KNOCKBACK_RESISTANCE_UUID = UUID.randomUUID();
    private static final int ATTRIBUTE_REMOVE_DELAY_TICKS = 300;

    @SubscribeEvent
    public static void enterPeonyBathEvents(LivingEvent.LivingTickEvent event) {
        PeonyBathEvents.enterFluidEvents(event, 100, 5, PEONY_BATH_ENTERED_NUMBER, PEONY_BATH_STAYED_TIME, HAS_ENTERED_PEONY_BATH);
    }

    public static void enterFluidEvents(LivingEvent.LivingTickEvent event, int enteredCountTriggerNumber, int stayedEffectTriggerTime, String enteredNumberInPeonyBath, String peonyBathStayedTime, String hasEnteredPeonyBath) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            CompoundTag playerData = player.getPersistentData();
            boolean isInPeonyBath = CustomFluidHandler.isPlayerInPeonyBathBlock((Player)player);
            if (isInPeonyBath && player.m_6084_()) {
                if (!playerData.m_128471_(hasEnteredPeonyBath)) {
                    int enteredCount = playerData.m_128451_(enteredNumberInPeonyBath) + 1;
                    playerData.m_128405_(enteredNumberInPeonyBath, enteredCount);
                    playerData.m_128379_(hasEnteredPeonyBath, true);
                }
                int hotBathTime = playerData.m_128451_(peonyBathStayedTime) + 1;
                playerData.m_128405_(peonyBathStayedTime, hotBathTime);
                HealthRegenHandler.regenHealth(0.25f, 2.0, player);
                if (playerData.m_128451_(peonyBathStayedTime) >= 300) {
                    PeonyBathEvents.applyAttributeModifier(player, Attributes.f_22278_, KNOCKBACK_RESISTANCE_UUID, 0.05, AttributeModifier.Operation.ADDITION);
                    PeonyBathEvents.applyAttributeModifier(player, Attributes.f_22283_, ATTACK_SPEED_MODIFIER_UUID, 0.1, AttributeModifier.Operation.MULTIPLY_TOTAL);
                    EffectRemovalHandler.removeNegativeEffects(player);
                    EffectRemovalHandler.removeBadOmen(player);
                }
                if (playerData.m_128451_(enteredNumberInPeonyBath) >= 50) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19621_, 900, 45, false, false, true));
                }
                playerData.m_128405_(PEONY_BATH_EXITED_TIME, 0);
            } else {
                if (playerData.m_128471_(hasEnteredPeonyBath)) {
                    playerData.m_128379_(hasEnteredPeonyBath, false);
                }
                playerData.m_128405_(PEONY_BATH_EXITED_TIME, playerData.m_128451_(PEONY_BATH_EXITED_TIME) + 1);
                if (playerData.m_128451_(PEONY_BATH_EXITED_TIME) >= 300) {
                    PeonyBathEvents.removeAttributeModifier(player, Attributes.f_22283_, ATTACK_SPEED_MODIFIER_UUID);
                }
                if (playerData.m_128451_(PEONY_BATH_EXITED_TIME) >= 600) {
                    PeonyBathEvents.removeAttributeModifier(player, Attributes.f_22278_, KNOCKBACK_RESISTANCE_UUID);
                }
                playerData.m_128405_(peonyBathStayedTime, 0);
            }
        }
    }

    private static void applyAttributeModifier(ServerPlayer player, Attribute attribute, UUID uuid, double value, AttributeModifier.Operation operation) {
        AttributeInstance attributeInstance = player.m_21051_(attribute);
        if (attributeInstance != null) {
            AttributeModifier modifier = new AttributeModifier(uuid, attribute.m_22087_(), value, operation);
            if (attributeInstance.m_22111_(modifier.m_22209_()) != null) {
                attributeInstance.m_22120_(modifier.m_22209_());
            }
            attributeInstance.m_22125_(modifier);
        }
    }

    private static void removeAttributeModifier(ServerPlayer player, Attribute attribute, UUID uuid) {
        AttributeInstance attributeInstance = player.m_21051_(attribute);
        if (attributeInstance != null && attributeInstance.m_22111_(uuid) != null) {
            attributeInstance.m_22120_(uuid);
        }
    }
}

