/*
 * Decompiled with CFR 0.152.
 */
package com.crabmod.hotbath.events.enter_fluid_events;

import com.crabmod.hotbath.util.CustomFluidHandler;
import com.crabmod.hotbath.util.EffectRemovalHandler;
import com.crabmod.hotbath.util.HealthRegenHandler;
import com.crabmod.hotbath.util.HungerRegenHandler;
import java.util.Objects;
import net.minecraft.advancements.Advancement;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="hotbath")
public class MilkBathEvents {
    private static final int TICK_NUMBER = 20;
    static final String MILK_BATH_ENTERED_NUMBER = "MilkBathEnteredNumber";
    static final String MILK_BATH_STAYED_TIME = "MilkBathStayedTime";
    static final String HAS_ENTERED_MILK_BATH = "HasEnteredMilkBath";
    static final String MILK_BATH_ADVANCEMENT_ID = "hotbath:milk_skin";
    private static final int MILK_BATH_ENTERED_COUNT_TRIGGER_NUMBER = 100;
    private static final int MILK_BATH_STAYED_EFFECT_TRIGGER_TIME_SECONDS = 15;

    @SubscribeEvent
    public static void enterMilkBathEvents(LivingEvent.LivingTickEvent event) {
        MilkBathEvents.enterFluidEvents(event, 100, 15, MILK_BATH_ENTERED_NUMBER, MILK_BATH_STAYED_TIME, HAS_ENTERED_MILK_BATH, MILK_BATH_ADVANCEMENT_ID);
    }

    public static void enterFluidEvents(LivingEvent.LivingTickEvent event, int enteredCountTriggerNumber, int stayedEffectTriggerTime, String enteredNumberInMilkBath, String milkBathStayedTime, String hasEnteredMilkBath, String milkBathAdvancementId) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            CompoundTag playerData = player.getPersistentData();
            boolean isInMilkBath = CustomFluidHandler.isPlayerInMilkBathBlock((Player)player);
            if (isInMilkBath && player.m_6084_()) {
                MilkBathEvents.handleAdvancement(enteredCountTriggerNumber, enteredNumberInMilkBath, milkBathStayedTime, hasEnteredMilkBath, milkBathAdvancementId, player, playerData);
                HungerRegenHandler.regenHunger(1, 15.0f, player);
                HealthRegenHandler.regenHealth(0.25f, 2.0, player);
                if (playerData.m_128451_(milkBathStayedTime) >= stayedEffectTriggerTime * 20) {
                    EffectRemovalHandler.removeNegativeEffectsExceptUnluck(player);
                }
            } else {
                playerData.m_128405_(milkBathStayedTime, 0);
                playerData.m_128379_(hasEnteredMilkBath, false);
            }
        }
    }

    static void handleAdvancement(int enteredCountTriggerNumber, String enteredNumberInMilkBath, String milkBathStayedTime, String hasEnteredMilkBath, String milkBathAdvancementId, ServerPlayer player, CompoundTag playerData) {
        if (!playerData.m_128471_(hasEnteredMilkBath)) {
            Advancement advancement;
            int enteredCount = playerData.m_128451_(enteredNumberInMilkBath) + 1;
            playerData.m_128405_(enteredNumberInMilkBath, enteredCount);
            playerData.m_128379_(hasEnteredMilkBath, true);
            if (enteredCount >= enteredCountTriggerNumber && (advancement = Objects.requireNonNull(player.m_20194_()).m_129889_().m_136041_(Objects.requireNonNull(ResourceLocation.m_135820_((String)milkBathAdvancementId)))) != null) {
                player.m_8960_().m_135988_(advancement, "code_triggered");
                playerData.m_128405_(enteredNumberInMilkBath, 0);
            }
        }
        int hotBathTime = playerData.m_128451_(milkBathStayedTime) + 1;
        playerData.m_128405_(milkBathStayedTime, hotBathTime);
    }
}

