/*
 * Decompiled with CFR 0.152.
 */
package com.crabmod.hotbath.events.enter_fluid_events;

import com.crabmod.hotbath.util.CustomFluidHandler;
import java.util.Objects;
import net.minecraft.advancements.Advancement;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="hotbath")
public class HotWaterEvents {
    private static final int TICK_NUMBER = 20;
    static final String HOT_WATER_ENTERED_NUMBER = "HotWaterEnteredNumber";
    static final String HOT_WATER_STAYED_TIME = "HotWaterStayedTime";
    static final String HAS_ENTERED_HOT_WATER = "HasEnteredHotWater";
    static final String HOT_WATER_ADVANCEMENT_ID = "hotbath:foot_health";
    private static final int HOT_WATER_ENTERED_COUNT_TRIGGER_NUMBER = 100;
    private static final int HOT_WATER_STAYED_EFFECT_TRIGGER_TIME_SECONDS = 15;

    @SubscribeEvent
    public static void enterHotWaterEvents(LivingEvent.LivingTickEvent event) {
        HotWaterEvents.enterFluidEvents(event, 100, 15, HOT_WATER_ENTERED_NUMBER, HOT_WATER_STAYED_TIME, HAS_ENTERED_HOT_WATER, HOT_WATER_ADVANCEMENT_ID);
    }

    public static void enterFluidEvents(LivingEvent.LivingTickEvent event, int enteredCountTriggerNumber, int stayedEffectTriggerTime, String hotWaterEnteredNumber, String hotWaterStayedTime, String hasEnteredHotWater, String hotWaterAdvancementId) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            CompoundTag playerData = player.getPersistentData();
            boolean isInHotWater = CustomFluidHandler.isPlayerInHotWaterBlock((Player)player);
            if (isInHotWater && player.m_6084_()) {
                if (!playerData.m_128471_(hasEnteredHotWater)) {
                    Advancement advancement;
                    int enteredCount = playerData.m_128451_(hotWaterEnteredNumber) + 1;
                    playerData.m_128405_(hotWaterEnteredNumber, enteredCount);
                    playerData.m_128379_(hasEnteredHotWater, true);
                    if (enteredCount >= enteredCountTriggerNumber && (advancement = Objects.requireNonNull(player.m_20194_()).m_129889_().m_136041_(Objects.requireNonNull(ResourceLocation.m_135820_((String)hotWaterAdvancementId)))) != null) {
                        player.m_8960_().m_135988_(advancement, "code_triggered");
                        playerData.m_128405_(hotWaterEnteredNumber, 0);
                    }
                }
                int hotBathTime = playerData.m_128451_(hotWaterStayedTime) + 1;
                playerData.m_128405_(hotWaterStayedTime, hotBathTime);
                if (playerData.m_128451_(hotWaterStayedTime) >= stayedEffectTriggerTime * 20) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 400, 0, false, false, true));
                }
            } else {
                playerData.m_128405_(hotWaterStayedTime, 0);
                playerData.m_128379_(hasEnteredHotWater, false);
            }
        }
    }
}

