/*
 * Decompiled with CFR 0.152.
 */
package com.crabmod.hotbath.events.enter_fluid_events;

import com.crabmod.hotbath.util.CustomFluidHandler;
import com.crabmod.hotbath.util.EffectRemovalHandler;
import com.crabmod.hotbath.util.HealthRegenHandler;
import com.crabmod.hotbath.util.HungerRegenHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="hotbath")
public class HoneyBathEvents {
    private static final int TICK_NUMBER = 20;
    static final String HONEY_BATH_STAYED_TIME = "HoneyBathStayedTime";
    private static final int HONEY_BATH_STAYED_EFFECT_TRIGGER_TIME_SECONDS = 15;

    @SubscribeEvent
    public static void enterHoneyBathEvents(LivingEvent.LivingTickEvent event) {
        HoneyBathEvents.enterFluidEvents(event, 15, HONEY_BATH_STAYED_TIME);
    }

    public static void enterFluidEvents(LivingEvent.LivingTickEvent event, int stayedEffectTriggerTime, String honeyBathStayedTime) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            CompoundTag playerData = player.getPersistentData();
            boolean isInHoneyBath = CustomFluidHandler.isPlayerInHoneyBathBlock((Player)player);
            if (isInHoneyBath && player.m_6084_()) {
                int honeyBathTime = playerData.m_128451_(honeyBathStayedTime) + 1;
                playerData.m_128405_(honeyBathStayedTime, honeyBathTime);
                HealthRegenHandler.regenHealth(0.25f, 1.0, player);
                HungerRegenHandler.regenHunger(1, 4.0f, player);
                player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 0, false, false, true));
                if (playerData.m_128451_(honeyBathStayedTime) >= stayedEffectTriggerTime * 20) {
                    EffectRemovalHandler.removeNegativeEffectsExceptSlowAndUnluck(player);
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 400, 1, false, false, true));
                }
            } else {
                playerData.m_128405_(honeyBathStayedTime, 0);
            }
        }
    }
}

