/*
 * Decompiled with CFR 0.152.
 */
package com.crabmod.hotbath.events.enter_fluid_events;

import com.crabmod.hotbath.util.CustomFluidHandler;
import com.crabmod.hotbath.util.EffectRemovalHandler;
import com.crabmod.hotbath.util.HealthRegenHandler;
import com.crabmod.hotbath.util.ResistanceBoostHandler;
import java.util.Objects;
import net.minecraft.advancements.Advancement;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="hotbath")
public class HerbalBathEvents {
    private static final int TICK_NUMBER = 20;
    static final String HERBAL_BATH_ENTERED_NUMBER = "HerbalBathEnteredNumber";
    static final String HERBAL_BATH_STAYED_TIME = "HerbalBathStayedTime";
    static final String HAS_ENTERED_HERBAL_BATH = "HasEnteredHerbalBath";
    static final String HERBAL_BATH_ADVANCEMENT_ID = "hotbath:chronic_invalid";
    private static final int HERBAL_BATH_ENTERED_COUNT_TRIGGER_NUMBER = 100;
    private static final int HERBAL_BATH_STAYED_EFFECT_TRIGGER_TIME_SECONDS = 5;

    @SubscribeEvent
    public static void enterHerbalBathBlockEvent(LivingEvent.LivingTickEvent event) {
        HerbalBathEvents.enterFluidEvents(event, 100, 5, HERBAL_BATH_ENTERED_NUMBER, HERBAL_BATH_STAYED_TIME, HAS_ENTERED_HERBAL_BATH, HERBAL_BATH_ADVANCEMENT_ID);
    }

    public static void enterFluidEvents(LivingEvent.LivingTickEvent event, int enteredCountTriggerNumber, int stayedEffectTriggerTime, String enteredNumberInHerbalBath, String herbalBathStayedTime, String hasEnteredHerbalBath, String herbalBathAdvancementId) {
        if (!(event.getEntity() instanceof ServerPlayer)) {
            boolean isInHerbalBath;
            if ((event.getEntity() instanceof Zombie || event.getEntity() instanceof Skeleton) && (isInHerbalBath = CustomFluidHandler.isEntityInHerbalBathBlock((Entity)event.getEntity()))) {
                int damageIntervalTicks = 20;
                float damagePerSecond = 0.5f;
                if (event.getEntity().f_19797_ % damageIntervalTicks == 0) {
                    Level level = event.getEntity().m_9236_();
                    event.getEntity().m_6469_(level.m_269111_().m_269425_(), damagePerSecond);
                }
            }
            return;
        }
        boolean isInHerbalBath = CustomFluidHandler.isPlayerInHerbalBathBlock((Player)((ServerPlayer)event.getEntity()));
        LivingEntity damagePerSecond = event.getEntity();
        if (damagePerSecond instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)damagePerSecond;
            CompoundTag playerData = player.getPersistentData();
            if (isInHerbalBath && player.m_6084_()) {
                if (!playerData.m_128471_(hasEnteredHerbalBath)) {
                    Advancement advancement;
                    int enteredCount = playerData.m_128451_(enteredNumberInHerbalBath) + 1;
                    playerData.m_128405_(enteredNumberInHerbalBath, enteredCount);
                    playerData.m_128379_(hasEnteredHerbalBath, true);
                    if (enteredCount >= enteredCountTriggerNumber && (advancement = Objects.requireNonNull(player.m_20194_()).m_129889_().m_136041_(Objects.requireNonNull(ResourceLocation.m_135820_((String)herbalBathAdvancementId)))) != null) {
                        player.m_8960_().m_135988_(advancement, "code_triggered");
                        playerData.m_128405_(enteredNumberInHerbalBath, 0);
                    }
                }
                int hotBathTime = playerData.m_128451_(herbalBathStayedTime) + 1;
                playerData.m_128405_(herbalBathStayedTime, hotBathTime);
                HealthRegenHandler.regenHealth(0.25f, 2.0, player);
                if (playerData.m_128451_(herbalBathStayedTime) >= stayedEffectTriggerTime * 20) {
                    ResistanceBoostHandler.applyResistanceBoost(10, player);
                }
                if (playerData.m_128451_(herbalBathStayedTime) >= 300) {
                    EffectRemovalHandler.removeNegativeEffects(player);
                }
            } else {
                playerData.m_128405_(herbalBathStayedTime, 0);
                playerData.m_128379_(hasEnteredHerbalBath, false);
            }
        }
    }
}

