/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Hashing;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.client.screen.ConfigScreen;
import com.mrcrayfish.configured.client.screen.ListMenuScreen;
import com.mrcrayfish.configured.client.screen.ModConfigSelectionScreen;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import com.mrcrayfish.configured.platform.Services;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import org.apache.commons.io.file.PathUtils;

public class WorldSelectionScreen
extends ListMenuScreen {
    private static final LevelResource SERVER_CONFIG_FOLDER = Services.CONFIG.getServerConfigResource();
    private static final ResourceLocation MISSING_ICON = new ResourceLocation("textures/misc/unknown_server.png");
    private final IModConfig config;

    public WorldSelectionScreen(Screen parent, ResourceLocation background, IModConfig config, Component title) {
        super(parent, (Component)Component.m_237110_((String)"configured.gui.edit_world_config", (Object[])new Object[]{title.m_6879_().m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GOLD})}), background, 30);
        this.config = config;
    }

    @Override
    protected void constructEntries(List<ListMenuScreen.Item> entries) {
        try {
            LevelStorageSource source = Minecraft.m_91087_().m_91392_();
            ArrayList levels = new ArrayList((Collection)source.m_230813_(source.m_230833_()).join());
            if (levels.size() > 6) {
                entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem((Component)Component.m_237115_((String)"configured.gui.title.recently_played").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.YELLOW})));
                List<LevelSummary> recent = levels.stream().sorted(Comparator.comparing(s -> -s.m_78366_())).limit(3L).toList();
                recent.forEach(summary -> entries.add(new WorldItem((LevelSummary)summary)));
                levels.removeAll(recent);
                entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem((Component)Component.m_237115_((String)"configured.gui.title.other_worlds").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.YELLOW})));
            }
            levels.stream().sorted(Comparator.comparing(LevelSummary::m_78361_)).forEach(summary -> entries.add(new WorldItem((LevelSummary)summary)));
        }
        catch (LevelStorageException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)ScreenUtil.button(this.f_96543_ / 2 - 75, this.f_96544_ - 29, 150, 20, CommonComponents.f_130660_, button -> this.f_96541_.m_91152_(this.parent)));
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)(this.f_96543_ - 30), 15.0f, 0.0f);
        graphics.m_280168_().m_85841_(2.5f, 2.5f, 2.5f);
        graphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)"?").m_130940_(ChatFormatting.BOLD), 0, 0, 0xFFFFFF);
        graphics.m_280168_().m_85849_();
    }

    @Override
    protected void updateTooltip(int mouseX, int mouseY) {
        super.updateTooltip(mouseX, mouseY);
        if (ScreenUtil.isMouseWithin(this.f_96543_ - 30, 15, 23, 23, mouseX, mouseY)) {
            this.setActiveTooltip((Component)Component.m_237115_((String)"configured.gui.server_config_info"));
        }
    }

    public void m_7379_() {
        super.m_7379_();
        this.entries.forEach(item -> {
            if (item instanceof WorldItem) {
                ((WorldItem)item).disposeIcon();
            }
        });
    }

    public class WorldItem
    extends ListMenuScreen.Item {
        private final Component worldName;
        private final Component folderName;
        private final ResourceLocation iconId;
        private Path iconFile;
        private final DynamicTexture texture;
        private final Button modifyButton;

        public WorldItem(LevelSummary summary) {
            super(summary.m_78361_());
            this.worldName = Component.m_237113_((String)summary.m_78361_());
            this.folderName = Component.m_237113_((String)summary.m_78358_()).m_130940_(ChatFormatting.DARK_GRAY);
            this.iconId = new ResourceLocation("minecraft", "worlds/" + Util.m_137483_((String)summary.m_78358_(), ResourceLocation::m_135828_) + "/" + Hashing.sha1().hashUnencodedChars((CharSequence)summary.m_78358_()) + "/icon");
            this.iconFile = summary.m_230875_();
            if (!Files.isRegularFile(this.iconFile, new LinkOption[0])) {
                this.iconFile = null;
            }
            this.texture = this.loadWorldIcon();
            this.modifyButton = new IconButton(0, 0, 0, this.getIconV(), 60, this.getButtonLabel(), onPress -> this.loadWorldConfig(summary.m_78358_(), summary.m_78361_()));
        }

        private Component getButtonLabel() {
            if (WorldSelectionScreen.this.config.isReadOnly()) {
                return Component.m_237115_((String)"configured.gui.view");
            }
            return Component.m_237115_((String)"configured.gui.select");
        }

        private int getIconV() {
            if (WorldSelectionScreen.this.config.isReadOnly()) {
                return 33;
            }
            return 22;
        }

        @Override
        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.modifyButton);
        }

        @Override
        public void m_6311_(GuiGraphics graphics, int x, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean p_230432_9_, float partialTicks) {
            if (x % 2 != 0) {
                graphics.m_280509_(left, top, left + width, top + 24, 0x55000000);
            }
            if (this.modifyButton.m_5953_((double)mouseX, (double)mouseY)) {
                graphics.m_280509_(left - 1, top - 1, left + 25, top + 25, -1);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.m_280411_(this.texture != null ? this.iconId : MISSING_ICON, left, top, 24, 24, 0.0f, 0.0f, 64, 64, 64, 64);
            graphics.m_280430_(((WorldSelectionScreen)WorldSelectionScreen.this).f_96541_.f_91062_, this.worldName, left + 30, top + 3, 0xFFFFFF);
            graphics.m_280430_(((WorldSelectionScreen)WorldSelectionScreen.this).f_96541_.f_91062_, this.folderName, left + 30, top + 13, 0xFFFFFF);
            this.modifyButton.m_252865_(left + width - 61);
            this.modifyButton.m_253211_(top + 2);
            this.modifyButton.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }

        /*
         * Enabled aggressive exception aggregation
         */
        private DynamicTexture loadWorldIcon() {
            if (this.iconFile == null) {
                return null;
            }
            try (InputStream is = Files.newInputStream(this.iconFile, new OpenOption[0]);){
                DynamicTexture dynamicTexture;
                block19: {
                    NativeImage image;
                    block17: {
                        DynamicTexture dynamicTexture2;
                        block18: {
                            image = NativeImage.m_85058_((InputStream)is);
                            try {
                                if (image.m_84982_() == 64 && image.m_85084_() == 64) break block17;
                                dynamicTexture2 = null;
                                if (image == null) break block18;
                            }
                            catch (Throwable throwable) {
                                if (image != null) {
                                    try {
                                        image.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            image.close();
                        }
                        return dynamicTexture2;
                    }
                    DynamicTexture texture = new DynamicTexture(image);
                    WorldSelectionScreen.this.f_96541_.m_91097_().m_118495_(this.iconId, (AbstractTexture)texture);
                    dynamicTexture = texture;
                    if (image == null) break block19;
                    image.close();
                }
                return dynamicTexture;
            }
            catch (IOException iOException) {
                return null;
            }
        }

        public void disposeIcon() {
            if (this.texture != null) {
                this.texture.close();
            }
        }

        private void loadWorldConfig(String worldFileName, String worldName) {
            try (LevelStorageSource.LevelStorageAccess storageAccess = Minecraft.m_91087_().m_91392_().m_78260_(worldFileName);){
                Path worldConfigPath = storageAccess.m_78283_(SERVER_CONFIG_FOLDER);
                PathUtils.createParentDirectories((Path)worldConfigPath, (FileAttribute[])new FileAttribute[0]);
                if (!Files.isDirectory(worldConfigPath, new LinkOption[0])) {
                    Files.createDirectory(worldConfigPath, new FileAttribute[0]);
                }
                WorldSelectionScreen.this.config.loadWorldConfig(worldConfigPath, (IModConfig T) -> {
                    if (Services.PLATFORM.isModLoaded(T.getModId())) {
                        MutableComponent configName = Component.m_237113_((String)ModConfigSelectionScreen.createLabelFromModConfig(WorldSelectionScreen.this.config));
                        MutableComponent newTitle = Component.m_237113_((String)worldName).m_6881_().m_7220_((Component)Component.m_237113_((String)" > ").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})).m_7220_((Component)configName);
                        WorldSelectionScreen.this.f_96541_.m_91152_((Screen)new ConfigScreen(WorldSelectionScreen.this.parent, (Component)newTitle, (IModConfig)T, WorldSelectionScreen.this.background));
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

