/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.network;

import com.iafenvoy.jupiter.Jupiter;
import com.iafenvoy.jupiter.ServerConfigManager;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.network.ByteBufUtil;
import com.iafenvoy.jupiter.network.NetworkConstants;
import com.iafenvoy.jupiter.network.ServerNetworkHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class ServerConfigNetwork {
    public static void init() {
        ServerNetworkHelper.registerReceiver(NetworkConstants.CONFIG_REQUEST_C2S, (server, player, buf) -> {
            ResourceLocation id = buf.m_130281_();
            Jupiter.LOGGER.info("Player {} request to get config {}", (Object)player.m_7755_().getString(), (Object)id);
            FriendlyByteBuf b = ByteBufUtil.create().m_130085_(id);
            if (ServerConfigManager.checkPermission(id, server, player, false)) {
                b.writeBoolean(true);
                AbstractConfigContainer data = ServerConfigManager.getConfig(id);
                assert (data != null);
                b.m_130079_((CompoundTag)data.serializeNbt());
            } else {
                b.writeBoolean(false);
            }
            return () -> ServerNetworkHelper.sendToPlayer(player, NetworkConstants.CONFIG_SYNC_S2C, b);
        });
        ServerNetworkHelper.registerReceiver(NetworkConstants.CONFIG_SYNC_C2S, (server, player, buf) -> {
            ResourceLocation id = buf.m_130281_();
            Jupiter.LOGGER.info("Player {} request to change config {}", (Object)player.m_7755_().getString(), (Object)id);
            CompoundTag data = buf.m_130260_();
            return () -> {
                if (ServerConfigManager.checkPermission(id, server, player, true)) {
                    AbstractConfigContainer container = ServerConfigManager.getConfig(id);
                    if (container != null) {
                        Jupiter.LOGGER.info(data.toString());
                        container.deserializeNbt((Tag)data);
                        container.onConfigsChanged();
                        Jupiter.LOGGER.info("Player {} changed config {}", (Object)player.m_7755_().getString(), (Object)id);
                    }
                } else {
                    ServerNetworkHelper.sendToPlayer(player, NetworkConstants.CONFIG_ERROR_S2C, ByteBufUtil.create());
                }
            };
        });
    }
}

