/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.forge.network;

import com.iafenvoy.jupiter.forge.JupiterForge;
import com.iafenvoy.jupiter.forge.network.PacketByteBufS2C;
import com.iafenvoy.jupiter.network.ServerNetworkHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class ServerNetworkContainer {
    private static final Map<ResourceLocation, ServerNetworkHelper.Handler> HANDLERS = new HashMap<ResourceLocation, ServerNetworkHelper.Handler>();

    public static void registerReceiver(ResourceLocation id, ServerNetworkHelper.Handler handler) {
        HANDLERS.put(id, handler);
    }

    public static boolean onReceive(ResourceLocation id, FriendlyByteBuf buf, NetworkEvent.Context context) {
        ServerNetworkHelper.Handler handler = HANDLERS.get(id);
        if (handler == null) {
            return false;
        }
        if (context.getSender() == null) {
            return false;
        }
        Runnable runnable = handler.handle(context.getSender().f_8924_, context.getSender(), buf);
        if (runnable != null) {
            context.enqueueWork(runnable);
        }
        return true;
    }

    public static void sendToPlayer(ServerPlayer player, ResourceLocation id, FriendlyByteBuf buf) {
        JupiterForge.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketByteBufS2C(id, buf));
    }
}

