/*
 * Decompiled with CFR 0.152.
 */
package com.prunoideae.powerfuljs.capabilities.forge.mods.curios;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.prunoideae.powerfuljs.capabilities.forge.CapabilityBuilderForge;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class CapabilityCurios {
    public ItemStackBuilder itemStack() {
        return new ItemStackBuilder();
    }

    public static class ItemStackBuilder
    extends CapabilityBuilderForge<ItemStack, ICurio> {
        private BiConsumer<ItemStack, SlotContext> curioTick;
        private EquipCallback onEquip;
        private EquipCallback onUnequip;
        private BiPredicate<ItemStack, SlotContext> canEquip;
        private BiPredicate<ItemStack, SlotContext> canUnequip;
        private ShouldDrop shouldDrop;
        private final Multimap<ResourceLocation, AttributeModifier> modifiers = HashMultimap.create();
        private final Multimap<Attribute, AttributeModifier> attributes = HashMultimap.create();
        private Consumer<AttributeModificationContext> dynamicAttribute = null;
        private boolean attributeInitialized = false;

        public ItemStackBuilder curioTick(BiConsumer<ItemStack, SlotContext> curioTick) {
            this.curioTick = curioTick;
            return this;
        }

        public ItemStackBuilder onEquip(EquipCallback onEquip) {
            this.onEquip = onEquip;
            return this;
        }

        public ItemStackBuilder onUnequip(EquipCallback onUnequip) {
            this.onUnequip = onUnequip;
            return this;
        }

        public ItemStackBuilder canEquip(BiPredicate<ItemStack, SlotContext> canEquip) {
            this.canEquip = canEquip;
            return this;
        }

        public ItemStackBuilder canUnequip(BiPredicate<ItemStack, SlotContext> canUnequip) {
            this.canUnequip = canUnequip;
            return this;
        }

        public ItemStackBuilder getDropRule(ShouldDrop getDropRule) {
            this.shouldDrop = getDropRule;
            return this;
        }

        public ItemStackBuilder modifyAttribute(ResourceLocation attribute, String identifier, double d, AttributeModifier.Operation operation) {
            this.modifiers.put((Object)attribute, (Object)new AttributeModifier(new UUID(identifier.hashCode(), identifier.hashCode()), identifier, d, operation));
            return this;
        }

        public ItemStackBuilder dynamicAttribute(Consumer<AttributeModificationContext> context) {
            this.dynamicAttribute = context;
            return this;
        }

        @Override
        public ICurio getCapability(final ItemStack instance) {
            return new ICurio(){

                public ItemStack getStack() {
                    return instance;
                }

                public void curioTick(SlotContext slotContext) {
                    if (curioTick != null) {
                        curioTick.accept(instance, slotContext);
                    } else {
                        super.curioTick(slotContext);
                    }
                }

                public void onEquip(SlotContext slotContext, ItemStack prevStack) {
                    if (onEquip != null) {
                        onEquip.changed(instance, slotContext, prevStack);
                    } else {
                        super.onEquip(slotContext, prevStack);
                    }
                }

                public void onUnequip(SlotContext slotContext, ItemStack newStack) {
                    if (onUnequip != null) {
                        onUnequip.changed(instance, slotContext, newStack);
                    } else {
                        super.onUnequip(slotContext, newStack);
                    }
                }

                public boolean canEquip(SlotContext slotContext) {
                    if (canEquip != null) {
                        return canEquip.test(instance, slotContext);
                    }
                    return super.canEquip(slotContext);
                }

                public boolean canUnequip(SlotContext slotContext) {
                    if (canUnequip != null) {
                        return canUnequip.test(instance, slotContext);
                    }
                    return super.canUnequip(slotContext);
                }

                public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid) {
                    if (!attributeInitialized) {
                        for (Map.Entry entry : modifiers.entries()) {
                            ResourceLocation key = (ResourceLocation)entry.getKey();
                            AttributeModifier modifier = (AttributeModifier)entry.getValue();
                            attributes.put((Object)((Attribute)RegistryInfo.ATTRIBUTE.getValue(key)), (Object)modifier);
                        }
                        attributeInitialized = true;
                    }
                    if (dynamicAttribute != null) {
                        HashMultimap attributeCopy = HashMultimap.create(attributes);
                        dynamicAttribute.accept(new AttributeModificationContext(instance, slotContext, uuid, (Multimap<Attribute, AttributeModifier>)attributeCopy));
                        return attributeCopy;
                    }
                    return attributes;
                }

                @NotNull
                public ICurio.DropRule getDropRule(SlotContext slotContext, DamageSource source, int lootingLevel, boolean recentlyHit) {
                    if (shouldDrop != null) {
                        return shouldDrop.test(instance, slotContext, source, lootingLevel, recentlyHit) ? ICurio.DropRule.ALWAYS_DROP : ICurio.DropRule.ALWAYS_KEEP;
                    }
                    return ICurio.DropRule.DEFAULT;
                }

                public boolean canEquipFromUse(SlotContext slotContext) {
                    return true;
                }
            };
        }

        @Override
        public Capability<ICurio> getCapabilityKey() {
            return CuriosCapability.ITEM;
        }

        @Override
        public ResourceLocation getResourceLocation() {
            return CuriosCapability.ID_ITEM;
        }
    }

    public static class AttributeModificationContext {
        private final ItemStack stack;
        private final SlotContext context;
        private final UUID uuid;
        private final Multimap<Attribute, AttributeModifier> modifiers;

        public AttributeModificationContext(ItemStack stack, SlotContext context, UUID uuid, Multimap<Attribute, AttributeModifier> modifiers) {
            this.stack = stack;
            this.context = context;
            this.uuid = uuid;
            this.modifiers = modifiers;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public SlotContext getContext() {
            return this.context;
        }

        public UUID getUUID() {
            return this.uuid;
        }

        public AttributeModificationContext modify(Attribute attribute, String identifier, double amount, AttributeModifier.Operation operation) {
            this.modifiers.put((Object)attribute, (Object)new AttributeModifier(new UUID(identifier.hashCode(), identifier.hashCode()), identifier, amount, operation));
            return this;
        }

        public AttributeModificationContext remove(Attribute attribute, String identifier) {
            this.modifiers.get((Object)attribute).removeIf(modifier -> modifier.m_22214_().equals(identifier));
            return this;
        }

        @HideFromJS
        public Multimap<Attribute, AttributeModifier> getModifiers() {
            return this.modifiers;
        }
    }

    @FunctionalInterface
    public static interface ShouldDrop {
        public boolean test(ItemStack var1, SlotContext var2, DamageSource var3, int var4, boolean var5);
    }

    @FunctionalInterface
    public static interface EquipCallback {
        public void changed(ItemStack var1, SlotContext var2, ItemStack var3);
    }
}

