/*
 * Decompiled with CFR 0.152.
 */
package com.prunoideae.powerfuljs.capabilities.forge;

import com.prunoideae.powerfuljs.capabilities.forge.CapabilityBuilderForge;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;

public class CapabilityForgeEnergy {
    public ItemStorageBuilder normalItemStack(int capacity, boolean canExtract, boolean canReceive) {
        return new ItemStorageBuilder(capacity, canExtract, canReceive);
    }

    public ItemStackBuilder customItemStack() {
        return new ItemStackBuilder();
    }

    public BlockEntityBuilder customBlockEntity() {
        return new BlockEntityBuilder();
    }

    public static class ItemStorageBuilder
    extends CapabilityBuilderForge<ItemStack, IEnergyStorage> {
        private final int capacity;
        private final boolean canExtract;
        private final boolean canReceive;
        private int receiveRate = Integer.MAX_VALUE;
        private int extractRate = Integer.MAX_VALUE;
        private static final String ENERGY_TAG = "pjs:fe_energy";

        public ItemStorageBuilder(int capacity, boolean canExtract, boolean canReceive) {
            this.capacity = capacity;
            this.canExtract = canExtract;
            this.canReceive = canReceive;
        }

        public ItemStorageBuilder receiveRate(int receiveRate) {
            this.receiveRate = receiveRate;
            return this;
        }

        public ItemStorageBuilder extractRate(int extractRate) {
            this.extractRate = extractRate;
            return this;
        }

        @Override
        public IEnergyStorage getCapability(final ItemStack instance) {
            return new IEnergyStorage(){

                public int receiveEnergy(int i, boolean bl) {
                    if (!canReceive) {
                        return 0;
                    }
                    int received = Math.min(receiveRate, Math.min(this.getMaxEnergyStored() - this.getEnergyStored(), i));
                    if (!bl) {
                        instance.m_41784_().m_128405_(ItemStorageBuilder.ENERGY_TAG, received + this.getEnergyStored());
                    }
                    return received;
                }

                public int extractEnergy(int i, boolean bl) {
                    if (!canExtract) {
                        return 0;
                    }
                    int extracted = Math.min(extractRate, Math.min(this.getEnergyStored(), i));
                    if (!bl) {
                        instance.m_41784_().m_128405_(ItemStorageBuilder.ENERGY_TAG, this.getEnergyStored() - extracted);
                    }
                    return extracted;
                }

                public int getEnergyStored() {
                    return instance.m_41784_().m_128451_(ItemStorageBuilder.ENERGY_TAG);
                }

                public int getMaxEnergyStored() {
                    return capacity;
                }

                public boolean canExtract() {
                    return canExtract;
                }

                public boolean canReceive() {
                    return canReceive;
                }
            };
        }

        @Override
        public Capability<IEnergyStorage> getCapabilityKey() {
            return ForgeCapabilities.ENERGY;
        }

        @Override
        public ResourceLocation getResourceLocation() {
            return new ResourceLocation("powerful:fe_item");
        }
    }

    public static class ItemStackBuilder
    extends CapabilityBuilderForge<ItemStack, IEnergyStorage> {
        private EnergyIOItemStack receiveEnergy;
        private EnergyIOItemStack extractEnergy;
        private ToIntFunction<ItemStack> getEnergyStored;
        private ToIntFunction<ItemStack> getMaxEnergyStored;
        private Predicate<ItemStack> canExtract;
        private Predicate<ItemStack> canReceive;

        public ItemStackBuilder getEnergyStored(ToIntFunction<ItemStack> getEnergyStored) {
            this.getEnergyStored = getEnergyStored;
            return this;
        }

        public ItemStackBuilder withCapacity(int capacity) {
            return this.getMaxEnergyStored(i -> capacity);
        }

        public ItemStackBuilder getMaxEnergyStored(ToIntFunction<ItemStack> getMaxEnergyStored) {
            this.getMaxEnergyStored = getMaxEnergyStored;
            return this;
        }

        public ItemStackBuilder canExtract(Predicate<ItemStack> canExtract) {
            this.canExtract = canExtract;
            return this;
        }

        public ItemStackBuilder canReceive(Predicate<ItemStack> canReceive) {
            this.canReceive = canReceive;
            return this;
        }

        public ItemStackBuilder receiveEnergy(EnergyIOItemStack receiveEnergy) {
            this.receiveEnergy = receiveEnergy;
            return this;
        }

        public ItemStackBuilder extractEnergy(EnergyIOItemStack extractEnergy) {
            this.extractEnergy = extractEnergy;
            return this;
        }

        @Override
        @HideFromJS
        public IEnergyStorage getCapability(final ItemStack instance) {
            return new IEnergyStorage(){

                public int receiveEnergy(int i, boolean bl) {
                    return receiveEnergy == null ? 0 : receiveEnergy.transfer(instance, i, bl);
                }

                public int extractEnergy(int i, boolean bl) {
                    return extractEnergy == null ? 0 : extractEnergy.transfer(instance, i, bl);
                }

                public int getEnergyStored() {
                    return getEnergyStored == null ? 0 : getEnergyStored.applyAsInt(instance);
                }

                public int getMaxEnergyStored() {
                    return getMaxEnergyStored == null ? 0 : getMaxEnergyStored.applyAsInt(instance);
                }

                public boolean canExtract() {
                    return canExtract != null && canExtract.test(instance);
                }

                public boolean canReceive() {
                    return canReceive != null && canReceive.test(instance);
                }
            };
        }

        @Override
        @HideFromJS
        public Capability<IEnergyStorage> getCapabilityKey() {
            return ForgeCapabilities.ENERGY;
        }

        @Override
        @HideFromJS
        public ResourceLocation getResourceLocation() {
            return new ResourceLocation("powerful:fe_item_custom");
        }
    }

    public static class BlockEntityBuilder
    extends CapabilityBuilderForge<BlockEntity, IEnergyStorage> {
        private EnergyIOBlockEntity receiveEnergy;
        private EnergyIOBlockEntity extractEnergy;
        private ToIntFunction<BlockEntity> getEnergyStored;
        private ToIntFunction<BlockEntity> getMaxEnergyStored;
        private Predicate<BlockEntity> canExtract;
        private Predicate<BlockEntity> canReceive;

        public BlockEntityBuilder receiveEnergy(EnergyIOBlockEntity receiveEnergy) {
            this.receiveEnergy = receiveEnergy;
            return this;
        }

        public BlockEntityBuilder extractEnergy(EnergyIOBlockEntity extractEnergy) {
            this.extractEnergy = extractEnergy;
            return this;
        }

        public BlockEntityBuilder getEnergyStored(ToIntFunction<BlockEntity> getEnergyStored) {
            this.getEnergyStored = getEnergyStored;
            return this;
        }

        public BlockEntityBuilder withCapacity(int capacity) {
            return this.getMaxEnergyStored(be -> capacity);
        }

        public BlockEntityBuilder getMaxEnergyStored(ToIntFunction<BlockEntity> getMaxEnergyStored) {
            this.getMaxEnergyStored = getMaxEnergyStored;
            return this;
        }

        public BlockEntityBuilder canExtract(Predicate<BlockEntity> canExtract) {
            this.canExtract = canExtract;
            return this;
        }

        public BlockEntityBuilder canReceive(Predicate<BlockEntity> canReceive) {
            this.canReceive = canReceive;
            return this;
        }

        @Override
        @HideFromJS
        public IEnergyStorage getCapability(final BlockEntity instance) {
            return new IEnergyStorage(){

                public int receiveEnergy(int i, boolean bl) {
                    return receiveEnergy == null ? 0 : receiveEnergy.transfer(instance, i, bl);
                }

                public int extractEnergy(int i, boolean bl) {
                    return extractEnergy == null ? 0 : extractEnergy.transfer(instance, i, bl);
                }

                public int getEnergyStored() {
                    return getEnergyStored == null ? 0 : getEnergyStored.applyAsInt(instance);
                }

                public int getMaxEnergyStored() {
                    return getMaxEnergyStored == null ? 0 : getMaxEnergyStored.applyAsInt(instance);
                }

                public boolean canExtract() {
                    return canExtract != null && canExtract.test(instance);
                }

                public boolean canReceive() {
                    return canReceive != null && canReceive.test(instance);
                }
            };
        }

        @Override
        @HideFromJS
        public Capability<IEnergyStorage> getCapabilityKey() {
            return ForgeCapabilities.ENERGY;
        }

        @Override
        @HideFromJS
        public ResourceLocation getResourceLocation() {
            return new ResourceLocation("powerful:fe_be_custom");
        }
    }

    @FunctionalInterface
    public static interface EnergyIOBlockEntity {
        public int transfer(BlockEntity var1, int var2, boolean var3);
    }

    @FunctionalInterface
    public static interface EnergyIOItemStack {
        public int transfer(ItemStack var1, int var2, boolean var3);
    }
}

