/*
 * Decompiled with CFR 0.152.
 */
package com.prunoideae.powerfuljs.capabilities.forge;

import com.prunoideae.powerfuljs.capabilities.forge.CapabilityBuilderForge;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.forge.FluidStackHooksForge;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import org.jetbrains.annotations.NotNull;

public class CapabilityFluid {
    public NormalTankBuilderItemStack itemStack(int capacity) {
        return new NormalTankBuilderItemStack(capacity);
    }

    public CustomTankBuilderItemStack customItemStack() {
        return new CustomTankBuilderItemStack();
    }

    public CustomTankBuilderBlockEntity customBlockEntity() {
        return new CustomTankBuilderBlockEntity();
    }

    public static class NormalTankBuilderItemStack
    extends CapabilityBuilderForge<ItemStack, IFluidHandlerItem> {
        private final int capacity;

        private NormalTankBuilderItemStack(int capacity) {
            this.capacity = capacity;
        }

        @Override
        public IFluidHandlerItem getCapability(ItemStack instance) {
            return new FluidHandlerItemStack(instance, this.capacity);
        }

        @Override
        public Capability<IFluidHandlerItem> getCapabilityKey() {
            return ForgeCapabilities.FLUID_HANDLER_ITEM;
        }

        @Override
        public ResourceLocation getResourceLocation() {
            return new ResourceLocation("powerful:normal_tank_item");
        }
    }

    public static class CustomTankBuilderItemStack
    extends CapabilityBuilderForge<ItemStack, IFluidHandlerItem> {
        private FluidIOItemStack onFill;
        private FluidIOItemStack onDrain;
        private BiPredicate<ItemStack, FluidStackJS> isFluidGood;
        private ToIntFunction<ItemStack> getCapacity;

        public CustomTankBuilderItemStack withCapacity(int capacity) {
            return this.getCapacity(i -> capacity);
        }

        public CustomTankBuilderItemStack getCapacity(ToIntFunction<ItemStack> getCapacity) {
            this.getCapacity = getCapacity;
            return this;
        }

        public CustomTankBuilderItemStack acceptFluid(Fluid fluid) {
            return this.isFluidGood((i, fluidStackJS) -> fluidStackJS.getFluid() == fluid);
        }

        public CustomTankBuilderItemStack isFluidGood(BiPredicate<ItemStack, FluidStackJS> isFluidGood) {
            this.isFluidGood = isFluidGood;
            return this;
        }

        public CustomTankBuilderItemStack onFill(FluidIOItemStack onFill) {
            this.onFill = onFill;
            return this;
        }

        public CustomTankBuilderItemStack onDrain(FluidIOItemStack onDrain) {
            this.onDrain = onDrain;
            return this;
        }

        @Override
        @HideFromJS
        public IFluidHandlerItem getCapability(ItemStack instance) {
            return new FluidHandlerItemStackCustom(instance, 1000, this.onFill, this.onDrain, this.isFluidGood, this.getCapacity);
        }

        @Override
        @HideFromJS
        public Capability<IFluidHandlerItem> getCapabilityKey() {
            return ForgeCapabilities.FLUID_HANDLER_ITEM;
        }

        @Override
        @HideFromJS
        public ResourceLocation getResourceLocation() {
            return new ResourceLocation("powerful:custom_tank_item");
        }
    }

    public static class CustomTankBuilderBlockEntity
    extends CapabilityBuilderForge<BlockEntity, IFluidHandler> {
        private FluidIOBlockEntity onFill;
        private FluidIOBlockEntity onDrain;
        private BiPredicate<BlockEntity, FluidStackJS> isFluidGood;
        private ToIntFunction<BlockEntity> getCapacity;
        private Function<BlockEntity, FluidStackJS> getFluid;

        public CustomTankBuilderBlockEntity onFill(FluidIOBlockEntity onFill) {
            this.onFill = onFill;
            return this;
        }

        public CustomTankBuilderBlockEntity onDrain(FluidIOBlockEntity onDrain) {
            this.onDrain = onDrain;
            return this;
        }

        public CustomTankBuilderBlockEntity isFluidGood(BiPredicate<BlockEntity, FluidStackJS> isFluidGood) {
            this.isFluidGood = isFluidGood;
            return this;
        }

        public CustomTankBuilderBlockEntity getCapacity(ToIntFunction<BlockEntity> getCapacity) {
            this.getCapacity = getCapacity;
            return this;
        }

        public CustomTankBuilderBlockEntity getFluid(Function<BlockEntity, FluidStackJS> getFluid) {
            this.getFluid = getFluid;
            return this;
        }

        @Override
        public IFluidHandler getCapability(final BlockEntity instance) {
            return new IFluidHandler(){

                public int getTanks() {
                    return 1;
                }

                @NotNull
                public net.minecraftforge.fluids.FluidStack getFluidInTank(int i) {
                    return getFluid != null ? FluidStackHooksForge.toForge((FluidStack)getFluid.apply(instance).getFluidStack()) : net.minecraftforge.fluids.FluidStack.EMPTY;
                }

                public int getTankCapacity(int i) {
                    return getCapacity != null ? getCapacity.applyAsInt(instance) : 1000;
                }

                public boolean isFluidValid(int i, @NotNull net.minecraftforge.fluids.FluidStack fluidStack) {
                    return isFluidGood == null || isFluidGood.test(instance, FluidStackJS.of((Object)FluidStackHooksForge.fromForge((net.minecraftforge.fluids.FluidStack)fluidStack)));
                }

                public int fill(net.minecraftforge.fluids.FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
                    return onFill != null ? onFill.transfer(instance, FluidStackJS.of((Object)FluidStackHooksForge.fromForge((net.minecraftforge.fluids.FluidStack)fluidStack)), fluidAction.simulate()) : 0;
                }

                @NotNull
                public net.minecraftforge.fluids.FluidStack drain(net.minecraftforge.fluids.FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
                    int drained;
                    int n = drained = onDrain != null ? onDrain.transfer(instance, FluidStackJS.of((Object)FluidStackHooksForge.fromForge((net.minecraftforge.fluids.FluidStack)fluidStack)), fluidAction.simulate()) : 0;
                    if (drained == 0) {
                        return net.minecraftforge.fluids.FluidStack.EMPTY;
                    }
                    return new net.minecraftforge.fluids.FluidStack(fluidStack, drained);
                }

                @NotNull
                public net.minecraftforge.fluids.FluidStack drain(int i, IFluidHandler.FluidAction fluidAction) {
                    net.minecraftforge.fluids.FluidStack inTank = this.getFluidInTank(0).copy();
                    if (inTank.isEmpty()) {
                        return inTank;
                    }
                    inTank.setAmount(i);
                    return this.drain(inTank, fluidAction);
                }
            };
        }

        @Override
        public Capability<IFluidHandler> getCapabilityKey() {
            return ForgeCapabilities.FLUID_HANDLER;
        }

        @Override
        public ResourceLocation getResourceLocation() {
            return new ResourceLocation("powerful:custom_tank_be");
        }
    }

    public static class FluidHandlerItemStackCustom
    extends FluidHandlerItemStack {
        private final FluidIOItemStack onFill;
        private final FluidIOItemStack onDrain;
        private final BiPredicate<ItemStack, FluidStackJS> isFluidGood;
        private final ToIntFunction<ItemStack> getCapacity;

        public FluidHandlerItemStackCustom(@NotNull ItemStack container, int capacity, FluidIOItemStack onFill, FluidIOItemStack onDrain, BiPredicate<ItemStack, FluidStackJS> isFluidGood, ToIntFunction<ItemStack> getCapacity) {
            super(container, capacity);
            this.onDrain = onDrain;
            this.onFill = onFill;
            this.isFluidGood = isFluidGood;
            this.getCapacity = getCapacity;
        }

        public boolean isFluidValid(int tank, @NotNull net.minecraftforge.fluids.FluidStack stack) {
            return this.isFluidGood == null || this.isFluidGood.test(this.container, FluidStackJS.of((Object)FluidStackHooksForge.fromForge((net.minecraftforge.fluids.FluidStack)stack)));
        }

        public int fill(net.minecraftforge.fluids.FluidStack resource, IFluidHandler.FluidAction doFill) {
            return this.onFill == null ? super.fill(resource, doFill) : this.onFill.transfer(this.container, FluidStackJS.of((Object)FluidStackHooksForge.fromForge((net.minecraftforge.fluids.FluidStack)resource)), doFill.simulate());
        }

        @NotNull
        public net.minecraftforge.fluids.FluidStack drain(net.minecraftforge.fluids.FluidStack resource, IFluidHandler.FluidAction action) {
            if (this.onDrain == null) {
                return super.drain(resource, action);
            }
            net.minecraftforge.fluids.FluidStack stack = resource.copy();
            stack.setAmount(this.onDrain.transfer(this.container, FluidStackJS.of((Object)FluidStackHooksForge.fromForge((net.minecraftforge.fluids.FluidStack)resource)), action.simulate()));
            return stack;
        }

        @NotNull
        public net.minecraftforge.fluids.FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (this.onDrain == null) {
                return super.drain(maxDrain, action);
            }
            net.minecraftforge.fluids.FluidStack stack = this.getFluid().copy();
            net.minecraftforge.fluids.FluidStack drain = this.getFluid().copy();
            drain.setAmount(maxDrain);
            stack.setAmount(this.onDrain.transfer(this.container, FluidStackJS.of((Object)FluidStackHooksForge.fromForge((net.minecraftforge.fluids.FluidStack)drain)), action.simulate()));
            return stack;
        }

        public boolean canFillFluidType(net.minecraftforge.fluids.FluidStack fluid) {
            return this.isFluidValid(0, fluid);
        }

        public boolean canDrainFluidType(net.minecraftforge.fluids.FluidStack fluid) {
            return this.isFluidValid(0, fluid);
        }

        public int getTankCapacity(int tank) {
            return this.getCapacity == null ? 1000 : this.getCapacity.applyAsInt(this.container);
        }
    }

    @FunctionalInterface
    public static interface FluidIOBlockEntity {
        public int transfer(BlockEntity var1, FluidStackJS var2, boolean var3);
    }

    @FunctionalInterface
    public static interface FluidIOItemStack {
        public int transfer(ItemStack var1, FluidStackJS var2, boolean var3);
    }
}

