/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.soul_fire_d.network.packet;

import it.crystalnest.soul_fire_d.api.Fire;
import it.crystalnest.soul_fire_d.api.FireManager;
import it.crystalnest.soul_fire_d.network.CustomPacketPayload;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record RegisterFirePacket(Fire fire) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("soul_fire_d", "register_fire");

    public RegisterFirePacket(FriendlyByteBuf buffer) {
        this(RegisterFirePacket.decode(buffer));
    }

    private static Fire decode(FriendlyByteBuf buffer) {
        Fire.Builder builder = FireManager.fireBuilder(buffer.m_130281_()).setDamage(buffer.readFloat()).setInvertHealAndHarm(buffer.readBoolean()).removeComponent(Fire.Component.CAMPFIRE_ITEM).removeComponent(Fire.Component.LANTERN_BLOCK).removeComponent(Fire.Component.LANTERN_ITEM).removeComponent(Fire.Component.TORCH_BLOCK).removeComponent(Fire.Component.TORCH_ITEM).removeComponent(Fire.Component.WALL_TORCH_BLOCK).removeComponent(Fire.Component.FLAME_PARTICLE).removeFireAspect().removeFlame();
        if (buffer.readBoolean()) {
            builder.setComponent(Fire.Component.SOURCE_BLOCK, buffer.m_130281_());
        } else {
            builder.removeComponent(Fire.Component.SOURCE_BLOCK);
        }
        if (buffer.readBoolean()) {
            builder.setComponent(Fire.Component.CAMPFIRE_BLOCK, buffer.m_130281_());
        } else {
            builder.removeComponent(Fire.Component.CAMPFIRE_BLOCK);
        }
        return builder.build();
    }

    @Override
    public void write(@NotNull FriendlyByteBuf buffer) {
        ResourceLocation campfire;
        buffer.m_130085_(this.fire.getFireType());
        buffer.writeFloat(this.fire.getDamage());
        buffer.writeBoolean(this.fire.invertHealAndHarm());
        @Nullable ResourceLocation source = this.fire.getComponent(Fire.Component.SOURCE_BLOCK);
        buffer.writeBoolean(source != null);
        if (source != null) {
            buffer.m_130085_(source);
        }
        buffer.writeBoolean((campfire = this.fire.getComponent(Fire.Component.CAMPFIRE_BLOCK)) != null);
        if (campfire != null) {
            buffer.m_130085_(campfire);
        }
    }

    @Override
    @NotNull
    public ResourceLocation id() {
        return ID;
    }
}

