/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.soul_fire_d.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import it.crystalnest.soul_fire_d.api.FireManager;
import it.crystalnest.soul_fire_d.api.type.FireTypeChanger;
import it.crystalnest.soul_fire_d.api.type.FireTyped;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.function.TriFunction;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements FireTypeChanger {
    @Unique
    private static final EntityDataAccessor<String> DATA_FIRE_TYPE = SynchedEntityData.m_135353_(Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    @Final
    @Shadow
    protected SynchedEntityData f_19804_;
    @Shadow
    private Level f_19853_;

    @Shadow
    public abstract int m_20094_();

    @Shadow
    public abstract boolean m_5825_();

    @Override
    public ResourceLocation getFireType() {
        return ResourceLocation.m_135820_((String)((String)this.f_19804_.m_135370_(DATA_FIRE_TYPE)));
    }

    @Override
    public void setFireType(ResourceLocation fireType) {
        if (!this.m_5825_()) {
            this.f_19804_.m_135381_(DATA_FIRE_TYPE, (Object)FireManager.ensure(fireType).toString());
        }
    }

    @WrapOperation(method={"baseTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z")})
    private boolean redirectHurt(Entity instance, DamageSource damageSource, float damage, Operation<Boolean> original) {
        return FireManager.damageOnFire(instance, ((FireTyped)instance).getFireType(), (TriFunction<Entity, DamageSource, Float, Boolean>)((TriFunction)(xva$0, xva$1, xva$2) -> (Boolean)original.call(new Object[]{xva$0, xva$1, xva$2})));
    }

    @WrapOperation(method={"lavaHurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;setSecondsOnFire(I)V")})
    private void redirectSetSecondsOnFire(Entity instance, int seconds, Operation<Void> original) {
        FireManager.setOnFire(instance, seconds, FireManager.DEFAULT_FIRE_TYPE, (xva$0, xva$1) -> {
            Void cfr_ignored_0 = (Void)original.call(new Object[]{xva$0, xva$1});
        });
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void redirectDefineSynchedData(CallbackInfo ci) {
        this.f_19804_.m_135372_(DATA_FIRE_TYPE, (Object)FireManager.DEFAULT_FIRE_TYPE.toString());
    }

    @Inject(method={"setRemainingFireTicks"}, at={@At(value="HEAD")})
    private void onSetRemainingFireTicks(int ticks, CallbackInfo ci) {
        if (!this.f_19853_.f_46443_ && ticks >= this.m_20094_()) {
            this.setFireType(FireManager.DEFAULT_FIRE_TYPE);
        }
    }

    @Inject(method={"saveWithoutId"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V")})
    private void onSaveWithoutId(CompoundTag tag, CallbackInfoReturnable<CompoundTag> cir) {
        FireManager.writeTag(tag, this.getFireType());
    }

    @Inject(method={"load"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V")})
    private void onLoad(CompoundTag tag, CallbackInfo ci) {
        this.setFireType(FireManager.readTag(tag));
    }
}

