/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.soul_fire_d.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.crystalnest.soul_fire_d.config.ModConfig;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;

public final class ChestLootModifier
extends LootModifier {
    public static final Supplier<Codec<ChestLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(instance -> ChestLootModifier.codecStart((RecordCodecBuilder.Instance)instance).and((App)Addition.CODEC.listOf().fieldOf("additions").forGetter(modifier -> modifier.additions)).apply((Applicative)instance, ChestLootModifier::new)));
    private final List<Addition> additions;

    private ChestLootModifier(LootItemCondition[] conditionsIn, List<Addition> additions) {
        super(conditionsIn);
        this.additions = additions;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (generatedLoot == null) {
            generatedLoot = new ObjectArrayList();
        }
        for (Addition addition : this.additions) {
            if (!ModConfig.getEnableSoulFlame().booleanValue() || !(context.m_230907_().m_188501_() <= addition.chance.floatValue())) continue;
            generatedLoot.add((Object)addition.getEnchantedBook());
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }

    private static final class Addition {
        public static final Codec<Addition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ForgeRegistries.ENCHANTMENTS.getCodec().fieldOf("enchantment").forGetter(addition -> addition.enchantment), (App)Codec.FLOAT.fieldOf("chance").forGetter(addition -> addition.chance), (App)Codec.INT.fieldOf("level").forGetter(addition -> addition.level)).apply((Applicative)instance, Addition::new));
        private final Enchantment enchantment;
        private final Float chance;
        private final Integer level;

        private Addition(Enchantment item, Float chance, Integer quantity) {
            this.enchantment = item;
            this.chance = chance;
            this.level = quantity;
        }

        private ItemStack getEnchantedBook() {
            ItemStack book = new ItemStack((ItemLike)Items.f_42690_);
            EnchantedBookItem.m_41153_((ItemStack)book, (EnchantmentInstance)new EnchantmentInstance(this.enchantment, Math.min(this.enchantment.m_6586_(), this.level)));
            return book;
        }
    }
}

