/*
 * Decompiled with CFR 0.152.
 */
package me.duquee.createutilities.blocks.voidtypes.chest;

import com.simibubi.create.foundation.gui.menu.MenuBase;
import me.duquee.createutilities.blocks.voidtypes.CUContainerTypes;
import me.duquee.createutilities.blocks.voidtypes.chest.VoidChestInventory;
import me.duquee.createutilities.blocks.voidtypes.chest.VoidChestTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class VoidChestContainer
extends MenuBase<VoidChestTileEntity> {
    public VoidChestContainer(MenuType<?> type, int id, Inventory inv, FriendlyByteBuf extraData) {
        super(type, id, inv, extraData);
    }

    public VoidChestContainer(MenuType<?> type, int id, Inventory inv, VoidChestTileEntity te) {
        super(type, id, inv, (Object)te);
        ((VoidChestTileEntity)((Object)this.contentHolder)).startOpen(this.player);
    }

    public static VoidChestContainer create(int id, Inventory inv, VoidChestTileEntity te) {
        return new VoidChestContainer((MenuType)CUContainerTypes.VOID_CHEST.get(), id, inv, te);
    }

    protected VoidChestTileEntity createOnClient(FriendlyByteBuf extraData) {
        BlockPos readBlockPos = extraData.m_130135_();
        CompoundTag readNbt = extraData.m_130260_();
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        assert (world != null);
        BlockEntity tileEntity = world.m_7702_(readBlockPos);
        if (tileEntity instanceof VoidChestTileEntity) {
            VoidChestTileEntity voidChest = (VoidChestTileEntity)tileEntity;
            voidChest.read(readNbt, true);
            return voidChest;
        }
        return null;
    }

    protected void initAndReadInventory(VoidChestTileEntity contentHolder) {
    }

    protected void addSlots() {
        this.addChestSlots();
        this.addPlayerSlots(8, 90);
    }

    private void addChestSlots() {
        VoidChestInventory inventory = ((VoidChestTileEntity)((Object)this.contentHolder)).getItemStorage();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)inventory, y * 9 + x, 8 + x * 18, 18 + y * 18));
            }
        }
    }

    protected void saveData(VoidChestTileEntity contentHolder) {
    }

    public ItemStack m_7648_(Player player, int index) {
        boolean success;
        Slot clickedSlot = this.m_38853_(index);
        if (!clickedSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = clickedSlot.m_7993_();
        int size = ((VoidChestTileEntity)((Object)this.contentHolder)).getItemStorage().getSlots();
        if (index < size) {
            success = !this.m_38903_(stack, size, this.f_38839_.size(), false);
            ((VoidChestTileEntity)((Object)this.contentHolder)).getItemStorage().onContentsChanged(index);
        } else {
            success = !this.m_38903_(stack, 0, size - 1, false);
        }
        return success ? ItemStack.f_41583_ : stack;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (!player.m_9236_().f_46443_) {
            ((VoidChestTileEntity)((Object)this.contentHolder)).stopOpen(player);
        }
    }
}

