/*
 * Decompiled with CFR 0.152.
 */
package io.github.jasonsimpart.createdelightcore.mixin.waystones;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.jasonsimpart.createdelightcore.CDConfig;
import io.github.jasonsimpart.createdelightcore.content.util.MoneyUtil;
import io.github.lightman314.lightmanscurrency.api.money.value.builtin.CoinValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.client.gui.widget.WaystoneButton;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WaystoneButton.class})
public class WaystoneButtonMixin
extends Button {
    @Final
    @Shadow(remap=false)
    private int xpLevelCost;
    @Final
    @Shadow(remap=false)
    private IWaystone waystone;
    @Unique
    private int CreateDelightCore$distance;
    @Unique
    private int CreateDelightCore$cost;
    @Unique
    private boolean CreateDelightCore$canAfford;
    @Unique
    private boolean CreateDelightCore$isRender;

    protected WaystoneButtonMixin(int pX, int pY, int pWidth, int pHeight, Component pMessage, Button.OnPress pOnPress, Button.CreateNarration pCreateNarration) {
        super(pX, pY, pWidth, pHeight, pMessage, pOnPress, pCreateNarration);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")}, remap=false, cancellable=true)
    private void WaystoneButton(int x, int y, IWaystone waystone, int xpLevelCost, Button.OnPress pressable, CallbackInfo ci) {
        if (CDConfig.useMoneyTeleport) {
            this.f_93623_ = true;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            this.CreateDelightCore$distance = (int)player.m_20182_().m_82554_(waystone.getPos().m_252807_());
            this.CreateDelightCore$cost = CDConfig.teleportCost * xpLevelCost;
            this.CreateDelightCore$canAfford = MoneyUtil.playerCanAfford((Player)player, MoneyUtil.baseCoinNumberToCoinValue(this.CreateDelightCore$cost));
            if (!this.CreateDelightCore$canAfford && !player.m_150110_().f_35937_) {
                this.f_93623_ = false;
            }
            if (this.CreateDelightCore$distance > 5) {
                this.CreateDelightCore$isRender = true;
            }
            ci.cancel();
        }
    }

    @Inject(method={"renderWidget"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks, CallbackInfo ci) {
        if (CDConfig.useMoneyTeleport) {
            super.m_87963_(guiGraphics, mouseX, mouseY, partialTicks);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft mc = Minecraft.m_91087_();
            if (this.CreateDelightCore$isRender) {
                if (this.waystone.getDimension() == mc.f_91074_.m_9236_().m_46472_()) {
                    String distanceStr = this.CreateDelightCore$distance < 10000 && (mc.f_91062_.m_92852_((FormattedText)this.m_6035_()) < 120 || this.CreateDelightCore$distance < 1000) ? this.CreateDelightCore$distance + "m" : String.format("%.1f", Float.valueOf((float)this.CreateDelightCore$distance / 1000.0f)).replace(",0", "").replace(".0", "") + "km";
                    int xOffset = this.m_5711_() - mc.f_91062_.m_92895_(distanceStr);
                    guiGraphics.m_280488_(mc.f_91062_, distanceStr, this.m_252754_() + xOffset - 4, this.m_252907_() + 6, this.m_142518_() ? 0xFFFFFF : 0x9E9E9E);
                }
                if (this.CreateDelightCore$cost != 0) {
                    int xOffset = 0;
                    for (ItemStack item : ((CoinValue)MoneyUtil.baseCoinNumberToCoinValue(this.CreateDelightCore$cost)).getAsItemList()) {
                        guiGraphics.m_280480_(item, this.m_252754_() + 2 + xOffset, this.m_252907_() + 2);
                        guiGraphics.m_280488_(mc.f_91062_, String.valueOf(item.m_41613_()), this.m_252754_() + 16 + xOffset, this.m_252907_() + 6 + 5, 0xFFFFFF);
                        xOffset += 16;
                    }
                }
                if (this.f_93622_ && mouseX <= this.m_252754_() + 16) {
                    boolean canXpLevelAfford;
                    ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
                    if (this.xpLevelCost > 0) {
                        // empty if block
                    }
                    boolean haveXpLevelRequirement = false;
                    boolean haveMoneyRequirement = this.CreateDelightCore$cost != 0;
                    boolean bl = canXpLevelAfford = Objects.requireNonNull(mc.f_91074_).f_36078_ >= this.xpLevelCost || mc.f_91074_.m_150110_().f_35937_;
                    if (haveXpLevelRequirement) {
                        MutableComponent levelRequirementText = Component.m_237110_((String)"gui.waystones.waystone_selection.level_requirement", (Object[])new Object[]{this.xpLevelCost});
                        levelRequirementText.m_130940_(canXpLevelAfford ? ChatFormatting.GREEN : ChatFormatting.RED);
                        tooltip.add(levelRequirementText);
                    }
                    if (haveMoneyRequirement) {
                        String money = MoneyUtil.baseCoinNumberToCoinValue(this.CreateDelightCore$cost).getText().getString();
                        MutableComponent moneyRequirementText = Component.m_237110_((String)"gui.createdelightcore.need", (Object[])new Object[]{money});
                        moneyRequirementText.m_130940_(this.CreateDelightCore$canAfford ? ChatFormatting.GREEN : ChatFormatting.RED);
                        tooltip.add(moneyRequirementText);
                    }
                    if (!haveXpLevelRequirement && !haveMoneyRequirement) {
                        MutableComponent moneyRequirementText = Component.m_237115_((String)"gui.createdelightcore.free");
                        moneyRequirementText.m_130940_(ChatFormatting.GREEN);
                        tooltip.add(moneyRequirementText);
                    }
                    Font font = mc.f_91062_;
                    Optional optional = Optional.empty();
                    Objects.requireNonNull(mc.f_91062_);
                    guiGraphics.m_280677_(font, tooltip, optional, mouseX, mouseY + 9);
                }
            }
            ci.cancel();
        }
    }
}

