/*
 * Decompiled with CFR 0.152.
 */
package io.github.jasonsimpart.createdelightcore.content.recipe;

import com.simibubi.create.api.registry.CreateBuiltInRegistries;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import io.github.jasonsimpart.createdelightcore.CreateDelightCore;
import io.github.jasonsimpart.createdelightcore.content.recipe.FanFreezingRecipe;
import io.github.jasonsimpart.createdelightcore.registry.CDRecipeTypes;
import io.github.jasonsimpart.createdelightcore.registry.CDTags;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.theme.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class CDFanProcessingTypes {
    public static final FreezingType FREEZING = CDFanProcessingTypes.register("freezing", new FreezingType());

    private static <T extends FanProcessingType> T register(String id, T type) {
        Registry.m_122965_((Registry)CreateBuiltInRegistries.FAN_PROCESSING_TYPE, (ResourceLocation)CreateDelightCore.id(id), type);
        return type;
    }

    public static void register() {
    }

    static {
        Object2ReferenceOpenHashMap map = new Object2ReferenceOpenHashMap();
        map.put((Object)"FREEZING", (Object)FREEZING);
        map.trim();
    }

    public static class FreezingType
    implements FanProcessingType {
        private static final FanFreezingRecipe.FanFreezingRecipeWrapper FREEZING_WRAPPER = new FanFreezingRecipe.FanFreezingRecipeWrapper();

        public boolean isValidAt(Level level, BlockPos pos) {
            FluidState fluidState = level.m_6425_(pos);
            if (CDTags.AllFluidTags.FAN_PROCESSING_CATALYSTS_FREEZING.matches(fluidState)) {
                return true;
            }
            BlockState blockState = level.m_8055_(pos);
            return CDTags.AllBlockTags.FAN_PROCESSING_CATALYSTS_FREEZING.matches(blockState);
        }

        public int getPriority() {
            return 691100;
        }

        public boolean canProcess(ItemStack stack, Level level) {
            FREEZING_WRAPPER.m_6836_(0, stack);
            Optional recipe = CDRecipeTypes.FAN_FREEZING.find(FREEZING_WRAPPER, level);
            return recipe.isPresent();
        }

        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            FREEZING_WRAPPER.m_6836_(0, stack);
            Optional<FanFreezingRecipe> recipe = CDRecipeTypes.FAN_FREEZING.find(FREEZING_WRAPPER, level);
            return recipe.map(fanFreezingRecipe -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)fanFreezingRecipe)).orElse(null);
        }

        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.f_46441_.m_188503_(8) != 0) {
                return;
            }
            Vector3f color = new Color(14543103).asVectorF();
            level.m_7106_((ParticleOptions)new DustParticleOptions(color, 1.0f), pos.f_82479_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), pos.f_82480_ + 0.5, pos.f_82481_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_175821_, pos.f_82479_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), pos.f_82480_ + 0.5, pos.f_82481_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
        }

        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors((int)0xEEEEFF, (int)14543103, (float)random.m_188501_()));
            particleAccess.setAlpha(1.0f);
            if (random.m_188501_() < 0.0078125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_175821_, 0.125f);
            }
            if (random.m_188501_() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_123759_, 0.125f);
            }
        }

        public void affectEntity(Entity entity, Level level) {
            if (level.f_46443_) {
                if (entity instanceof Skeleton) {
                    Vec3 p = entity.m_20318_(0.0f);
                    Vec3 v = p.m_82520_(0.0, 0.5, 0.0).m_82549_(VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)level.f_46441_, (float)1.0f).m_82542_(1.0, (double)0.2f, 1.0).m_82541_().m_82490_(1.0));
                    level.m_7106_((ParticleOptions)ParticleTypes.f_175821_, v.f_82479_, v.f_82480_, v.f_82481_, 0.0, (double)0.1f, 0.0);
                    if (level.f_46441_.m_188503_(3) == 0) {
                        level.m_7106_((ParticleOptions)ParticleTypes.f_175821_, p.f_82479_, p.f_82480_ + 0.5, p.f_82481_, (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), (double)0.1f, (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f));
                    }
                }
                return;
            }
            if (entity instanceof EnderMan || entity.m_6095_() == EntityType.f_20551_) {
                entity.m_6469_(level.m_269111_().m_269109_(), 8.0f);
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 7, false, false));
            }
            if (entity instanceof SnowGolem) {
                SnowGolem snowgolem = (SnowGolem)entity;
                snowgolem.m_5634_(4.0f);
            }
            if (entity instanceof Stray) {
                Stray stray = (Stray)entity;
                stray.m_5634_(2.0f);
            }
            if (entity.m_6060_()) {
                entity.m_20095_();
                level.m_5594_(null, entity.m_20183_(), SoundEvents.f_11914_, SoundSource.NEUTRAL, 0.7f, 1.6f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.4f);
            }
            if (entity instanceof Skeleton) {
                Skeleton skeleton = (Skeleton)entity;
                int progress = skeleton.getPersistentData().m_128451_("CreateFreezing");
                if (progress < 50) {
                    if (progress % 10 == 0) {
                        level.m_5594_(null, entity.m_20183_(), SoundEvents.f_12451_, SoundSource.NEUTRAL, 1.0f, 1.5f * (float)progress / 50.0f);
                    }
                    skeleton.getPersistentData().m_128405_("CreateFreezing", progress + 1);
                    return;
                }
                level.m_5594_(null, entity.m_20183_(), SoundEvents.f_144211_, SoundSource.NEUTRAL, 1.25f, 0.65f);
                Stray stray = (Stray)EntityType.f_20481_.m_20615_(level);
                CompoundTag serializeNBT = skeleton.m_20240_(new CompoundTag());
                serializeNBT.m_128473_("UUID");
                assert (stray != null);
                stray.deserializeNBT(serializeNBT);
                stray.m_146884_(skeleton.m_20318_(0.0f));
                level.m_7967_((Entity)stray);
                skeleton.m_146870_();
            }
        }
    }
}

