/*
 * Decompiled with CFR 0.152.
 */
package io.github.jasonsimpart.createdelightcore.compat.jei.category;

import com.mrh0.createaddition.util.ClientMinecraftWrapper;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.category.animations.AnimatedBlazeBurner;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class JeiCategoryBlazeBurnerFluid
implements IRecipeCategory<BlazeBurnerFluidRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("createdelightcore", "blaze_burner");
    private final IJeiHelpers helpers;
    private final AnimatedBlazeBurner heater = new AnimatedBlazeBurner();
    public static final RecipeType<BlazeBurnerFluidRecipe> RECIPE_TYPE = new RecipeType(UID, BlazeBurnerFluidRecipe.class);

    public JeiCategoryBlazeBurnerFluid(IJeiHelpers helpers) {
        this.helpers = helpers;
    }

    public RecipeType<BlazeBurnerFluidRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"jei.createdelightcore.BlazeBurnerFluid");
    }

    public IDrawable getBackground() {
        return new EmptyBackground(177, 53);
    }

    @Nullable
    public IDrawable getIcon() {
        return this.helpers.getGuiHelper().createDrawableItemStack(AllBlocks.BLAZE_BURNER.asStack());
    }

    public void setRecipe(IRecipeLayoutBuilder iRecipeLayoutBuilder, BlazeBurnerFluidRecipe recipe, IFocusGroup iFocusGroup) {
        iRecipeLayoutBuilder.addSlot(RecipeIngredientRole.INPUT, this.getBackground().getWidth() / 2 - 16, 3).addFluidStack(recipe.fluid, (long)recipe.amountConsume);
    }

    public void draw(BlazeBurnerFluidRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        guiGraphics.m_280488_(ClientMinecraftWrapper.getFont(), JeiCategoryBlazeBurnerFluid.formatTime(recipe.burnTime()), this.getBackground().getWidth() / 2 + 48, 36, 0x404040);
        HeatCondition requiredHeat = recipe.isSuperHeated() ? HeatCondition.SUPERHEATED : HeatCondition.HEATED;
        AllGuiTextures.JEI_LIGHT.render(guiGraphics, 81, 38);
        AllGuiTextures.JEI_HEAT_BAR.render(guiGraphics, 4, 30);
        guiGraphics.m_280430_(ClientMinecraftWrapper.getFont(), (Component)Component.m_237110_((String)"jei.createdelightcore.amountConsume", (Object[])new Object[]{recipe.amountConsume}), 9, 36, requiredHeat.getColor());
        this.heater.withHeat(requiredHeat.visualizeAsBlazeBurner()).draw(guiGraphics, this.getBackground().getWidth() / 2 + 3, 5);
        AllGuiTextures.JEI_DOWN_ARROW.render(guiGraphics, this.getBackground().getWidth() / 2 + 3, 8);
    }

    public static String formatTime(int ticks) {
        if (ticks >= 1200) {
            return ticks / 1200 + " m";
        }
        if (ticks >= 20) {
            return ticks / 20 + " s";
        }
        return ticks + " t";
    }

    public record BlazeBurnerFluidRecipe(Fluid fluid, boolean isSuperHeated, int burnTime, int amountConsume) {
    }
}

