/*
 * Decompiled with CFR 0.152.
 */
package io.github.jasonsimpart.createdelightcore;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="createdelightcore", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CDConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.BooleanValue DISABLE_DROP_REPORT = BUILDER.comment("Whether to enable the drop report").define("disableDropReport", false);
    private static final ForgeConfigSpec.IntValue ITEM_THRESHOLD = BUILDER.comment("Threshold for drop reporting.").defineInRange("itemThreshold", 100, 0, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.BooleanValue IGNORE_STACK_COUNT = BUILDER.comment("If this option is enabled, the drop report will be counted by a single drop entity, not by the number of items in it").define("ignoreStackCount", false);
    private static final ForgeConfigSpec.ConfigValue<String> MONEY_CAIN = BUILDER.comment("Money Chain used for money calculating").define("moneyChain", (Object)"main");
    private static final ForgeConfigSpec.BooleanValue USE_MONEY_TELEPORT = BUILDER.comment("Whether to use money for teleporting").define("useMoneyTeleport", true);
    private static final ForgeConfigSpec.IntValue TELEPORT_COST = BUILDER.comment("Coin used for waystone teleporting per unit.").comment("It's the base value of the chain.").defineInRange("teleportCost", 45, 1, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.DoubleValue LUNA_SOIL_BOOST_CHANCE = BUILDER.comment("The chance for luna soil to boost crops grows.").defineInRange("lunaSoilBoostChance", 0.5, 0.0, 1.0);
    static final ForgeConfigSpec SPEC = BUILDER.build();
    public static boolean disableDropReport;
    public static int itemThreshold;
    public static boolean ignoreStackCount;
    public static String moneyChain;
    public static int teleportCost;
    public static boolean useMoneyTeleport;
    public static double lunaSoilBoostChance;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        disableDropReport = (Boolean)DISABLE_DROP_REPORT.get();
        itemThreshold = (Integer)ITEM_THRESHOLD.get();
        ignoreStackCount = (Boolean)IGNORE_STACK_COUNT.get();
        moneyChain = (String)MONEY_CAIN.get();
        useMoneyTeleport = (Boolean)USE_MONEY_TELEPORT.get();
        teleportCost = (Integer)TELEPORT_COST.get();
        lunaSoilBoostChance = (Double)LUNA_SOIL_BOOST_CHANCE.get();
    }
}

