/*
 * Decompiled with CFR 0.152.
 */
package com.moepus.moestweaks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.moepus.moestweaks.Config;
import com.moepus.moestweaks.MoesTweaks;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Paths;
import java.util.function.Supplier;
import net.minecraftforge.fml.loading.FMLPaths;

public class ConfigParser {
    private static Config config;
    static Supplier<String> config_path;

    public static void loadConfig() {
        Gson gson = new Gson();
        File configFile = new File(config_path.get());
        if (!configFile.exists()) {
            config = new Config();
            ConfigParser.saveConfig();
        } else {
            try (FileReader reader = new FileReader(configFile);){
                config = (Config)gson.fromJson((Reader)reader, Config.class);
                ConfigParser.saveConfig();
            }
            catch (JsonIOException | JsonSyntaxException | IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void saveConfig() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (FileWriter writer = new FileWriter(config_path.get());){
            gson.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException e) {
            MoesTweaks.LOGGER.error(e.getMessage());
        }
    }

    public static Config getConfig() {
        if (config == null) {
            ConfigParser.loadConfig();
        }
        return config;
    }

    static {
        config_path = () -> String.valueOf(Paths.get(String.valueOf(FMLPaths.CONFIGDIR.get()), "moestweaks.json"));
    }
}

