/*
 * Decompiled with CFR 0.152.
 */
package caeruleusTait.world.preview.client.gui.widgets;

import caeruleusTait.world.preview.RenderSettings;
import caeruleusTait.world.preview.WorldPreview;
import caeruleusTait.world.preview.WorldPreviewConfig;
import caeruleusTait.world.preview.backend.WorkManager;
import caeruleusTait.world.preview.backend.color.PreviewData;
import caeruleusTait.world.preview.backend.storage.PreviewSection;
import caeruleusTait.world.preview.backend.storage.PreviewStorage;
import caeruleusTait.world.preview.client.WorldPreviewClient;
import caeruleusTait.world.preview.client.WorldPreviewComponents;
import caeruleusTait.world.preview.client.gui.PreviewDisplayDataProvider;
import caeruleusTait.world.preview.client.gui.widgets.lists.BiomesList;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexSorting;
import it.unimi.dsi.fastutil.shorts.Short2LongMap;
import it.unimi.dsi.fastutil.shorts.Short2LongOpenHashMap;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class PreviewDisplay
extends AbstractWidget
implements AutoCloseable {
    private final Minecraft minecraft;
    private final PreviewDisplayDataProvider dataProvider;
    private final WorkManager workManager;
    private final RenderSettings renderSettings;
    private final WorldPreviewConfig config;
    private Short2LongMap visibleBiomes;
    private Short2LongMap visibleStructures;
    private NativeImage previewImg;
    private DynamicTexture previewTexture;
    private long[] workingVisibleBiomes;
    private long[] workingVisibleStructures;
    private int[] colorMap;
    private int[] colorMapGrayScale;
    private int[] heightColorMap;
    private int[] noiseColorMap;
    private boolean[] cavesMap;
    private IconData[] structureIcons;
    private IconData playerIcon;
    private IconData spawnIcon;
    private ItemStack[] structureItems;
    private PreviewDisplayDataProvider.StructureRenderInfo[] structureRenderInfoMap;
    private final NativeImage dummyIcon;
    private Component coordinatesCopiedMsg = null;
    private Instant coordinatesCopiedTime = null;
    private int texWidth = 100;
    private int texHeight = 100;
    private short selectedBiomeId;
    private boolean highlightCaves;
    private double totalDragX = 0.0;
    private double totalDragZ = 0.0;
    private int scaleBlockPos = 1;
    private StructHoverHelperCell[] hoverHelperGrid;
    private final int hoverHelperGridCellSize = 64;
    private int hoverHelperGridWidth;
    private int hoverHelperGridHeight;
    private Queue<Long> frametimes = new ArrayDeque<Long>();
    private boolean clicked = false;

    public PreviewDisplay(Minecraft minecraft, PreviewDisplayDataProvider dataProvider, Component component) {
        super(0, 0, 100, 100, component);
        this.minecraft = minecraft;
        this.workManager = WorldPreview.get().workManager();
        this.dataProvider = dataProvider;
        this.visibleBiomes = new Short2LongOpenHashMap();
        this.visibleStructures = new Short2LongOpenHashMap();
        this.renderSettings = WorldPreview.get().renderSettings();
        this.config = WorldPreview.get().cfg();
        this.dummyIcon = new NativeImage(16, 16, true);
        this.structureIcons = new IconData[0];
        this.resizeImage();
    }

    public void resizeImage() {
        this.closeDisplayTextures();
        this.previewImg = new NativeImage(NativeImage.Format.RGBA, this.texWidth, this.texHeight, true);
        this.previewTexture = new DynamicTexture(this.previewImg);
        this.scaleBlockPos = 4 / this.renderSettings.quartExpand() * this.renderSettings.quartStride();
        this.hoverHelperGridWidth = this.texWidth / 64 + 1;
        this.hoverHelperGridHeight = this.texHeight / 64 + 1;
        this.hoverHelperGrid = new StructHoverHelperCell[this.hoverHelperGridWidth * this.hoverHelperGridHeight];
        for (int i = 0; i < this.hoverHelperGrid.length; ++i) {
            this.hoverHelperGrid[i] = new StructHoverHelperCell(new ArrayList<StructHoverHelperEntry>());
        }
    }

    public void setSize(int width, int height) {
        this.f_93618_ = width;
        this.f_93619_ = height;
        this.texWidth = this.f_93618_ * (int)this.minecraft.m_91268_().m_85449_();
        this.texHeight = this.f_93619_ * (int)this.minecraft.m_91268_().m_85449_();
        this.resizeImage();
    }

    public void reloadData() {
        this.closeIconTextures();
        PreviewData.BiomeData[] rawBiomeMap = this.dataProvider.previewData().biomeId2BiomeData();
        this.structureRenderInfoMap = this.dataProvider.renderStructureMap();
        this.structureItems = this.dataProvider.structureItems();
        this.structureIcons = (IconData[])Arrays.stream(this.dataProvider.structureIcons()).map(x -> new IconData((NativeImage)x, new DynamicTexture(x))).toArray(IconData[]::new);
        this.playerIcon = new IconData(this.dataProvider.playerIcon(), new DynamicTexture(this.dataProvider.playerIcon()));
        this.spawnIcon = new IconData(this.dataProvider.spawnIcon(), new DynamicTexture(this.dataProvider.spawnIcon()));
        this.playerIcon.texture.m_117985_();
        this.spawnIcon.texture.m_117985_();
        Arrays.stream(this.structureIcons).map(IconData::texture).forEach(DynamicTexture::m_117985_);
        try {
            this.heightColorMap = this.dataProvider.heightColorMap();
            this.noiseColorMap = this.dataProvider.noiseColorMap();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.workingVisibleBiomes = new long[rawBiomeMap.length];
        this.workingVisibleStructures = new long[this.structureIcons.length];
        this.colorMap = new int[rawBiomeMap.length];
        this.colorMapGrayScale = new int[rawBiomeMap.length];
        this.cavesMap = new boolean[rawBiomeMap.length];
        for (int i = 0; i < rawBiomeMap.length; i = (int)((short)(i + 1))) {
            this.colorMap[i] = PreviewDisplay.textureColor(rawBiomeMap[i].color());
            this.colorMapGrayScale[i] = PreviewDisplay.grayScale(this.colorMap[i]);
            this.cavesMap[i] = rawBiomeMap[i].isCave();
        }
    }

    private void closeIconTextures() {
        if (this.structureIcons != null) {
            Arrays.stream(this.structureIcons).forEach(IconData::close);
        }
        if (this.playerIcon != null) {
            this.playerIcon.texture.close();
        }
        if (this.spawnIcon != null) {
            this.spawnIcon.texture.close();
        }
    }

    private void closeDisplayTextures() {
        if (this.previewTexture != null) {
            this.previewTexture.close();
        }
        if (this.previewImg != null) {
            this.previewImg.close();
        }
    }

    @Override
    public void close() {
        this.closeIconTextures();
        this.closeDisplayTextures();
    }

    @NotNull
    protected ClientTooltipPositioner m_262860_() {
        return DefaultTooltipPositioner.f_262752_;
    }

    public BlockPos center() {
        if (this.totalDragX == 0.0 && this.totalDragZ == 0.0) {
            return this.renderSettings.center();
        }
        return new BlockPos((int)((double)this.renderSettings.center().m_123341_() + this.totalDragX), this.renderSettings.center().m_123342_(), (int)((double)this.renderSettings.center().m_123343_() + this.totalDragZ));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_87963_(GuiGraphics guiGraphics, int x, int y, float f) {
        int colorBorder = -10066330;
        int xMin = this.m_252754_();
        int yMin = this.m_252907_();
        int xMax = xMin + this.f_93618_;
        int yMax = yMin + this.f_93619_;
        double winWidth = this.minecraft.m_91268_().m_85441_();
        double winHeight = this.minecraft.m_91268_().m_85442_();
        double guiScale = this.minecraft.m_91268_().m_85449_();
        Instant renderStart = Instant.now();
        this.queueGeneration();
        PreviewDisplayDataProvider previewDisplayDataProvider = this.dataProvider;
        synchronized (previewDisplayDataProvider) {
            if (this.dataProvider.setupFailed()) {
                this.previewImg.m_84997_(0, 0, this.texWidth, this.texHeight, -16777216);
                this.previewTexture.m_117985_();
                WorldPreviewClient.renderTexture((AbstractTexture)this.previewTexture, xMin, yMin, xMax, yMax);
                List<MutableComponent> lines = WorldPreviewComponents.MSG_ERROR_SETUP_FAILED.getString().lines().map(Component::m_237113_).toList();
                int centerX = this.m_252754_() + this.f_93618_ / 2;
                int n = this.m_252907_() + this.f_93619_ / 2;
                int n2 = lines.size() / 2;
                Objects.requireNonNull(this.minecraft.f_91062_);
                int centerY = n - n2 * (9 + 4);
                for (int i = 0; i < lines.size(); ++i) {
                    Component line = (Component)lines.get(i);
                    Objects.requireNonNull(this.minecraft.f_91062_);
                    int offsetY = i * (9 + 4);
                    guiGraphics.m_280653_(this.minecraft.f_91062_, line, centerX, centerY + offsetY, 0xFFFFFF);
                }
            } else if (this.dataProvider.isUpdating()) {
                this.previewImg.m_84997_(0, 0, this.texWidth, this.texHeight, -16777216);
                this.previewTexture.m_117985_();
                WorldPreviewClient.renderTexture((AbstractTexture)this.previewTexture, xMin, yMin, xMax, yMax);
                int centerX = this.m_252754_() + this.f_93618_ / 2;
                int centerY = this.m_252907_() + this.f_93619_ / 2;
                guiGraphics.m_280653_(this.minecraft.f_91062_, WorldPreviewComponents.MSG_PREVIEW_SETUP_LOADING, centerX, centerY, 0xFFFFFF);
            } else {
                Arrays.fill(this.workingVisibleBiomes, 0L);
                Arrays.fill(this.workingVisibleStructures, 0L);
                Arrays.stream(this.hoverHelperGrid).forEach(cell -> cell.entries.clear());
                List<RenderHelper> renderData = this.generateRenderData();
                this.updateTexture(renderData);
                this.previewTexture.m_117985_();
                WorldPreviewClient.renderTexture((AbstractTexture)this.previewTexture, xMin, yMin, xMax, yMax);
                guiGraphics.m_280588_(xMin, yMin, xMax, yMax);
                Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, (float)winWidth, (float)winHeight, 0.0f, 1000.0f, 21000.0f);
                RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (VertexSorting)VertexSorting.f_276633_);
                this.renderStructures(renderData, guiGraphics);
                this.renderPlayerAndSpawn();
                matrix4f = new Matrix4f().setOrtho(0.0f, (float)(winWidth / guiScale), (float)(winHeight / guiScale), 0.0f, 1000.0f, 21000.0f);
                RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (VertexSorting)VertexSorting.f_276633_);
                guiGraphics.m_280618_();
                double mouseX = this.minecraft.f_91067_.m_91589_() * (double)this.minecraft.m_91268_().m_85445_() / (double)this.minecraft.m_91268_().m_85443_();
                double mouseZ = this.minecraft.f_91067_.m_91594_() * (double)this.minecraft.m_91268_().m_85446_() / (double)this.minecraft.m_91268_().m_85444_();
                this.biomesChanged();
                this.updateTooltip(mouseX, mouseZ);
            }
        }
        guiGraphics.m_280509_(xMin - 1, yMin - 1, xMax + 1, yMin, -10066330);
        guiGraphics.m_280509_(xMax, yMin, xMax + 1, yMax, -10066330);
        guiGraphics.m_280509_(xMin - 1, yMax, xMax + 1, yMax + 1, -10066330);
        guiGraphics.m_280509_(xMin - 1, yMin, xMin, yMax, -10066330);
        if (this.coordinatesCopiedMsg != null) {
            guiGraphics.m_280509_(xMin, yMax - 38, xMax, yMax - 19, -1442840576);
            guiGraphics.m_280653_(this.minecraft.f_91062_, this.coordinatesCopiedMsg, xMin + (xMax - xMin) / 2, yMax - 32, 0xFFFFFF);
            if (Duration.between(this.coordinatesCopiedTime, Instant.now()).toSeconds() >= 8L) {
                this.coordinatesCopiedMsg = null;
                this.coordinatesCopiedTime = null;
            }
        }
        Instant renderEnd = Instant.now();
        this.frametimes.add(Duration.between(renderStart, renderEnd).abs().toMillis());
        while (this.frametimes.size() > 30) {
            this.frametimes.poll();
        }
        long sum = this.frametimes.stream().reduce(0L, Long::sum);
        if (this.config.showFrameTime) {
            guiGraphics.m_280488_(this.minecraft.f_91062_, sum / (long)this.frametimes.size() + " ms", 5, 5, 0xFFFFFF);
        }
    }

    private TextureCoordinate blockToTexture(BlockPos blockPos) {
        BlockPos center = this.center();
        int xMin = center.m_123341_() - this.texWidth * this.scaleBlockPos / 2 - 1;
        int zMin = center.m_123343_() - this.texHeight * this.scaleBlockPos / 2 - 1;
        return new TextureCoordinate((blockPos.m_123341_() - xMin) / 4 * 4 / this.scaleBlockPos, (blockPos.m_123343_() - zMin) / 4 * 4 / this.scaleBlockPos);
    }

    private void putHoverStructEntry(TextureCoordinate pos, StructHoverHelperEntry entry) {
        int cellX = Math.max(0, Math.min(this.hoverHelperGridWidth - 1, pos.x / 64));
        int cellZ = Math.max(0, Math.min(this.hoverHelperGridHeight - 1, pos.z / 64));
        this.hoverHelperGrid[cellX * this.hoverHelperGridHeight + cellZ].entries.add(entry);
    }

    private void queueGeneration() {
        BlockPos center = this.center();
        int xMin = center.m_123341_() - this.texWidth * this.scaleBlockPos / 2 - 1;
        int xMax = center.m_123341_() + this.texWidth * this.scaleBlockPos / 2 + 1;
        int zMin = center.m_123343_() - this.texHeight * this.scaleBlockPos / 2 - 1;
        int zMax = center.m_123343_() + this.texHeight * this.scaleBlockPos / 2 + 1;
        int y = center.m_123342_();
        this.workManager.queueRange(new BlockPos(xMin, y, zMin), new BlockPos(xMax, y, zMax));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RenderHelper> generateRenderData() {
        PreviewStorage storage;
        BlockPos center = this.center();
        int xMin = center.m_123341_() - this.texWidth * this.scaleBlockPos / 2 - 1;
        int zMin = center.m_123343_() - this.texHeight * this.scaleBlockPos / 2 - 1;
        int quartExpand = this.renderSettings.quartExpand();
        int quartStride = this.renderSettings.quartStride();
        int quartsInWidth = this.texWidth / quartExpand * quartStride;
        int quartsInHeight = this.texHeight / quartExpand * quartStride;
        int minQuartX = QuartPos.m_175400_((int)xMin);
        int minQuartZ = QuartPos.m_175400_((int)zMin);
        int maxQuartX = minQuartX + quartsInWidth;
        int maxQuartZ = minQuartZ + quartsInHeight;
        int quartX = minQuartX;
        int quartY = QuartPos.m_175400_((int)center.m_123342_());
        int quartZ = minQuartZ;
        int sectionStartTexX = 0;
        int sectionStartTexZ = 0;
        ArrayList<RenderHelper> res = new ArrayList<RenderHelper>((quartsInWidth / 64 + 2) * (quartsInHeight / 64 + 2));
        PreviewStorage previewStorage = storage = this.workManager.previewStorage();
        synchronized (previewStorage) {
            while (true) {
                long flag = this.renderSettings.mode.flag;
                int useY = this.renderSettings.mode.useY ? quartY : 0;
                PreviewSection dataSection = storage.section4(quartX, useY, quartZ, flag);
                PreviewSection structureSection = storage.section4(quartX, 0, quartZ, 1L);
                PreviewSection.AccessData accessData = dataSection.calcQuartOffsetData(quartX, quartZ, maxQuartX, maxQuartZ);
                res.add(new RenderHelper(dataSection, structureSection, accessData, sectionStartTexX, sectionStartTexZ));
                if (accessData.continueX()) {
                    int quartDiffX = accessData.maxX() - accessData.minX();
                    quartX += quartDiffX;
                    sectionStartTexX += quartDiffX * quartExpand / quartStride;
                    continue;
                }
                if (!accessData.continueZ()) break;
                int quartDiffZ = accessData.maxZ() - accessData.minZ();
                quartX = minQuartX;
                quartZ += quartDiffZ;
                sectionStartTexZ += quartDiffZ * quartExpand / quartStride;
                sectionStartTexX = 0;
            }
        }
        return res;
    }

    private void updateTexture(List<RenderHelper> renderData) {
        int texX = 0;
        int texZ = 0;
        int quartExpand = this.renderSettings.quartExpand();
        int quartStride = this.renderSettings.quartStride();
        for (RenderHelper r : renderData) {
            texX = r.sectionStartTexX;
            for (int x = r.accessData.minX(); x < r.accessData.maxX(); x += quartStride) {
                texZ = r.sectionStartTexZ;
                for (int z = r.accessData.minZ(); z < r.accessData.maxZ(); z += quartStride) {
                    short rawData = r.dataSection.get(x, z);
                    int color = -16777216;
                    switch (this.renderSettings.mode) {
                        case BIOMES: {
                            if (rawData < 0) break;
                            int n = color = this.selectedBiomeId >= 0 || this.highlightCaves ? this.colorMapGrayScale[rawData] : this.colorMap[rawData];
                            if (this.selectedBiomeId == rawData || this.highlightCaves && this.cavesMap[rawData]) {
                                color = this.colorMap[rawData];
                            }
                            short s = rawData;
                            this.workingVisibleBiomes[s] = this.workingVisibleBiomes[s] + 1L;
                            break;
                        }
                        case HEIGHTMAP: {
                            if (rawData <= Short.MIN_VALUE) break;
                            color = this.heightColorMap[rawData - this.dataProvider.yMin()];
                            break;
                        }
                        case INTERSECTIONS: {
                            if (rawData >= 0) {
                                color = MapColor.m_284175_((int)rawData).f_283871_;
                                color = PreviewDisplay.textureColor(color == 0 ? 0xFFFFFF : color);
                                break;
                            }
                            if (rawData <= Short.MIN_VALUE) break;
                            color = MapColor.m_284175_((int)(-rawData)).f_283871_;
                            color = PreviewDisplay.highlightColor(PreviewDisplay.textureColor(color == 0 ? 0xFFFFFF : color));
                            break;
                        }
                        case NOISE_TEMPERATURE: 
                        case NOISE_HUMIDITY: 
                        case NOISE_CONTINENTALNESS: 
                        case NOISE_EROSION: 
                        case NOISE_DEPTH: 
                        case NOISE_WEIRDNESS: {
                            if (rawData <= Short.MIN_VALUE) break;
                            float data = (float)rawData / 32767.0f;
                            int idx = Math.min(1023, Math.max(0, 512 + (int)(data * 512.0f)));
                            color = this.noiseColorMap[idx];
                            break;
                        }
                        case NOISE_PEAKS_AND_VALLEYS: {
                            if (rawData <= Short.MIN_VALUE) break;
                            float data = (float)rawData / 0.75f / 32767.0f;
                            float pvData = NoiseRouterData.m_224435_((float)Math.min(1.0f, Math.max(-1.0f, data)));
                            int idx = Math.min(1023, Math.max(0, 512 + (int)(pvData * 512.0f)));
                            color = this.noiseColorMap[idx];
                        }
                    }
                    if (quartExpand > 1) {
                        this.previewImg.m_84997_(texX, texZ, Math.min(this.texWidth - texX, quartExpand), Math.min(this.texHeight - texZ, quartExpand), color);
                    } else {
                        this.previewImg.m_84988_(texX, texZ, color);
                    }
                    texZ += quartExpand;
                }
                texX += quartExpand;
            }
        }
    }

    private void renderStructures(List<RenderHelper> renderData, GuiGraphics guiGraphics) {
        if (!this.config.sampleStructures) {
            return;
        }
        double guiScale = this.minecraft.m_91268_().m_85449_();
        for (RenderHelper r : renderData) {
            for (PreviewSection.PreviewStruct structure : r.structureSection.structures()) {
                short id = structure.structureId();
                TextureCoordinate texCenter = this.blockToTexture(structure.center());
                IconData iconData = this.structureIcons[id];
                NativeImage icon = iconData.img;
                DynamicTexture iconTexture = iconData.texture;
                ItemStack item = this.structureItems[id];
                if (icon == null && item == null) continue;
                if (icon == null) {
                    icon = this.dummyIcon;
                }
                int xMin = -(icon.m_84982_() / 2);
                int xMax = icon.m_84982_() / 2 + 1 + this.texWidth;
                int zMin = -(icon.m_85084_() / 2);
                int zMax = icon.m_85084_() / 2 + 1 + this.texHeight;
                if (texCenter.x < xMin || texCenter.z < zMin || texCenter.x > xMax || texCenter.z > zMax) continue;
                short s = id;
                this.workingVisibleStructures[s] = this.workingVisibleStructures[s] + 1L;
                if (!this.structureRenderInfoMap[id].show() || this.renderSettings.hideAllStructures) continue;
                int texStartX = texCenter.x - icon.m_84982_() / 2;
                int texStartZ = texCenter.z - icon.m_85084_() / 2;
                int rXMin = (int)((double)texStartX + (double)this.m_252754_() * guiScale);
                int rZMin = (int)((double)texStartZ + (double)this.m_252907_() * guiScale);
                int rXMax = rXMin + icon.m_84982_();
                int rZMax = rZMin + icon.m_85084_();
                if (item != null) {
                    guiGraphics.m_280480_(item, rXMin, rZMin);
                } else if (iconTexture != null) {
                    WorldPreviewClient.renderTexture((AbstractTexture)iconTexture, rXMin, rZMin, rXMax, rZMax);
                }
                this.putHoverStructEntry(texCenter, new StructHoverHelperEntry(new BoundingBox(texStartX, 0, texStartZ, texStartX + icon.m_84982_(), 0, texStartZ + icon.m_85084_()), structure));
            }
        }
    }

    private void renderPlayerAndSpawn() {
        if (!this.config.showPlayer) {
            return;
        }
        PreviewDisplayDataProvider.PlayerData playerData = this.dataProvider.getPlayerData(this.minecraft.m_91094_().m_240411_());
        if (playerData.currentPos() != null) {
            this.renderStickyIcon(this.playerIcon, playerData.currentPos());
        }
        if (playerData.spawnPos() != null) {
            this.renderStickyIcon(this.spawnIcon, playerData.spawnPos());
        }
    }

    private void renderStickyIcon(IconData iconData, BlockPos pos) {
        double guiScale = this.minecraft.m_91268_().m_85449_();
        NativeImage icon = iconData.img;
        TextureCoordinate texCenter = this.blockToTexture(pos);
        texCenter = new TextureCoordinate(Math.max(0, Math.min(this.texWidth, texCenter.x)), Math.max(0, Math.min(this.texHeight, texCenter.z)));
        int texStartX = texCenter.x - icon.m_84982_();
        int texStartZ = texCenter.z - icon.m_85084_();
        int rXMin = (int)((double)texStartX + (double)this.m_252754_() * guiScale);
        int rZMin = (int)((double)texStartZ + (double)this.m_252907_() * guiScale);
        int rXMax = rXMin + icon.m_84982_() * 2;
        int rZMax = rZMin + icon.m_85084_() * 2;
        WorldPreviewClient.renderTexture((AbstractTexture)iconData.texture, rXMin, rZMin, rXMax, rZMax);
    }

    private void biomesChanged() {
        short i;
        Short2LongOpenHashMap tempBiomesSet = new Short2LongOpenHashMap(this.workingVisibleBiomes.length);
        Short2LongOpenHashMap tempStructuresSet = new Short2LongOpenHashMap(this.workingVisibleStructures.length);
        for (i = 0; i < this.workingVisibleBiomes.length; i = (short)((short)(i + 1))) {
            if (this.workingVisibleBiomes[i] <= 0L) continue;
            tempBiomesSet.put(i, this.workingVisibleBiomes[i]);
        }
        for (i = 0; i < this.workingVisibleStructures.length; i = (short)(i + 1)) {
            if (this.workingVisibleStructures[i] <= 0L) continue;
            tempStructuresSet.put(i, this.workingVisibleStructures[i]);
        }
        if (!tempBiomesSet.equals(this.visibleBiomes)) {
            this.dataProvider.onVisibleBiomesChanged((Short2LongMap)tempBiomesSet);
        }
        if (!tempStructuresSet.equals(this.visibleStructures)) {
            this.dataProvider.onVisibleStructuresChanged((Short2LongMap)tempStructuresSet);
        }
        this.visibleBiomes = tempBiomesSet;
        this.visibleStructures = tempStructuresSet;
    }

    private HoverInfo hoveredBiome(double mouseX, double mouseY) {
        if (!this.f_93622_ || this.workManager.previewStorage() == null) {
            return null;
        }
        int guiScale = (int)this.minecraft.m_91268_().m_85449_();
        BlockPos center = this.center();
        int xMin = center.m_123341_() - this.texWidth / 2 * this.scaleBlockPos - 1;
        int zMin = center.m_123343_() - this.texHeight / 2 * this.scaleBlockPos - 1;
        int xPos = (int)((mouseX - (double)this.m_252754_()) * (double)guiScale * (double)this.scaleBlockPos);
        int zPos = (int)((mouseY - (double)this.m_252907_()) * (double)guiScale * (double)this.scaleBlockPos);
        int quartX = QuartPos.m_175400_((int)(xMin + xPos));
        int quartY = QuartPos.m_175400_((int)center.m_123342_());
        int quartZ = QuartPos.m_175400_((int)(zMin + zPos));
        short biome = this.workManager.previewStorage().getRawData4(quartX, quartY, quartZ, 0L);
        short height = this.workManager.previewStorage().getRawData4(quartX, 0, quartZ, 2L);
        if (biome < 0) {
            return new HoverInfo(xMin + xPos, center.m_123342_(), zMin + zPos, null, height, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN);
        }
        short temperature = this.workManager.previewStorage().getRawData4(quartX, quartY, quartZ, 9L);
        short humidity = this.workManager.previewStorage().getRawData4(quartX, quartY, quartZ, 10L);
        short continentalness = this.workManager.previewStorage().getRawData4(quartX, quartY, quartZ, 11L);
        short erosion = this.workManager.previewStorage().getRawData4(quartX, quartY, quartZ, 12L);
        short depth = this.workManager.previewStorage().getRawData4(quartX, quartY, quartZ, 13L);
        short weirdness = this.workManager.previewStorage().getRawData4(quartX, quartY, quartZ, 14L);
        if (temperature == Short.MIN_VALUE && humidity == Short.MIN_VALUE && continentalness == Short.MIN_VALUE && erosion == Short.MIN_VALUE && depth == Short.MIN_VALUE && weirdness == Short.MIN_VALUE) {
            return new HoverInfo(xMin + xPos, center.m_123342_(), zMin + zPos, this.dataProvider.biome4Id(biome), height, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN);
        }
        return new HoverInfo(xMin + xPos, center.m_123342_(), zMin + zPos, this.dataProvider.biome4Id(biome), height, (double)temperature / 1.0 / 32767.0, (double)humidity / 1.0 / 32767.0, (double)continentalness / 0.5 / 32767.0, (double)erosion / 1.0 / 32767.0, (double)depth / 0.5 / 32767.0, (double)weirdness / 0.75 / 32767.0, NoiseRouterData.m_224435_((float)Math.min(1.0f, Math.max(-1.0f, (float)weirdness / 0.75f / 32767.0f))));
    }

    private List<StructHoverHelperEntry> hoveredStructures(double mouseX, double mouseY) {
        if (!this.f_93622_) {
            return List.of();
        }
        int guiScale = (int)this.minecraft.m_91268_().m_85449_();
        int xTexPos = (int)(mouseX - (double)this.m_252754_()) * guiScale;
        int zTexPos = (int)(mouseY - (double)this.m_252907_()) * guiScale;
        int xGridPos = xTexPos / 64;
        int zGridPos = zTexPos / 64;
        ArrayList<StructHoverHelperEntry> res = new ArrayList<StructHoverHelperEntry>();
        for (int x = xGridPos - 1; x <= xGridPos + 1; ++x) {
            for (int z = zGridPos - 1; z <= zGridPos + 1; ++z) {
                if (x < 0 || x >= this.hoverHelperGridWidth || z < 0 || z >= this.hoverHelperGridHeight) continue;
                StructHoverHelperCell cell = this.hoverHelperGrid[x * this.hoverHelperGridHeight + z];
                for (StructHoverHelperEntry entry : cell.entries) {
                    if (!entry.boundingBox.m_260866_(xTexPos, 0, zTexPos)) continue;
                    res.add(entry);
                }
            }
        }
        return res;
    }

    private static String nameFormatter(String s) {
        int idx = s.indexOf(58);
        if (idx < 0) {
            return "\u00a7e" + s + "\u00a7r";
        }
        return String.format("\u00a75\u00a7o%s\u00a7r\u00a75:%s\u00a7r", s.substring(0, idx), s.substring(idx + 1));
    }

    private void updateTooltip(double mouseX, double mouseY) {
        HoverInfo hoverInfo = this.hoveredBiome(mouseX, mouseY);
        List<StructHoverHelperEntry> structuresInfos = this.hoveredStructures(mouseX, mouseY);
        if (hoverInfo == null && structuresInfos.isEmpty()) {
            this.m_257544_(null);
            return;
        }
        String blockPosTemplate = "\u00a73X=\u00a7b%d\u00a7r\u00a0\u00a73Y=\u00a7b%d\u00a7r\u00a0\u00a73Z=\u00a7b%d\u00a7r";
        if (!structuresInfos.isEmpty()) {
            PreviewSection.PreviewStruct structure = structuresInfos.get((int)0).structure;
            if (this.config.showControls) {
                this.m_257544_(Tooltip.m_257550_((Component)Component.m_237110_((String)"world_preview.preview-display.struct.tooltip.controls", (Object[])new Object[]{PreviewDisplay.nameFormatter(this.dataProvider.structure4Id(structure.structureId()).name()), blockPosTemplate.formatted(structure.center().m_123341_(), structure.center().m_123342_(), structure.center().m_123343_())})));
            } else {
                this.m_257544_(Tooltip.m_257550_((Component)Component.m_237110_((String)"world_preview.preview-display.struct.tooltip", (Object[])new Object[]{PreviewDisplay.nameFormatter(this.dataProvider.structure4Id(structure.structureId()).name()), blockPosTemplate.formatted(structure.center().m_123341_(), structure.center().m_123342_(), structure.center().m_123343_())})));
            }
            return;
        }
        String height = hoverInfo.height > Short.MIN_VALUE ? String.format("\u00a7b%d\u00a7r", hoverInfo.height) : "\u00a77<N/A>\u00a7r";
        String noise = "";
        if (!Double.isNaN(hoverInfo.temperature)) {
            noise = "\n\n\u00a73T=\u00a7b%.2f\u00a7r\u00a0\u00a73H=\u00a7b%.2f\u00a7r\u00a0\u00a73C=\u00a7b%.2f\u00a7r\n\u00a73E=\u00a7b%.2f\u00a7r\u00a0\u00a73D=\u00a7b%.2f\u00a7r\u00a0\u00a73W=\u00a7b%.2f\u00a7r\n\u00a73PV=\u00a7b%.2f\u00a7r".formatted(hoverInfo.temperature, hoverInfo.humidity, hoverInfo.continentalness, hoverInfo.erosion, hoverInfo.depth, hoverInfo.weirdness, hoverInfo.pv);
        }
        if (this.config.showControls) {
            this.m_257544_(Tooltip.m_257550_((Component)Component.m_237110_((String)"world_preview.preview-display.tooltip.controls", (Object[])new Object[]{PreviewDisplay.nameFormatter(hoverInfo.entry == null ? "<N/A>" : hoverInfo.entry.name()), blockPosTemplate.formatted(hoverInfo.blockX, hoverInfo.blockY, hoverInfo.blockZ), height, noise})));
        } else {
            this.m_257544_(Tooltip.m_257550_((Component)Component.m_237110_((String)"world_preview.preview-display.tooltip", (Object[])new Object[]{PreviewDisplay.nameFormatter(hoverInfo.entry == null ? "<N/A>" : hoverInfo.entry.name()), blockPosTemplate.formatted(hoverInfo.blockX, hoverInfo.blockY, hoverInfo.blockZ), height, noise})));
        }
    }

    public void m_7435_(SoundManager handler) {
    }

    public void m_5716_(double mouseX, double mouseY) {
        if (this.minecraft.f_91080_ != null) {
            this.minecraft.f_91080_.m_7522_((GuiEventListener)this);
        }
        this.clicked = true;
    }

    protected void m_7212_(double mouseX, double mouseY, double dragX, double dragY) {
        double guiScale = this.minecraft.m_91268_().m_85449_();
        this.totalDragX -= dragX * guiScale * (double)this.scaleBlockPos;
        this.totalDragZ -= dragY * guiScale * (double)this.scaleBlockPos;
    }

    public void m_7691_(double mouseX, double mouseY) {
        if (!this.clicked) {
            return;
        }
        this.clicked = false;
        if (Math.abs(this.totalDragX) <= 4.0 && Math.abs(this.totalDragZ) <= 4.0) {
            HoverInfo hoverInfo = this.hoveredBiome(mouseX, mouseY);
            if (hoverInfo == null || hoverInfo.entry == null) {
                return;
            }
            super.m_7435_(this.minecraft.m_91106_());
            if (this.selectedBiomeId == hoverInfo.entry.id()) {
                this.dataProvider.onBiomeVisuallySelected(null);
            } else {
                this.dataProvider.onBiomeVisuallySelected(hoverInfo.entry);
            }
        }
        this.renderSettings.setCenter(this.center());
        this.totalDragX = 0.0;
        this.totalDragZ = 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        PreviewDisplayDataProvider previewDisplayDataProvider = this.dataProvider;
        synchronized (previewDisplayDataProvider) {
            if (this.dataProvider.isUpdating()) {
                return true;
            }
            if (delta > 0.0) {
                this.renderSettings.decrementY();
            } else if (delta < 0.0) {
                this.renderSettings.incrementY();
            }
            return true;
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_93680_(mouseX, mouseY) && button == 1) {
            this.m_7435_(this.minecraft.m_91106_());
            HoverInfo hoverInfo = this.hoveredBiome(mouseX, mouseY);
            if (hoverInfo == null) {
                return true;
            }
            String coordinates = String.format("%s %s %s", hoverInfo.blockX, hoverInfo.height == Short.MIN_VALUE ? "~" : Short.valueOf(hoverInfo.height), hoverInfo.blockZ);
            this.minecraft.f_91068_.m_90911_(coordinates);
            this.coordinatesCopiedTime = Instant.now();
            this.coordinatesCopiedMsg = Component.m_237110_((String)"world_preview.preview-display.coordinates.copied", (Object[])new Object[]{coordinates});
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private static int textureColor(int orig) {
        int R = orig >> 16 & 0xFF;
        int G = orig >> 8 & 0xFF;
        int B = orig >> 0 & 0xFF;
        return R << 0 | G << 8 | B << 16 | 0xFF000000;
    }

    private static int highlightColor(int orig) {
        int R = orig >> 16 & 0xFF;
        int G = orig >> 8 & 0xFF;
        int B = orig >> 0 & 0xFF;
        int diff = (R + G + B) / 3 > 200 ? -100 : 100;
        R += diff;
        G += diff;
        B += diff;
        R = Math.max(Math.min(R, 255), 0);
        G = Math.max(Math.min(G, 255), 0);
        B = Math.max(Math.min(B, 255), 0);
        return 0xFF000000 | R << 16 | G << 8 | B;
    }

    private static int grayScale(int orig) {
        int R = orig >> 16 & 0xFF;
        int G = orig >> 8 & 0xFF;
        int B = orig >> 0 & 0xFF;
        int gray = Math.max(32, Math.min(224, (R + G + B) / 3));
        return 0xFF000000 | gray << 16 | gray << 8 | gray;
    }

    public void setSelectedBiomeId(short biomeId) {
        this.selectedBiomeId = biomeId;
    }

    public void setHighlightCaves(boolean highlightCaves) {
        this.highlightCaves = highlightCaves;
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
    }

    private record IconData(@NotNull NativeImage img, @NotNull DynamicTexture texture) {
        public void close() {
            this.texture.close();
            this.img.close();
        }
    }

    private record StructHoverHelperCell(List<StructHoverHelperEntry> entries) {
    }

    private record TextureCoordinate(int x, int z) {
    }

    private record RenderHelper(PreviewSection dataSection, PreviewSection structureSection, PreviewSection.AccessData accessData, int sectionStartTexX, int sectionStartTexZ) {
    }

    private record StructHoverHelperEntry(BoundingBox boundingBox, PreviewSection.PreviewStruct structure) {
    }

    private record HoverInfo(int blockX, int blockY, int blockZ, BiomesList.BiomeEntry entry, short height, double temperature, double humidity, double continentalness, double erosion, double depth, double weirdness, double pv) {
    }
}

