/*
 * Decompiled with CFR 0.152.
 */
package caeruleusTait.world.preview.client.gui.screens.settings;

import caeruleusTait.world.preview.WorldPreview;
import caeruleusTait.world.preview.WorldPreviewConfig;
import caeruleusTait.world.preview.backend.color.ColorMap;
import caeruleusTait.world.preview.backend.color.PreviewData;
import caeruleusTait.world.preview.client.WorldPreviewClient;
import caeruleusTait.world.preview.client.WorldPreviewComponents;
import caeruleusTait.world.preview.client.gui.widgets.WGCheckbox;
import caeruleusTait.world.preview.client.gui.widgets.WGLabel;
import caeruleusTait.world.preview.client.gui.widgets.lists.AbstractSelectionListHolder;
import caeruleusTait.world.preview.client.gui.widgets.lists.BaseObjectSelectionList;
import com.mojang.blaze3d.platform.NativeImage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.NotNull;

public class HeightmapTab
implements Tab {
    private final WorldPreviewConfig cfg;
    private final WGLabel disabledWarning;
    private final WGLabel presetsHead;
    private final HeightPresetList heightPresetList;
    private final AbstractSelectionListHolder<HeightPresetList.HeightPresetEntry, HeightPresetList> heightPresetListHolder;
    private final EditBox minYBox;
    private final EditBox maxYBox;
    private final WGLabel minYLabel;
    private final WGLabel maxYLabel;
    private final WGCheckbox visualYRange;
    private final WGLabel colormapHead;
    private final ColormapList colormapList;
    private final AbstractSelectionListHolder<ColormapList.ColormapEntry, ColormapList> colormapListHolder;
    private final List<AbstractWidget> toRender = new ArrayList<AbstractWidget>();

    public HeightmapTab(Minecraft minecraft, PreviewData previewData) {
        this.cfg = WorldPreview.get().cfg();
        Font font = minecraft.f_91062_;
        this.disabledWarning = new WGLabel(font, 0, 0, 100, 20, WGLabel.TextAlignment.CENTER, WorldPreviewComponents.SETTINGS_HEIGHTMAP_DISABLED, 0xFFFFFF);
        this.toRender.add(this.disabledWarning);
        this.presetsHead = new WGLabel(font, 0, 0, 100, 10, WGLabel.TextAlignment.CENTER, WorldPreviewComponents.SETTINGS_HEIGHTMAP_PRESETS, 0xFFFFFF);
        this.colormapHead = new WGLabel(font, 0, 0, 100, 10, WGLabel.TextAlignment.CENTER, WorldPreviewComponents.SETTINGS_HEIGHTMAP_COLORMAP, 0xFFFFFF);
        this.toRender.add(this.presetsHead);
        this.toRender.add(this.colormapHead);
        this.minYBox = new EditBox(font, 0, 0, 100, 20, WorldPreviewComponents.SETTINGS_HEIGHTMAP_MIN_Y);
        this.maxYBox = new EditBox(font, 0, 0, 100, 20, WorldPreviewComponents.SETTINGS_HEIGHTMAP_MAX_Y);
        this.minYBox.m_257544_(Tooltip.m_257550_((Component)WorldPreviewComponents.SETTINGS_HEIGHTMAP_MIN_Y_TOOLTIP));
        this.maxYBox.m_257544_(Tooltip.m_257550_((Component)WorldPreviewComponents.SETTINGS_HEIGHTMAP_MAX_Y_TOOLTIP));
        this.minYBox.m_94153_(HeightmapTab::isInteger);
        this.maxYBox.m_94153_(HeightmapTab::isInteger);
        this.minYBox.m_94144_(String.valueOf(this.cfg.heightmapMinY));
        this.maxYBox.m_94144_(String.valueOf(this.cfg.heightmapMaxY));
        this.minYBox.m_94151_(x -> {
            this.cfg.heightmapMinY = x.isBlank() ? 0 : Integer.parseInt(x);
        });
        this.maxYBox.m_94151_(x -> {
            this.cfg.heightmapMaxY = x.isBlank() ? 0 : Integer.parseInt(x);
        });
        this.toRender.add((AbstractWidget)this.minYBox);
        this.toRender.add((AbstractWidget)this.maxYBox);
        this.minYLabel = new WGLabel(font, 0, 0, 64, 20, WGLabel.TextAlignment.LEFT, WorldPreviewComponents.SETTINGS_HEIGHTMAP_MIN_Y, 0xFFFFFF);
        this.maxYLabel = new WGLabel(font, 0, 0, 64, 20, WGLabel.TextAlignment.LEFT, WorldPreviewComponents.SETTINGS_HEIGHTMAP_MAX_Y, 0xFFFFFF);
        this.minYLabel.m_257544_(Tooltip.m_257550_((Component)WorldPreviewComponents.SETTINGS_HEIGHTMAP_MIN_Y_TOOLTIP));
        this.maxYLabel.m_257544_(Tooltip.m_257550_((Component)WorldPreviewComponents.SETTINGS_HEIGHTMAP_MAX_Y_TOOLTIP));
        this.toRender.add(this.minYLabel);
        this.toRender.add(this.maxYLabel);
        this.visualYRange = new WGCheckbox(0, 0, 100, 20, WorldPreviewComponents.SETTINGS_HEIGHTMAP_VISUAL, x -> {
            this.cfg.onlySampleInVisualRange = x.m_93840_();
        }, this.cfg.onlySampleInVisualRange);
        this.visualYRange.m_257544_(Tooltip.m_257550_((Component)WorldPreviewComponents.SETTINGS_HEIGHTMAP_VISUAL_TOOLTIP));
        this.toRender.add((AbstractWidget)this.visualYRange);
        this.heightPresetList = new HeightPresetList(minecraft, 100, 100, 0, 0);
        this.heightPresetList.m_5988_(previewData.heightmapPresets().stream().map(entry -> this.heightPresetList.createEntry(entry.name(), entry.minY(), entry.maxY(), x -> {
            this.cfg.heightmapMinY = x.minY;
            this.cfg.heightmapMaxY = x.maxY;
            this.minYBox.m_94144_(String.valueOf(x.minY));
            this.maxYBox.m_94144_(String.valueOf(x.maxY));
        })).toList());
        this.heightPresetListHolder = new AbstractSelectionListHolder(this.heightPresetList, 0, 0, 100, 100, (Component)Component.m_237119_());
        this.toRender.add(this.heightPresetListHolder);
        this.colormapList = new ColormapList(minecraft, 100, 100, 0, 0);
        Map<String, ColormapList.ColormapEntry> colormaps = previewData.colorMaps().values().stream().map(colorMap -> this.colormapList.createEntry((ColorMap)colorMap, x -> {
            this.cfg.colorMap = x.colorMap.key().toString();
        })).collect(Collectors.toMap(x -> x.colorMap.key().toString(), x -> x));
        this.colormapList.m_5988_(colormaps.values().stream().sorted(Comparator.comparing(x -> x.name)).toList());
        this.colormapList.m_6987_((AbstractSelectionList.Entry)colormaps.get(this.cfg.colorMap));
        this.colormapListHolder = new AbstractSelectionListHolder(this.colormapList, 0, 0, 100, 100, (Component)Component.m_237119_());
        this.toRender.add(this.colormapListHolder);
    }

    private static boolean isInteger(String s) {
        if (s.isBlank()) {
            return true;
        }
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @NotNull
    public Component m_267600_() {
        return WorldPreviewComponents.SETTINGS_HEIGHTMAP_TITLE;
    }

    public void m_267609_(Consumer<AbstractWidget> consumer) {
        this.toRender.forEach(consumer);
    }

    public void m_267697_(ScreenRectangle screenRectangle) {
        int bottomL;
        int topL;
        int center = screenRectangle.f_263770_() / 2;
        int leftL = screenRectangle.m_274563_() + 3;
        int leftR = center + 3;
        int topR = topL = screenRectangle.m_274449_() + 2;
        int bottomR = bottomL = screenRectangle.m_274349_() - 36;
        int secWidth = screenRectangle.f_263770_() / 2 - leftL - 4;
        if (this.cfg.sampleHeightmap) {
            this.disabledWarning.f_93624_ = false;
        } else {
            this.disabledWarning.f_93624_ = true;
            this.disabledWarning.m_264152_(screenRectangle.m_274563_(), topL);
            this.disabledWarning.m_93674_(screenRectangle.f_263770_());
            topR = topL += 24;
        }
        int labelWidth = 100;
        this.visualYRange.m_264152_(leftL, bottomL);
        this.visualYRange.m_93674_(secWidth);
        this.maxYLabel.m_264152_(leftL, bottomL -= 24);
        this.maxYLabel.m_93674_(100);
        this.maxYBox.m_264152_(leftL + 100, bottomL);
        this.maxYBox.m_93674_(secWidth - 100);
        this.minYLabel.m_264152_(leftL, bottomL -= 24);
        this.minYLabel.m_93674_(100);
        this.minYBox.m_264152_(leftL + 100, bottomL);
        this.minYBox.m_93674_(secWidth - 100);
        this.presetsHead.m_264152_(leftL, topL);
        this.presetsHead.m_93674_(secWidth);
        this.heightPresetListHolder.m_264152_(leftL, topL += 14);
        this.heightPresetListHolder.setSize(secWidth, bottomL - topL - 4);
        this.heightPresetList.m_93488_(true);
        this.heightPresetList.m_93496_(false);
        this.colormapHead.m_264152_(leftR, topR);
        this.colormapHead.m_93674_(secWidth);
        this.colormapListHolder.m_264152_(leftR, topR += 14);
        this.colormapListHolder.setSize(secWidth, bottomR - topR + 20);
        this.colormapList.m_93488_(true);
        this.colormapList.m_93496_(false);
    }

    public static class HeightPresetList
    extends BaseObjectSelectionList<HeightPresetEntry> {
        public HeightPresetList(Minecraft minecraft, int width, int height, int x, int y) {
            super(minecraft, width, height, x, y, 16);
        }

        public HeightPresetEntry createEntry(String name, int minY, int maxY, Consumer<HeightPresetEntry> onClick) {
            return new HeightPresetEntry(name, minY, maxY, onClick);
        }

        public class HeightPresetEntry
        extends BaseObjectSelectionList.Entry<HeightPresetEntry> {
            public final String name;
            public final int minY;
            public final int maxY;
            private final Consumer<HeightPresetEntry> onClick;
            private final String displayString;

            public HeightPresetEntry(String name, int minY, int maxY, Consumer<HeightPresetEntry> onClick) {
                this.name = name;
                this.minY = minY;
                this.maxY = maxY;
                this.onClick = onClick;
                this.displayString = String.format("%s: \u00a73y=\u00a7b%d\u00a7r\u00a73-\u00a7b%d\u00a7r", this.name, this.minY, this.maxY);
            }

            @NotNull
            public Component m_142172_() {
                return Component.m_237119_();
            }

            public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean bl, float partialTick) {
                guiGraphics.m_280488_(((HeightPresetList)HeightPresetList.this).f_93386_.f_91062_, this.displayString, left + 4, top + 2, 0xFFFFFF);
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                HeightPresetList.this.f_93386_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                this.onClick.accept(this);
                return true;
            }
        }
    }

    public static class ColormapList
    extends BaseObjectSelectionList<ColormapEntry> {
        public ColormapList(Minecraft minecraft, int width, int height, int x, int y) {
            super(minecraft, width, height, x, y, 32);
        }

        public ColormapEntry createEntry(ColorMap colorMap, Consumer<ColormapEntry> onClick) {
            return new ColormapEntry(colorMap, onClick);
        }

        public class ColormapEntry
        extends BaseObjectSelectionList.Entry<ColormapEntry> {
            public final String name;
            public final ColorMap colorMap;
            private final Consumer<ColormapEntry> onClick;
            private final NativeImage colormapImg;
            private final DynamicTexture colormapTexture;

            public ColormapEntry(ColorMap colorMap, Consumer<ColormapEntry> onClick) {
                this.name = colorMap.name();
                this.colorMap = colorMap;
                this.onClick = onClick;
                this.colormapImg = new NativeImage(NativeImage.Format.RGBA, 1024, 1, true);
                this.colormapTexture = new DynamicTexture(this.colormapImg);
                for (int i = 0; i < 1024; ++i) {
                    this.colormapImg.m_84988_(i, 0, colorMap.getARGB((float)i / 1024.0f));
                }
                this.colormapTexture.m_117985_();
            }

            @NotNull
            public Component m_142172_() {
                return Component.m_237119_();
            }

            public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean bl, float partialTick) {
                guiGraphics.m_280488_(((ColormapList)ColormapList.this).f_93386_.f_91062_, this.name, left + 4, top + 2, 0xFFFFFF);
                int xMin = left + 5;
                int yMin = top + 14;
                int xMax = left + width - 5;
                int yMax = top + height - 3;
                WorldPreviewClient.renderTexture((AbstractTexture)this.colormapTexture, xMin, yMin, xMax, yMax);
                int colorBorder = -6710887;
                guiGraphics.m_280509_(xMin - 1, yMin - 1, xMax + 1, yMin, -6710887);
                guiGraphics.m_280509_(xMax, yMin, xMax + 1, yMax, -6710887);
                guiGraphics.m_280509_(xMin - 1, yMax, xMax + 1, yMax + 1, -6710887);
                guiGraphics.m_280509_(xMin - 1, yMin, xMin, yMax, -6710887);
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                ColormapList.this.f_93386_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                this.onClick.accept(this);
                return true;
            }
        }
    }
}

