/*
 * Decompiled with CFR 0.152.
 */
package caeruleusTait.world.preview.client.gui.screens;

import caeruleusTait.world.preview.WorldPreview;
import caeruleusTait.world.preview.backend.storage.PreviewStorage;
import caeruleusTait.world.preview.client.WorldPreviewComponents;
import caeruleusTait.world.preview.client.gui.PreviewContainerDataProvider;
import caeruleusTait.world.preview.client.gui.screens.PreviewCacheLoadingScreen;
import caeruleusTait.world.preview.client.gui.screens.PreviewContainer;
import caeruleusTait.world.preview.mixin.MinecraftServerAccessor;
import java.nio.file.Path;
import java.security.InvalidParameterException;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.jetbrains.annotations.Nullable;

public class InGamePreviewScreen
extends Screen
implements PreviewContainerDataProvider {
    private IntegratedServer integratedServer;
    private PreviewContainer previewContainer;
    private final WorldPreview worldPreview = WorldPreview.get();

    public InGamePreviewScreen() {
        super(WorldPreviewComponents.TITLE_FULL);
    }

    protected void m_7856_() {
        if (this.integratedServer == null) {
            this.integratedServer = this.f_96541_.m_91092_();
            if (this.integratedServer == null) {
                throw new InvalidParameterException("No integrated server!");
            }
        }
        if (this.previewContainer == null) {
            this.previewContainer = new PreviewContainer(this, this);
            this.previewContainer.start();
        }
        this.previewContainer.widgets().forEach(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
        this.previewContainer.doLayout(new ScreenRectangle(0, 18, this.f_96543_, this.f_96544_ - 38));
        Button btn = Button.m_253074_((Component)CommonComponents.f_130660_, x -> this.m_7379_()).m_252780_(100).m_252794_(this.f_96543_ / 2 - 50, this.f_96544_ - 24).m_253136_();
        this.m_142416_((GuiEventListener)btn);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280039_(guiGraphics);
        guiGraphics.m_280653_(this.f_96541_.f_91062_, WorldPreviewComponents.TITLE_FULL, this.f_96543_ / 2, 6, 0xFFFFFF);
        guiGraphics.m_280163_(CreateWorldScreen.f_273875_, 0, Mth.m_144941_((int)(this.f_96544_ - 30), (int)2), 0.0f, 0.0f, this.f_96543_, 2, 32, 2);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        this.worldPreview.saveConfig();
        this.previewContainer.close();
        super.m_7379_();
    }

    @Override
    public Path cacheDir() {
        LevelStorageSource.LevelStorageAccess access = ((MinecraftServerAccessor)this.integratedServer).getStorageSource();
        Path previewDir = access.m_78283_(LevelResource.f_78182_).resolve("world-preview");
        previewDir.toFile().mkdirs();
        return previewDir;
    }

    private String filename() {
        return String.format("%s.zip", this.cacheFileCompatPart());
    }

    @Override
    public void storePreviewStorage(long seed, PreviewStorage storage) {
        if (!this.worldPreview.cfg().cacheInGame) {
            return;
        }
        this.f_96541_.m_91346_((Screen)new PreviewCacheLoadingScreen(WorldPreviewComponents.SAVING_PREVIEW));
        this.writeCacheFile(this.previewContainer.workManager().previewStorage(), this.cacheDir().resolve(this.filename()));
    }

    @Override
    public PreviewStorage loadPreviewStorage(long seed, int yMin, int yMax) {
        if (!this.worldPreview.cfg().cacheInGame) {
            return new PreviewStorage(yMin, yMax);
        }
        this.f_96541_.m_91346_((Screen)new PreviewCacheLoadingScreen(WorldPreviewComponents.LOADING_PREVIEW));
        PreviewStorage res = this.readCacheFile(yMin, yMax, this.cacheDir().resolve(this.filename()));
        this.f_96541_.m_91346_((Screen)this);
        return res;
    }

    @Override
    @Nullable
    public WorldCreationContext previewWorldCreationContext() {
        return null;
    }

    @Override
    public void registerSettingsChangeListener(Runnable listener) {
    }

    @Override
    public String seed() {
        return String.valueOf(this.integratedServer.m_129783_().m_7328_());
    }

    @Override
    public void updateSeed(String newSeed) {
    }

    @Override
    public boolean seedIsEditable() {
        return false;
    }

    @Override
    @Nullable
    public Path tempDataPackDir() {
        return null;
    }

    @Override
    @Nullable
    public MinecraftServer minecraftServer() {
        return this.integratedServer;
    }

    @Override
    public WorldOptions worldOptions(@Nullable WorldCreationContext wcContext) {
        return this.integratedServer.m_129910_().m_246337_();
    }

    @Override
    public WorldDataConfiguration worldDataConfiguration(@Nullable WorldCreationContext wcContext) {
        return this.integratedServer.m_129910_().m_6645_();
    }

    @Override
    public RegistryAccess.Frozen registryAccess(@Nullable WorldCreationContext wcContext) {
        return this.integratedServer.m_206579_();
    }

    @Override
    public Registry<LevelStem> levelStemRegistry(@Nullable WorldCreationContext wcContext) {
        return this.integratedServer.m_206579_().m_175515_(Registries.f_256862_);
    }

    @Override
    public LayeredRegistryAccess<RegistryLayer> layeredRegistryAccess(@Nullable WorldCreationContext wcContext) {
        return this.integratedServer.m_247573_();
    }
}

