/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.loot.condition;

import com.almostreliable.lootjs.core.ILootContextData;
import com.almostreliable.lootjs.core.LootJSParamSets;
import com.almostreliable.lootjs.loot.condition.IExtendedLootCondition;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;

public class ContainsLootCondition
implements IExtendedLootCondition {
    private final Predicate<ItemStack> predicate;
    private final boolean exact;

    public ContainsLootCondition(Predicate<ItemStack> predicate, boolean exact) {
        this.predicate = predicate;
        this.exact = exact;
    }

    @Override
    public boolean applyLootHandler(LootContext context, List<ItemStack> loot) {
        return this.exact ? this.matchExact(loot) : this.match(loot);
    }

    @Override
    public boolean test(LootContext context) {
        ILootContextData data = (ILootContextData)context.m_78953_(LootJSParamSets.DATA);
        if (data == null) {
            return false;
        }
        return this.applyLootHandler(context, data.getGeneratedLoot());
    }

    private boolean match(List<ItemStack> generatedLoot) {
        for (ItemStack itemStack : generatedLoot) {
            if (!this.predicate.test(itemStack)) continue;
            return true;
        }
        return false;
    }

    private boolean matchExact(List<ItemStack> generatedLoot) {
        for (ItemStack itemStack : generatedLoot) {
            if (this.predicate.test(itemStack)) continue;
            return false;
        }
        return true;
    }
}

