/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.kube;

import com.almostreliable.lootjs.LootJS;
import com.almostreliable.lootjs.core.ILootCondition;
import com.almostreliable.lootjs.filters.ItemFilter;
import com.almostreliable.lootjs.filters.Resolver;
import com.almostreliable.lootjs.kube.builder.DamageSourcePredicateBuilderJS;
import com.almostreliable.lootjs.kube.builder.EntityPredicateBuilderJS;
import com.almostreliable.lootjs.loot.condition.AndCondition;
import com.almostreliable.lootjs.loot.condition.AnyBiomeCheck;
import com.almostreliable.lootjs.loot.condition.AnyDimension;
import com.almostreliable.lootjs.loot.condition.AnyStructure;
import com.almostreliable.lootjs.loot.condition.BiomeCheck;
import com.almostreliable.lootjs.loot.condition.ContainsLootCondition;
import com.almostreliable.lootjs.loot.condition.CustomParamPredicate;
import com.almostreliable.lootjs.loot.condition.IsLightLevel;
import com.almostreliable.lootjs.loot.condition.MainHandTableBonus;
import com.almostreliable.lootjs.loot.condition.MatchEquipmentSlot;
import com.almostreliable.lootjs.loot.condition.MatchKillerDistance;
import com.almostreliable.lootjs.loot.condition.MatchPlayer;
import com.almostreliable.lootjs.loot.condition.NotCondition;
import com.almostreliable.lootjs.loot.condition.OrCondition;
import com.almostreliable.lootjs.loot.condition.PlayerParamPredicate;
import com.almostreliable.lootjs.loot.condition.builder.DistancePredicateBuilder;
import com.almostreliable.lootjs.util.Utils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.stages.Stages;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithLootingCondition;
import net.minecraft.world.level.storage.loot.predicates.TimeCheck;
import net.minecraft.world.level.storage.loot.predicates.WeatherCheck;

public interface LootConditionsContainer<B extends LootConditionsContainer<?>> {
    default public B matchLoot(ItemFilter filter) {
        return this.matchLoot(filter, false);
    }

    default public B matchLoot(ItemFilter filter, boolean exact) {
        return this.addCondition(new ContainsLootCondition(filter, exact));
    }

    default public B matchMainHand(ItemFilter filter) {
        return this.addCondition(new MatchEquipmentSlot(EquipmentSlot.MAINHAND, filter));
    }

    default public B matchOffHand(ItemFilter filter) {
        return this.addCondition(new MatchEquipmentSlot(EquipmentSlot.OFFHAND, filter));
    }

    default public B matchEquip(EquipmentSlot slot, ItemFilter filter) {
        return this.addCondition(new MatchEquipmentSlot(slot, filter));
    }

    default public B survivesExplosion() {
        return this.addCondition(ExplosionCondition.m_81661_());
    }

    default public B timeCheck(long period, int min, int max) {
        return this.addCondition((LootItemCondition.Builder)new TimeCheck.Builder(IntRange.m_165011_((int)min, (int)max)).m_165516_(period));
    }

    default public B timeCheck(int min, int max) {
        return this.timeCheck(24000L, min, max);
    }

    default public B weatherCheck(Map<String, Boolean> map) {
        Boolean isRaining = map.getOrDefault("raining", null);
        Boolean isThundering = map.getOrDefault("thundering", null);
        return this.addCondition((LootItemCondition.Builder)new WeatherCheck.Builder().m_165556_(isRaining).m_165559_(isThundering));
    }

    default public B randomChance(float value) {
        return this.addCondition(LootItemRandomChanceCondition.m_81927_((float)value));
    }

    default public B randomChanceWithLooting(float value, float looting) {
        return this.addCondition(LootItemRandomChanceWithLootingCondition.m_81963_((float)value, (float)looting));
    }

    default public B randomChanceWithEnchantment(@Nullable Enchantment enchantment, float[] chances) {
        if (enchantment == null) {
            throw new IllegalArgumentException("Enchant not found");
        }
        return this.addCondition(new MainHandTableBonus(enchantment, chances));
    }

    default public B randomTableBonus(Enchantment enchantment, float[] chances) {
        return this.addCondition(BonusLevelTableCondition.m_81517_((Enchantment)enchantment, (float[])chances));
    }

    default public B biome(Resolver ... resolvers) {
        ArrayList<ResourceKey<Biome>> biomes = new ArrayList<ResourceKey<Biome>>();
        ArrayList<TagKey<Biome>> tagKeys = new ArrayList<TagKey<Biome>>();
        for (Resolver resolver : resolvers) {
            if (resolver instanceof Resolver.ByEntry) {
                Resolver.ByEntry byEntry = (Resolver.ByEntry)resolver;
                biomes.add(byEntry.resolve(Registries.f_256952_));
                continue;
            }
            if (!(resolver instanceof Resolver.ByTagKey)) continue;
            Resolver.ByTagKey byTagKey = (Resolver.ByTagKey)resolver;
            tagKeys.add(byTagKey.resolve(Registries.f_256952_));
        }
        return this.addCondition(new BiomeCheck(biomes, tagKeys));
    }

    default public B anyBiome(Resolver ... resolvers) {
        ArrayList<ResourceKey<Biome>> biomes = new ArrayList<ResourceKey<Biome>>();
        ArrayList<TagKey<Biome>> tagKeys = new ArrayList<TagKey<Biome>>();
        for (Resolver resolver : resolvers) {
            if (resolver instanceof Resolver.ByEntry) {
                Resolver.ByEntry byEntry = (Resolver.ByEntry)resolver;
                biomes.add(byEntry.resolve(Registries.f_256952_));
                continue;
            }
            if (!(resolver instanceof Resolver.ByTagKey)) continue;
            Resolver.ByTagKey byTagKey = (Resolver.ByTagKey)resolver;
            tagKeys.add(byTagKey.resolve(Registries.f_256952_));
        }
        return this.addCondition(new AnyBiomeCheck(biomes, tagKeys));
    }

    default public B anyDimension(ResourceLocation ... dimensions) {
        return this.addCondition(new AnyDimension(dimensions));
    }

    default public B anyStructure(String[] idOrTags, boolean exact) {
        AnyStructure.Builder builder = new AnyStructure.Builder();
        for (String s : idOrTags) {
            builder.add(s);
        }
        return this.addCondition(builder.build(exact));
    }

    default public B lightLevel(int min, int max) {
        return this.addCondition(new IsLightLevel(min, max));
    }

    default public B killedByPlayer() {
        return this.addCondition(LootItemKilledByPlayerCondition.m_81901_());
    }

    default public B matchBlockState(Block block, Map<String, String> propertyMap) {
        StatePropertiesPredicate.Builder properties = Utils.createProperties(block, propertyMap);
        return this.addCondition((LootItemCondition.Builder)new LootItemBlockStatePropertyCondition.Builder(block).m_81784_(properties));
    }

    default public B matchFluid(Resolver resolver) {
        throw new UnsupportedOperationException("Not implemented in 1.18.2 currently.");
    }

    default public B matchEntity(Consumer<EntityPredicateBuilderJS> action) {
        EntityPredicateBuilderJS builder = new EntityPredicateBuilderJS();
        action.accept(builder);
        return this.addCondition(LootItemEntityPropertyCondition.m_81867_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate)builder.build()));
    }

    default public B matchKiller(Consumer<EntityPredicateBuilderJS> action) {
        EntityPredicateBuilderJS builder = new EntityPredicateBuilderJS();
        action.accept(builder);
        return this.addCondition(LootItemEntityPropertyCondition.m_81867_((LootContext.EntityTarget)LootContext.EntityTarget.KILLER, (EntityPredicate)builder.build()));
    }

    default public B matchDirectKiller(Consumer<EntityPredicateBuilderJS> action) {
        EntityPredicateBuilderJS builder = new EntityPredicateBuilderJS();
        action.accept(builder);
        return this.addCondition(LootItemEntityPropertyCondition.m_81867_((LootContext.EntityTarget)LootContext.EntityTarget.DIRECT_KILLER, (EntityPredicate)builder.build()));
    }

    default public B matchPlayer(Consumer<EntityPredicateBuilderJS> action) {
        EntityPredicateBuilderJS builder = new EntityPredicateBuilderJS();
        action.accept(builder);
        return this.addCondition(new MatchPlayer(builder.build()));
    }

    default public B matchDamageSource(Consumer<DamageSourcePredicateBuilderJS> action) {
        DamageSourcePredicateBuilderJS builder = new DamageSourcePredicateBuilderJS();
        action.accept(builder);
        return this.addCondition(builder);
    }

    default public B distanceToKiller(MinMaxBounds.Doubles bounds) {
        return this.customDistanceToPlayer(builder -> builder.absolute(bounds));
    }

    default public B customDistanceToPlayer(Consumer<DistancePredicateBuilder> action) {
        DistancePredicateBuilder builder = new DistancePredicateBuilder();
        action.accept(builder);
        return this.addCondition(new MatchKillerDistance(builder.build()));
    }

    default public B playerPredicate(Predicate<ServerPlayer> predicate) {
        return this.addCondition(new PlayerParamPredicate(predicate));
    }

    default public B entityPredicate(Predicate<Entity> predicate) {
        return this.addCondition(new CustomParamPredicate<Entity>(LootContextParams.f_81455_, predicate));
    }

    default public B killerPredicate(Predicate<Entity> predicate) {
        return this.addCondition(new CustomParamPredicate<Entity>(LootContextParams.f_81458_, predicate));
    }

    default public B directKillerPredicate(Predicate<Entity> predicate) {
        return this.addCondition(new CustomParamPredicate<Entity>(LootContextParams.f_81459_, predicate));
    }

    default public B blockEntityPredicate(Predicate<BlockEntity> predicate) {
        return this.addCondition(new CustomParamPredicate<BlockEntity>(LootContextParams.f_81462_, predicate));
    }

    default public B hasAnyStage(String ... stages) {
        if (stages.length == 1) {
            String stage = stages[0];
            return this.addCondition(new PlayerParamPredicate(player -> Stages.get((Player)player).has(stage)));
        }
        return this.addCondition(new PlayerParamPredicate(player -> {
            for (String stage : stages) {
                if (!Stages.get((Player)player).has(stage)) continue;
                return true;
            }
            return false;
        }));
    }

    default public B not(Consumer<LootConditionsContainer<B>> action) {
        List<ILootCondition> conditions = this.createConditions(action);
        if (conditions.size() != 1) {
            throw new IllegalArgumentException("You only can have one condition for `not`");
        }
        NotCondition condition = new NotCondition(conditions.get(0));
        return this.addCondition(condition);
    }

    default public B or(Consumer<LootConditionsContainer<B>> action) {
        List<ILootCondition> conditions = this.createConditions(action);
        ILootCondition[] array = conditions.toArray(new ILootCondition[0]);
        return this.addCondition(new OrCondition(array));
    }

    default public B and(Consumer<LootConditionsContainer<B>> action) {
        List<ILootCondition> conditions = this.createConditions(action);
        ILootCondition[] array = conditions.toArray(new ILootCondition[0]);
        return this.addCondition(new AndCondition(array));
    }

    default public List<ILootCondition> createConditions(Consumer<LootConditionsContainer<B>> action) {
        final ArrayList<ILootCondition> conditions = new ArrayList<ILootCondition>();
        LootConditionsContainer container = new LootConditionsContainer<B>(){

            @Override
            public B addCondition(ILootCondition condition) {
                conditions.add(condition);
                return this;
            }
        };
        action.accept(container);
        return conditions;
    }

    default public B customCondition(JsonObject json) {
        LootItemCondition condition = (LootItemCondition)LootJS.CONDITION_GSON.fromJson((JsonElement)json, LootItemCondition.class);
        return this.addCondition((ILootCondition)condition);
    }

    default public B addCondition(LootItemCondition.Builder builder) {
        return this.addCondition((ILootCondition)builder.m_6409_());
    }

    public B addCondition(ILootCondition var1);
}

