/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.forge.kube;

import com.almostreliable.lootjs.kube.LootJSPlugin;
import com.almostreliable.lootjs.kube.LootModificationEventJS;
import dev.latvian.mods.kubejs.event.EventResult;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.loot.IGlobalLootModifier;

public class LootModificationForgeEventJS
extends LootModificationEventJS {
    private final Map<ResourceLocation, IGlobalLootModifier> modifiers;
    private final List<ResourceLocation> removed = new ArrayList<ResourceLocation>();

    public LootModificationForgeEventJS(Map<ResourceLocation, IGlobalLootModifier> modifiers) {
        this.modifiers = modifiers;
    }

    public List<String> getGlobalModifiers() {
        return this.modifiers.keySet().stream().map(ResourceLocation::toString).collect(Collectors.toList());
    }

    public void removeGlobalModifier(String ... locationOrModIds) {
        HashSet<String> modIds = new HashSet<String>();
        HashSet<ResourceLocation> locations = new HashSet<ResourceLocation>();
        for (String locationOrModId : locationOrModIds) {
            if (locationOrModId.startsWith("@")) {
                modIds.add(locationOrModId.substring(1));
                continue;
            }
            locations.add(new ResourceLocation(locationOrModId));
        }
        Set<ResourceLocation> collectedByModIds = this.modifiers.keySet().stream().filter(rl -> modIds.contains(rl.m_135827_())).collect(Collectors.toSet());
        Set<ResourceLocation> collectedByLocations = this.modifiers.keySet().stream().filter(locations::contains).collect(Collectors.toSet());
        this.remove(collectedByModIds);
        this.remove(collectedByLocations);
    }

    private void remove(Set<ResourceLocation> locations) {
        locations.forEach(this.modifiers::remove);
        this.removed.addAll(locations);
    }

    @Override
    protected void afterPosted(EventResult result) {
        super.afterPosted(result);
        if (LootJSPlugin.eventsAreDisabled()) {
            return;
        }
        if (!this.removed.isEmpty()) {
            ConsoleJS.SERVER.info((Object)("[LootJS] Removed " + this.removed.size() + " global loot modifiers: " + this.removed.stream().map(ResourceLocation::toString).collect(Collectors.joining(", "))));
        }
    }
}

