/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.filters;

import com.almostreliable.lootjs.filters.ResourceLocationFilter;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public interface ItemFilter
extends Predicate<ItemStack> {
    public static final ItemFilter ALWAYS_FALSE = itemStack -> false;
    public static final ItemFilter ALWAYS_TRUE = itemStack -> true;
    public static final ItemFilter SWORD = itemStack -> itemStack.m_41720_() instanceof SwordItem;
    public static final ItemFilter PICKAXE = itemStack -> itemStack.m_41720_() instanceof PickaxeItem;
    public static final ItemFilter AXE = itemStack -> itemStack.m_41720_() instanceof AxeItem;
    public static final ItemFilter SHOVEL = itemStack -> itemStack.m_41720_() instanceof ShovelItem;
    public static final ItemFilter HOE = itemStack -> itemStack.m_41720_() instanceof HoeItem;
    public static final ItemFilter TOOL = itemStack -> itemStack.m_41720_() instanceof DiggerItem;
    public static final ItemFilter POTION = itemStack -> itemStack.m_41720_() instanceof PotionItem;
    public static final ItemFilter HAS_TIER = itemStack -> itemStack.m_41720_() instanceof TieredItem;
    public static final ItemFilter PROJECTILE_WEAPON = itemStack -> itemStack.m_41720_() instanceof ProjectileWeaponItem;
    public static final ItemFilter ARMOR = itemStack -> itemStack.m_41720_() instanceof ArmorItem;
    public static final ItemFilter WEAPON = itemStack -> {
        Item i = itemStack.m_41720_();
        return i instanceof SwordItem || i instanceof DiggerItem || i instanceof ProjectileWeaponItem || i instanceof TridentItem;
    };
    public static final ItemFilter HEAD_ARMOR = ItemFilter.equipmentSlot(EquipmentSlot.HEAD);
    public static final ItemFilter CHEST_ARMOR = ItemFilter.equipmentSlot(EquipmentSlot.CHEST);
    public static final ItemFilter LEGS_ARMOR = ItemFilter.equipmentSlot(EquipmentSlot.LEGS);
    public static final ItemFilter FEET_ARMOR = ItemFilter.equipmentSlot(EquipmentSlot.FEET);
    public static final ItemFilter FOOD = ItemStack::m_41614_;
    public static final ItemFilter DAMAGEABLE = ItemStack::m_41763_;
    public static final ItemFilter DAMAGED = ItemStack::m_41768_;
    public static final ItemFilter ENCHANTABLE = ItemStack::m_41792_;
    public static final ItemFilter ENCHANTED = ItemStack::m_41793_;
    public static final ItemFilter BLOCK = itemStack -> itemStack.m_41720_() instanceof BlockItem;

    public static ItemFilter hasEnchantment(ResourceLocationFilter filter) {
        return ItemFilter.hasEnchantment(filter, 1, 255);
    }

    public static ItemFilter hasEnchantment(ResourceLocationFilter filter, int min, int max) {
        return itemStack -> {
            ListTag listTag = itemStack.m_150930_(Items.f_42690_) ? EnchantedBookItem.m_41163_((ItemStack)itemStack) : itemStack.m_41785_();
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag tag = listTag.m_128728_(i);
                ResourceLocation id = EnchantmentHelper.m_182446_((CompoundTag)tag);
                int level = EnchantmentHelper.m_182438_((CompoundTag)tag);
                if (id == null || !filter.test(id) || min > level || level > max) continue;
                return true;
            }
            return false;
        };
    }

    public static ItemFilter equipmentSlot(EquipmentSlot slot) {
        return itemStack -> LivingEntity.m_147233_((ItemStack)itemStack) == slot;
    }

    public static ItemFilter and(ItemFilter ... itemFilters) {
        Objects.requireNonNull(itemFilters);
        return switch (itemFilters.length) {
            case 0 -> ALWAYS_TRUE;
            case 1 -> itemFilters[0];
            case 2 -> itemFilters[0].and(itemFilters[1]);
            default -> itemStack -> {
                for (ItemFilter itemFilter : itemFilters) {
                    if (itemFilter.test(itemStack)) continue;
                    return false;
                }
                return true;
            };
        };
    }

    public static ItemFilter not(ItemFilter itemFilter) {
        return itemFilter.negate();
    }

    public static ItemFilter or(ItemFilter ... itemFilters) {
        Objects.requireNonNull(itemFilters);
        return switch (itemFilters.length) {
            case 0 -> ALWAYS_FALSE;
            case 1 -> itemFilters[0];
            case 2 -> itemFilters[0].or(itemFilters[1]);
            default -> itemStack -> {
                for (ItemFilter itemFilter : itemFilters) {
                    if (!itemFilter.test(itemStack)) continue;
                    return true;
                }
                return false;
            };
        };
    }

    public static ItemFilter custom(Predicate<ItemStack> predicate) {
        return predicate::test;
    }

    @Override
    public boolean test(ItemStack var1);

    default public ItemFilter and(ItemFilter other) {
        Objects.requireNonNull(other);
        return itemStack -> this.test(itemStack) && other.test(itemStack);
    }

    default public ItemFilter negate() {
        return itemS -> !this.test(itemS);
    }

    default public ItemFilter or(ItemFilter other) {
        Objects.requireNonNull(other);
        return itemStack -> this.test(itemStack) || other.test(itemStack);
    }
}

