/*
 * Decompiled with CFR 0.152.
 */
package com.cak.pattern_schematics.packet.forge;

import com.cak.pattern_schematics.foundation.util.Vec3iUtils;
import com.cak.pattern_schematics.registry.PatternSchematicsRegistry;
import com.simibubi.create.content.schematics.SchematicInstances;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraftforge.network.NetworkEvent;

public class PatternSchematicSyncPacket
extends SimplePacketBase {
    public int slot;
    public boolean deployed;
    public BlockPos anchor;
    public Rotation rotation;
    public Mirror mirror;
    public Vec3i cloneScaleMin;
    public Vec3i cloneScaleMax;
    public Vec3i cloneOffset;

    public PatternSchematicSyncPacket(int slot, StructurePlaceSettings settings, BlockPos anchor, boolean deployed, Vec3i cloneScaleMin, Vec3i cloneScaleMax, Vec3i cloneOffset) {
        this.slot = slot;
        this.deployed = deployed;
        this.anchor = anchor;
        this.rotation = settings.m_74404_();
        this.mirror = settings.m_74401_();
        this.cloneScaleMin = cloneScaleMin;
        this.cloneScaleMax = cloneScaleMax;
        this.cloneOffset = cloneOffset;
    }

    public PatternSchematicSyncPacket(FriendlyByteBuf buffer) {
        this.slot = buffer.m_130242_();
        this.deployed = buffer.readBoolean();
        this.anchor = buffer.m_130135_();
        this.rotation = (Rotation)buffer.m_130066_(Rotation.class);
        this.mirror = (Mirror)buffer.m_130066_(Mirror.class);
        this.cloneScaleMin = Vec3iUtils.unpackVec3i(buffer);
        this.cloneScaleMax = Vec3iUtils.unpackVec3i(buffer);
        this.cloneOffset = Vec3iUtils.unpackVec3i(buffer);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.slot);
        buffer.writeBoolean(this.deployed);
        buffer.m_130064_(this.anchor);
        buffer.m_130068_((Enum)this.rotation);
        buffer.m_130068_((Enum)this.mirror);
        Vec3iUtils.packVec3i(this.cloneScaleMin, buffer);
        Vec3iUtils.packVec3i(this.cloneScaleMax, buffer);
        Vec3iUtils.packVec3i(this.cloneOffset, buffer);
    }

    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            ItemStack stack = ItemStack.f_41583_;
            stack = this.slot == -1 ? player.m_21205_() : player.m_150109_().m_8020_(this.slot);
            if (!PatternSchematicsRegistry.PATTERN_SCHEMATIC.isIn(stack)) {
                return;
            }
            CompoundTag tag = stack.m_41784_();
            tag.m_128379_("Deployed", this.deployed);
            tag.m_128365_("Anchor", (Tag)NbtUtils.m_129224_((BlockPos)this.anchor));
            tag.m_128359_("Rotation", this.rotation.name());
            tag.m_128359_("Mirror", this.mirror.name());
            Vec3iUtils.putVec3i("CloneScaleMin", this.cloneScaleMin, tag);
            Vec3iUtils.putVec3i("CloneScaleMax", this.cloneScaleMax, tag);
            Vec3iUtils.putVec3i("CloneOffset", this.cloneOffset, tag);
            SchematicInstances.clearHash((ItemStack)stack);
        });
        return true;
    }
}

