/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.general;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.InactiveProfiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import snownee.jade.addon.JadeAddons;
import snownee.jade.addon.JadeAddonsBase;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.ITooltip;
import snownee.jade.api.callback.JadeRayTraceCallback;
import snownee.jade.api.callback.JadeTooltipCollectedCallback;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.util.JsonConfig;

public class TargetModifierLoader
extends SimpleJsonResourceReloadListener
implements JadeRayTraceCallback,
JadeTooltipCollectedCallback {
    protected final ListMultimap<Object, ResourceLocation> tagsToRemove = ArrayListMultimap.create();
    protected final Map<Object, Block> replacementBlocks = Maps.newHashMap();

    public TargetModifierLoader() {
        super(JsonConfig.GSON, "jade/target_modifier");
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        this.tagsToRemove.clear();
        this.replacementBlocks.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            ResourceLocation id = entry.getKey();
            try {
                JsonObject jsonObject = entry.getValue().getAsJsonObject();
                String type = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"type");
                List<?> targets = TargetModifierLoader.parseTargets(GsonHelper.m_13930_((JsonObject)jsonObject, (String)"target"));
                if ("remove_elements".equals(type)) {
                    JsonElement tagElement = GsonHelper.m_289747_((JsonObject)jsonObject, (String)"tag");
                    List<ResourceLocation> tags = tagElement.isJsonArray() ? tagElement.getAsJsonArray().asList().stream().map(JsonElement::getAsString).map(ResourceLocation::new).toList() : List.of(new ResourceLocation(tagElement.getAsString()));
                    for (Object target : targets) {
                        this.tagsToRemove.putAll(target, tags);
                    }
                    continue;
                }
                if ("replace".equals(type)) {
                    JsonObject with = GsonHelper.m_13930_((JsonObject)jsonObject, (String)"with");
                    Block block = TargetModifierLoader.parseBlocks(with).get(0);
                    for (Object target : targets) {
                        this.replacementBlocks.put(target, block);
                    }
                    continue;
                }
                throw new IllegalArgumentException("Unknown type: " + type);
            }
            catch (Exception e) {
                if (!IWailaConfig.get().getGeneral().isDebug()) continue;
                JadeAddons.LOGGER.error("Failed to load target modifier {}", (Object)id, (Object)e);
            }
        }
    }

    private static List<?> parseTargets(JsonObject jsonObject) {
        if (jsonObject.has("block") && jsonObject.has("entity")) {
            throw new IllegalArgumentException("Cannot have both block and entity");
        }
        if (jsonObject.has("block")) {
            return TargetModifierLoader.parseBlocks(jsonObject);
        }
        if (jsonObject.has("entity")) {
            return TargetModifierLoader.parseEntities(jsonObject);
        }
        throw new IllegalArgumentException("Must have either block or entity");
    }

    private static List<? extends EntityType<?>> parseEntities(JsonObject jsonObject) {
        String entityId = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"entity");
        if (entityId.startsWith("#")) {
            List<EntityType> list = Streams.stream((Iterable)BuiltInRegistries.f_256780_.m_206058_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation(entityId.substring(1))))).map(Holder::m_203334_).toList();
            Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0, (Object)("No entity type found for tag: " + entityId));
            return list;
        }
        List list = BuiltInRegistries.f_256780_.m_6612_(new ResourceLocation(entityId)).map(List::of).orElse(List.of());
        Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0, (Object)("No entity type found for id: " + entityId));
        return list;
    }

    private static List<Block> parseBlocks(JsonObject jsonObject) {
        String blockId = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"block");
        if (blockId.startsWith("#")) {
            List<Block> blocks = Streams.stream((Iterable)BuiltInRegistries.f_256975_.m_206058_(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(blockId.substring(1))))).map(Holder::m_203334_).toList();
            Preconditions.checkArgument((!blocks.isEmpty() ? 1 : 0) != 0, (Object)("No block found for tag: " + blockId));
            return blocks;
        }
        List<Block> list = BuiltInRegistries.f_256975_.m_6612_(new ResourceLocation(blockId)).map(List::of).orElse(List.of());
        Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0, (Object)("No block found for id: " + blockId));
        return list;
    }

    public void reload() {
        Minecraft mc = Minecraft.m_91087_();
        Map map = this.m_5944_(mc.m_91098_(), (ProfilerFiller)InactiveProfiler.f_18554_);
        this.apply(map, mc.m_91098_(), (ProfilerFiller)InactiveProfiler.f_18554_);
    }

    @Nullable
    public Accessor<?> onRayTrace(HitResult hitResult, @Nullable Accessor<?> accessor, @Nullable Accessor<?> originalAccessor) {
        Object identifier = TargetModifierLoader.getTargetIdentifier(accessor);
        if (identifier == null) {
            return accessor;
        }
        Block replacement = this.replacementBlocks.get(identifier);
        if (replacement == null) {
            return accessor;
        }
        if (replacement == Blocks.f_50016_) {
            return null;
        }
        if (accessor == null || accessor.getPlayer().m_7500_()) {
            return accessor;
        }
        if (JadeAddonsBase.client.maybeLowVisionUser() || !IWailaConfig.get().getGeneral().getBuiltinCamouflage()) {
            return accessor;
        }
        if (accessor instanceof BlockAccessor) {
            BlockAccessor blockAccessor = (BlockAccessor)accessor;
            return JadeAddonsBase.client.blockAccessor().from(blockAccessor).blockState(replacement.m_49966_()).build();
        }
        if (accessor instanceof EntityAccessor) {
            BlockHitResult blockHitResult = new BlockHitResult(hitResult.m_82450_(), accessor.getPlayer().m_6350_().m_122424_(), BlockPos.m_274446_((Position)hitResult.m_82450_()), false);
            return JadeAddonsBase.client.blockAccessor().hit(blockHitResult).player(accessor.getPlayer()).blockState(replacement.m_49966_()).build();
        }
        return accessor;
    }

    public void onTooltipCollected(ITooltip tooltip, Accessor<?> accessor) {
        Object identifier = TargetModifierLoader.getTargetIdentifier(accessor);
        if (identifier == null) {
            return;
        }
        for (ResourceLocation tag : this.tagsToRemove.get(identifier)) {
            tooltip.remove(tag);
        }
    }

    @Nullable
    public static Object getTargetIdentifier(@Nullable Accessor<?> accessor) {
        if (accessor instanceof BlockAccessor) {
            BlockAccessor blockAccessor = (BlockAccessor)accessor;
            return blockAccessor.getBlock();
        }
        if (accessor instanceof EntityAccessor) {
            EntityAccessor entityAccessor = (EntityAccessor)accessor;
            return entityAccessor.getEntity().m_6095_();
        }
        return null;
    }
}

