/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.deep_resonance;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import mcjty.deepresonance.modules.core.block.ResonatingCrystalTileEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import snownee.jade.addon.deep_resonance.DeepResonancePlugin;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public enum CrystalProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    @OnlyIn(value=Dist.CLIENT)
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (!accessor.getServerData().m_128441_("DeepResonance")) {
            return;
        }
        CompoundTag tag = accessor.getServerData().m_128469_("DeepResonance");
        double strength = tag.m_128459_("Strength");
        double efficiency = tag.m_128459_("Efficiency");
        double purity = tag.m_128459_("Purity");
        int rfpertick = tag.m_128451_("RfPerTick");
        double power = tag.m_128459_("Power");
        DecimalFormat decimalFormat = new DecimalFormat("#.#");
        decimalFormat.setRoundingMode(RoundingMode.DOWN);
        tooltip.add((Component)Component.m_237110_((String)"jadeaddons.deepresonance.sep", (Object[])new Object[]{decimalFormat.format(strength), decimalFormat.format(efficiency), decimalFormat.format(purity)}));
        tooltip.add((Component)Component.m_237110_((String)"jadeaddons.deepresonance.crystalPower", (Object[])new Object[]{decimalFormat.format(power), rfpertick}));
    }

    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof ResonatingCrystalTileEntity) {
            ResonatingCrystalTileEntity crystal = (ResonatingCrystalTileEntity)blockEntity;
            CompoundTag tag = new CompoundTag();
            tag.m_128347_("Strength", crystal.getStrength());
            tag.m_128347_("Efficiency", crystal.getEfficiency());
            tag.m_128347_("Purity", crystal.getPurity());
            tag.m_128405_("RfPerTick", crystal.getRfPerTick());
            tag.m_128347_("Power", crystal.getPower());
            data.m_128365_("DeepResonance", (Tag)tag);
        }
    }

    public ResourceLocation getUid() {
        return DeepResonancePlugin.CRYSTAL;
    }
}

