/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.potion;

import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.AABB;

public class RageEffect
extends MobEffect {
    private static final UUID RAGE_ATTACK_DAMAGE_UUID = UUID.fromString("1eaf83ff-7207-4596-b37a-d7a07b3ec4ff");

    protected RageEffect() {
        super(MobEffectCategory.NEUTRAL, 12201518);
    }

    public void m_6742_(LivingEntity entity, int level) {
        Mob mob;
        AttributeInstance attributeinstance = entity.m_21051_(Attributes.f_22281_);
        if (attributeinstance != null) {
            float levelScale = (float)(1 + level) * 2.5f;
            float f = (1.0f - entity.m_21223_() / entity.m_21233_()) * levelScale;
            this.removeRageModifier(entity);
            attributeinstance.m_22118_(new AttributeModifier(RAGE_ATTACK_DAMAGE_UUID, "Rage attack boost", (double)f, AttributeModifier.Operation.ADDITION));
        }
        if (!entity.m_9236_().f_46443_ && entity instanceof Mob && (mob = (Mob)entity).m_5448_() == null && entity.f_19797_ % 10 == 0 && entity.m_217043_().m_188503_(2) == 0) {
            AABB aabb = mob.m_20191_().m_82400_(80.0);
            LivingEntity randomTarget = null;
            for (LivingEntity living : mob.m_9236_().m_6443_(LivingEntity.class, aabb, EntitySelector.f_20403_)) {
                if (randomTarget != null && (!(randomTarget.m_20270_((Entity)mob) > living.m_20270_((Entity)mob)) || mob.m_217043_().m_188503_(2) != 0) || mob.m_7306_((Entity)living) || mob.m_7307_((Entity)living) || living.m_7307_((Entity)mob) || !mob.m_6779_(living)) continue;
                randomTarget = living;
            }
            if (randomTarget != null && !randomTarget.m_7306_((Entity)mob)) {
                mob.m_6703_(randomTarget);
                mob.m_6710_(randomTarget);
                for (int i = 0; i < 3 + mob.m_217043_().m_188503_(3); ++i) {
                    ((ServerLevel)entity.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123792_, mob.m_20208_(0.5), mob.m_20188_() + (double)(mob.m_217043_().m_188501_() * 0.2f), mob.m_20262_(0.5), 0, 0.0, 0.0, 0.0, 1.0);
                }
            }
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return duration > 0;
    }

    protected void removeRageModifier(LivingEntity living) {
        AttributeInstance attributeinstance = living.m_21051_(Attributes.f_22281_);
        if (attributeinstance != null && attributeinstance.m_22111_(RAGE_ATTACK_DAMAGE_UUID) != null) {
            attributeinstance.m_22120_(RAGE_ATTACK_DAMAGE_UUID);
        }
    }

    public void m_6385_(LivingEntity entity, AttributeMap map, int i) {
        super.m_6385_(entity, map, i);
    }

    public void m_6386_(LivingEntity entity, AttributeMap map, int i) {
        super.m_6386_(entity, map, i);
        this.removeRageModifier(entity);
    }
}

