/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.structure.piece;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.level.structure.piece.ACStructurePieceRegistry;
import com.github.alexmodguy.alexscaves.server.level.structure.piece.CakeCaveStructurePiece;
import com.github.alexmodguy.alexscaves.server.level.structure.piece.UndergroundTemplateStructurePiece;
import com.github.alexmodguy.alexscaves.server.misc.ACLootTableRegistry;
import com.google.common.collect.Sets;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class LicowitchTowerStructurePiece
extends UndergroundTemplateStructurePiece {
    public LicowitchTowerStructurePiece(StructureTemplateManager manager, ResourceLocation resourceLocation, BlockPos pos, Rotation rotation) {
        super((StructurePieceType)ACStructurePieceRegistry.LICOWITCH_TOWER.get(), 0, manager, resourceLocation, resourceLocation.toString(), LicowitchTowerStructurePiece.makeSettings(rotation), pos);
    }

    public LicowitchTowerStructurePiece(StructureTemplateManager manager, CompoundTag tag) {
        super((StructurePieceType)ACStructurePieceRegistry.LICOWITCH_TOWER.get(), tag, manager, (ResourceLocation x) -> LicowitchTowerStructurePiece.makeSettings(Rotation.valueOf((String)tag.m_128461_("Rotation"))));
    }

    public LicowitchTowerStructurePiece(StructurePieceSerializationContext context, CompoundTag tag) {
        this(context.f_226956_(), tag);
    }

    private static StructurePlaceSettings makeSettings(Rotation rotation) {
        return new StructurePlaceSettings().m_74379_(rotation).m_74392_(true).m_163782_(false);
    }

    @Override
    protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tag) {
        super.m_183620_(context, tag);
        tag.m_128359_("Rotation", this.f_73657_.m_74404_().name());
    }

    @Override
    public int minimumDepthBeneathSurface() {
        return 35;
    }

    protected void m_213704_(String string, BlockPos pos, ServerLevelAccessor accessor, RandomSource random, BoundingBox box) {
        if (string.equals("loot_chest")) {
            RandomizableContainerBlockEntity.m_222766_((BlockGetter)accessor, (RandomSource)random, (BlockPos)pos.m_7495_(), (ResourceLocation)ACLootTableRegistry.LICOWITCH_TOWER_CHEST);
        } else if (string.equals("secret_loot_chest")) {
            RandomizableContainerBlockEntity.m_222766_((BlockGetter)accessor, (RandomSource)random, (BlockPos)pos.m_7495_(), (ResourceLocation)ACLootTableRegistry.SECRET_LICOWITCH_TOWER_CHEST);
        }
        accessor.m_7731_(pos, Blocks.f_50627_.m_49966_(), 0);
    }

    @Override
    public void m_213694_(WorldGenLevel level, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource randomSource, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos structurePos) {
        super.m_213694_(level, structureManager, chunkGenerator, randomSource, boundingBox, chunkPos, structurePos);
        BoundingBox box = new BoundingBox(this.f_73383_.m_162395_(), this.f_73383_.m_162396_(), this.f_73383_.m_162398_(), this.f_73383_.m_162399_(), this.f_73383_.m_162396_() + 1, this.f_73383_.m_162401_());
        HashSet supportsNeededBelow = Sets.newHashSet();
        BlockPos.m_121919_((BoundingBox)box).forEach(pos -> {
            if (!(level.m_8055_(pos).m_60795_() || level.m_6425_(pos.m_7495_()).m_76178_() && level.m_8055_(pos.m_7495_()).m_60838_((BlockGetter)level, pos.m_7495_()))) {
                supportsNeededBelow.add(pos.m_7949_());
            }
        });
        BlockPos.MutableBlockPos grounded = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos groundedInBox = new BlockPos.MutableBlockPos();
        for (BlockPos pos2 : supportsNeededBelow) {
            grounded.m_122178_(pos2.m_123341_(), pos2.m_123342_() - 1, pos2.m_123343_());
            groundedInBox.m_122178_(pos2.m_123341_(), boundingBox.m_162396_() + 1, pos2.m_123343_());
            if (!boundingBox.m_71051_((Vec3i)groundedInBox)) continue;
            int maxYDown = 3 + randomSource.m_188503_(3);
            for (int yDown = 0; !(level.m_8055_((BlockPos)grounded).m_60819_().m_76178_() && level.m_8055_((BlockPos)grounded).m_60838_((BlockGetter)level, (BlockPos)grounded) || grounded.m_123342_() <= level.m_141937_() || yDown >= maxYDown); ++yDown) {
                level.m_7731_((BlockPos)grounded, (float)yDown < (float)maxYDown * 0.4f ? ((Block)ACBlockRegistry.BLOCK_OF_CHOCOLATE.get()).m_49966_() : ((Block)ACBlockRegistry.CAKE_LAYER.get()).m_49966_(), 3);
                grounded.m_122184_(0, -1, 0);
            }
        }
    }

    @Override
    public boolean placeInHighestCave() {
        return true;
    }

    @Override
    public boolean discardIfNotOnGround() {
        return true;
    }

    @Override
    public boolean sinkByEdges() {
        return false;
    }

    @Override
    protected BlockPos getCaveHeight(BlockPos currentStructureCenter, WorldGenLevel level, RandomSource randomSource) {
        return currentStructureCenter.m_175288_((int)CakeCaveStructurePiece.calculatePlateauHeight(currentStructureCenter.m_123341_(), currentStructureCenter.m_123343_(), 7, true));
    }
}

