/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.item;

import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACAdvancementTriggerRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.world.ForgeChunkManager;

public class RemoteDetonatorItem
extends Item {
    public RemoteDetonatorItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public static boolean isActive(ItemStack itemStack) {
        CompoundTag compoundtag = itemStack.m_41783_();
        return compoundtag != null && (compoundtag.m_128441_("BombDimension") || compoundtag.m_128441_("BombPos"));
    }

    private static Optional<ResourceKey<Level>> getBombDimension(CompoundTag tag) {
        return Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("BombDimension")).result();
    }

    @Nullable
    public static GlobalPos getBombPosition(CompoundTag tag) {
        Optional<ResourceKey<Level>> optional;
        boolean flag = tag.m_128441_("BombPos");
        boolean flag1 = tag.m_128441_("BombDimension");
        if (flag && flag1 && (optional = RemoteDetonatorItem.getBombDimension(tag)).isPresent()) {
            BlockPos blockpos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("BombPos"));
            return GlobalPos.m_122643_(optional.get(), (BlockPos)blockpos);
        }
        return null;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (RemoteDetonatorItem.isActive(itemstack)) {
            ServerLevel serverLevel;
            ServerLevel dimensionLevel;
            CompoundTag tag = itemstack.m_41784_();
            GlobalPos globalPos = RemoteDetonatorItem.getBombPosition(tag);
            if (globalPos != null && globalPos.m_122640_() != null && !level.f_46443_ && level instanceof ServerLevel && (dimensionLevel = (serverLevel = (ServerLevel)level).m_7654_().m_129880_(globalPos.m_122640_())) != null) {
                RemoteDetonatorItem.loadChunksAround(dimensionLevel, player.m_20148_(), globalPos.m_122646_(), true);
                BlockState blockState = dimensionLevel.m_8055_(globalPos.m_122646_());
                if (blockState.m_204336_(ACTagRegistry.REMOTE_DETONATOR_ACTIVATES)) {
                    blockState.onCaughtFire((Level)dimensionLevel, globalPos.m_122646_(), Direction.UP, (LivingEntity)player);
                    if (player.m_20238_(globalPos.m_122646_().m_252807_()) > 1000.0) {
                        ACAdvancementTriggerRegistry.REMOTE_DETONATION.triggerForEntity((Entity)player);
                    }
                    tag.m_128473_("BombDimension");
                    tag.m_128473_("BombPos");
                    itemstack.m_41751_(tag);
                    level.m_46597_(globalPos.m_122646_(), Blocks.f_50016_.m_49966_());
                }
            }
            return InteractionResultHolder.m_19090_((Object)itemstack);
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    private static void loadChunksAround(ServerLevel serverLevel, UUID ticket, BlockPos center, boolean load) {
        ChunkPos chunkPos = new ChunkPos(center);
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                ForgeChunkManager.forceChunk((ServerLevel)serverLevel, (String)"alexscaves", (UUID)ticket, (int)(chunkPos.f_45578_ + i), (int)(chunkPos.f_45579_ + j), (boolean)load, (boolean)true);
            }
        }
    }

    public void m_6883_(ItemStack itemStack, Level level, Entity entity, int i, boolean b) {
        if (!level.f_46443_ && RemoteDetonatorItem.isActive(itemStack)) {
            CompoundTag compoundtag = itemStack.m_41784_();
            if (compoundtag.m_128441_("BombTracked") && !compoundtag.m_128471_("BombTracked")) {
                return;
            }
            Optional<ResourceKey<Level>> optional = RemoteDetonatorItem.getBombDimension(compoundtag);
            if (optional.isPresent() && optional.get() == level.m_46472_() && compoundtag.m_128441_("BombPos")) {
                BlockPos blockpos = NbtUtils.m_129239_((CompoundTag)compoundtag.m_128469_("BombPos"));
                boolean flag = false;
                if ((entity.f_19797_ + entity.m_19879_()) % 20 == 0 && level.m_46749_(blockpos) && !level.m_8055_(blockpos).m_204336_(ACTagRegistry.REMOTE_DETONATOR_ACTIVATES)) {
                    flag = true;
                }
                if (!level.m_46739_(blockpos) || flag) {
                    compoundtag.m_128473_("BombPos");
                    compoundtag.m_128473_("BombDimension");
                }
            }
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        boolean flag;
        BlockPos blockpos = context.m_8083_();
        Level level = context.m_43725_();
        if (!level.m_8055_(blockpos).m_204336_(ACTagRegistry.REMOTE_DETONATOR_ACTIVATES)) {
            return super.m_6225_(context);
        }
        level.m_5594_((Player)null, blockpos, SoundEvents.f_12107_, SoundSource.PLAYERS, 1.0f, 1.0f);
        Player player = context.m_43723_();
        ItemStack itemstack = context.m_43722_();
        boolean bl = flag = !player.m_150110_().f_35937_ && itemstack.m_41613_() == 1;
        if (flag) {
            this.addBombTags((ResourceKey<Level>)level.m_46472_(), blockpos, itemstack.m_41784_());
        } else {
            ItemStack itemstack1 = new ItemStack((ItemLike)ACItemRegistry.REMOTE_DETONATOR.get(), 1);
            CompoundTag compoundtag = itemstack.m_41782_() ? itemstack.m_41783_().m_6426_() : new CompoundTag();
            itemstack1.m_41751_(compoundtag);
            itemstack.m_41774_(1);
            this.addBombTags((ResourceKey<Level>)level.m_46472_(), blockpos, compoundtag);
            if (!player.m_150109_().m_36054_(itemstack1)) {
                player.m_36176_(itemstack1, false);
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private void addBombTags(ResourceKey<Level> levelResourceKey, BlockPos blockPos, CompoundTag tag) {
        tag.m_128365_("BombPos", (Tag)NbtUtils.m_129224_((BlockPos)blockPos));
        Level.f_46427_.encodeStart((DynamicOps)NbtOps.f_128958_, levelResourceKey).result().ifPresent(p_40731_ -> tag.m_128365_("BombDimension", p_40731_));
        tag.m_128379_("BombTracked", true);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("BombPos")) {
            Optional<ResourceKey<Level>> optional = RemoteDetonatorItem.getBombDimension(stack.m_41783_());
            BlockPos blockpos = NbtUtils.m_129239_((CompoundTag)stack.m_41783_().m_128469_("BombPos"));
            if (optional.isPresent() && blockpos != null) {
                MutableComponent untranslated = Component.m_237110_((String)"item.alexscaves.remote_detonator.desc", (Object[])new Object[]{blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_()}).m_130940_(ChatFormatting.GRAY);
                tooltip.add((Component)untranslated);
            }
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }
}

