/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.item;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.blockentity.BeholderBlockEntity;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.world.ForgeChunkManager;

public class OccultGemItem
extends Item {
    public OccultGemItem() {
        super(new Item.Properties());
    }

    public static boolean isActive(ItemStack itemStack) {
        CompoundTag compoundtag = itemStack.m_41783_();
        return compoundtag != null && (compoundtag.m_128441_("BeholderDimension") || compoundtag.m_128441_("BeholderPos"));
    }

    private static Optional<ResourceKey<Level>> getBeholderDimension(CompoundTag tag) {
        return Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("BeholderDimension")).result();
    }

    @Nullable
    public static GlobalPos getBeholderPosition(CompoundTag tag) {
        Optional<ResourceKey<Level>> optional;
        boolean flag = tag.m_128441_("BeholderPos");
        boolean flag1 = tag.m_128441_("BeholderDimension");
        if (flag && flag1 && (optional = OccultGemItem.getBeholderDimension(tag)).isPresent()) {
            BlockPos blockpos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("BeholderPos"));
            return GlobalPos.m_122643_(optional.get(), (BlockPos)blockpos);
        }
        return null;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (OccultGemItem.isActive(itemstack)) {
            ServerLevel serverLevel;
            ServerLevel dimensionLevel;
            CompoundTag tag = itemstack.m_41784_();
            GlobalPos globalPos = OccultGemItem.getBeholderPosition(tag);
            if (globalPos != null && globalPos.m_122640_() != null && globalPos.m_122640_().equals((Object)level.m_46472_()) && !level.f_46443_ && level instanceof ServerLevel && (dimensionLevel = (serverLevel = (ServerLevel)level).m_7654_().m_129880_(globalPos.m_122640_())) != null) {
                BlockEntity blockEntity;
                OccultGemItem.loadChunksAround(dimensionLevel, player.m_20148_(), globalPos.m_122646_(), true);
                BlockState blockState = dimensionLevel.m_8055_(globalPos.m_122646_());
                if (blockState.m_60713_((Block)ACBlockRegistry.BEHOLDER.get()) && (blockEntity = dimensionLevel.m_7702_(globalPos.m_122646_())) instanceof BeholderBlockEntity) {
                    BeholderBlockEntity blockEntity2 = (BeholderBlockEntity)blockEntity;
                    blockEntity2.startObserving((Level)dimensionLevel, player);
                }
            }
            return InteractionResultHolder.m_19090_((Object)itemstack);
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    private static void loadChunksAround(ServerLevel serverLevel, UUID ticket, BlockPos center, boolean load) {
        ChunkPos chunkPos = new ChunkPos(center);
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                ForgeChunkManager.forceChunk((ServerLevel)serverLevel, (String)"alexscaves", (UUID)ticket, (int)(chunkPos.f_45578_ + i), (int)(chunkPos.f_45579_ + j), (boolean)load, (boolean)true);
            }
        }
    }

    public void m_6883_(ItemStack itemStack, Level level, Entity entity, int i, boolean b) {
        if (!level.f_46443_ && OccultGemItem.isActive(itemStack)) {
            CompoundTag compoundtag = itemStack.m_41784_();
            if (compoundtag.m_128441_("BeholderTracked") && !compoundtag.m_128471_("BeholderTracked")) {
                return;
            }
            Optional<ResourceKey<Level>> optional = OccultGemItem.getBeholderDimension(compoundtag);
            if (optional.isPresent() && optional.get() == level.m_46472_() && compoundtag.m_128441_("BeholderPos")) {
                BlockPos blockpos = NbtUtils.m_129239_((CompoundTag)compoundtag.m_128469_("BeholderPos"));
                boolean flag = false;
                if ((entity.f_19797_ + entity.m_19879_()) % 20 == 0 && level.m_46749_(blockpos) && !level.m_8055_(blockpos).m_60713_((Block)ACBlockRegistry.BEHOLDER.get())) {
                    flag = true;
                }
                if (!level.m_46739_(blockpos) || flag) {
                    compoundtag.m_128473_("BeholderPos");
                    compoundtag.m_128473_("BeholderDimension");
                }
            }
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        boolean flag;
        BlockPos blockpos = context.m_8083_();
        Level level = context.m_43725_();
        if (!level.m_8055_(blockpos).m_60713_((Block)ACBlockRegistry.BEHOLDER.get())) {
            return super.m_6225_(context);
        }
        level.m_5594_((Player)null, blockpos, SoundEvents.f_12107_, SoundSource.PLAYERS, 1.0f, 1.0f);
        Player player = context.m_43723_();
        ItemStack itemstack = context.m_43722_();
        boolean bl = flag = !player.m_150110_().f_35937_ && itemstack.m_41613_() == 1;
        if (flag) {
            this.addBeholderTags((ResourceKey<Level>)level.m_46472_(), blockpos, itemstack.m_41784_());
        } else {
            ItemStack itemstack1 = new ItemStack((ItemLike)ACItemRegistry.OCCULT_GEM.get(), 1);
            CompoundTag compoundtag = itemstack.m_41782_() ? itemstack.m_41783_().m_6426_() : new CompoundTag();
            itemstack1.m_41751_(compoundtag);
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            this.addBeholderTags((ResourceKey<Level>)level.m_46472_(), blockpos, compoundtag);
            if (!player.m_150109_().m_36054_(itemstack1)) {
                player.m_36176_(itemstack1, false);
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private void addBeholderTags(ResourceKey<Level> levelResourceKey, BlockPos blockPos, CompoundTag tag) {
        tag.m_128365_("BeholderPos", (Tag)NbtUtils.m_129224_((BlockPos)blockPos));
        Level.f_46427_.encodeStart((DynamicOps)NbtOps.f_128958_, levelResourceKey).result().ifPresent(p_40731_ -> tag.m_128365_("BeholderDimension", p_40731_));
        tag.m_128379_("BeholderTracked", true);
    }

    public boolean m_5812_(ItemStack stack) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("BeholderPos")) {
            Optional<ResourceKey<Level>> optional = OccultGemItem.getBeholderDimension(stack.m_41783_());
            BlockPos blockpos = NbtUtils.m_129239_((CompoundTag)stack.m_41783_().m_128469_("BeholderPos"));
            return optional.isPresent() && blockpos != null;
        }
        return super.m_5812_(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("BeholderPos")) {
            Optional<ResourceKey<Level>> optional = OccultGemItem.getBeholderDimension(stack.m_41783_());
            BlockPos blockpos = NbtUtils.m_129239_((CompoundTag)stack.m_41783_().m_128469_("BeholderPos"));
            if (optional.isPresent() && blockpos != null) {
                MutableComponent untranslated = Component.m_237110_((String)"item.alexscaves.occult_gem.desc", (Object[])new Object[]{blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_()}).m_130940_(ChatFormatting.GRAY);
                tooltip.add((Component)untranslated);
            }
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }
}

