/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityDataRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ai.LicowitchAttackGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.LicowitchUseCrucibleGoal;
import com.github.alexmodguy.alexscaves.server.entity.living.TremorzillaEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.PossessedByLicowitch;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.level.structure.ACStructureRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.potion.ACEffectRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;

public class LicowitchEntity
extends Monster
implements IAnimatedEntity {
    private static final EntityDataAccessor<Boolean> CROSSED_ARMS = SynchedEntityData.m_135353_(LicowitchEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<UUID>> POSSESSED_UUID_0 = SynchedEntityData.m_135353_(LicowitchEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> POSSESSED_UUID_1 = SynchedEntityData.m_135353_(LicowitchEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> POSSESSED_UUID_2 = SynchedEntityData.m_135353_(LicowitchEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<BlockPos>> CRUCIBLE_POS = SynchedEntityData.m_135353_(LicowitchEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static EntityDataAccessor<Optional<Vec3>> TELEPORTING_TO_POS = SynchedEntityData.m_135353_(TremorzillaEntity.class, (EntityDataSerializer)((EntityDataSerializer)ACEntityDataRegistry.OPTIONAL_VEC_3.get()));
    public static final Animation ANIMATION_SWING_LEFT = Animation.create((int)20);
    public static final Animation ANIMATION_SWING_RIGHT = Animation.create((int)20);
    public static final Animation ANIMATION_EAT = Animation.create((int)100);
    public static final Animation ANIMATION_SPELL_0 = Animation.create((int)45);
    public static final Animation ANIMATION_SPELL_1 = Animation.create((int)50);
    private Animation currentAnimation;
    private int animationTick;
    private float prevUncrossedArmsProgress;
    private float uncrossedArmsProgress;
    private float prevTeleportingProgress;
    private float teleportingProgress;
    public boolean updateHeldItems = true;
    public boolean updateFoldedArms = true;
    private int eatCooldown = 0;
    private int teleportCooldown = 0;
    public static ItemStack hungerPotion = ACEffectRegistry.createSplashPotion((Potion)ACEffectRegistry.STRONG_HUNGER_POTION.get());

    public LicowitchEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new MoveHelper();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22277_, 48.0);
    }

    public static boolean checkLicowitchSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        if (LicowitchEntity.isWithinTowerSpawnBounds(levelAccessor, blockPos)) {
            return LicowitchEntity.m_219019_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource) && randomSource.m_188503_(2) == 0 && LicowitchEntity.getWitchCountInStructure(levelAccessor, blockPos, true) < 4;
        }
        return LicowitchEntity.m_219013_(entityType, (ServerLevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource) && randomSource.m_188503_(2) == 0;
    }

    public static boolean isWithinTowerSpawnBounds(ServerLevelAccessor level, BlockPos pos) {
        Structure structure = (Structure)level.m_9598_().m_175515_(Registries.f_256944_).m_7745_(ACStructureRegistry.LICOWITCH_TOWER.getId());
        StructureStart structureStart = level.m_6018_().m_215010_().m_220494_(pos, structure);
        if (structure != null && structureStart.m_73603_()) {
            return pos.m_123342_() < structureStart.m_73601_().m_162400_() - 9 && pos.m_123342_() > structureStart.m_73601_().m_162396_() + 2;
        }
        return false;
    }

    public static int getWitchCountInStructure(ServerLevelAccessor level, BlockPos pos, boolean licowitches) {
        AABB aabb = new AABB(pos).m_82400_(32.0);
        if (licowitches) {
            return level.m_45976_(LicowitchEntity.class, aabb).size();
        }
        return level.m_45976_(Witch.class, aabb).size();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LicowitchAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new LicowitchUseCrucibleGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new RandomlyTeleportGoal());
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 45));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{LicowitchEntity.class, Witch.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Husk.class, true, false));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CROSSED_ARMS, (Object)true);
        this.f_19804_.m_135372_(POSSESSED_UUID_0, Optional.empty());
        this.f_19804_.m_135372_(POSSESSED_UUID_1, Optional.empty());
        this.f_19804_.m_135372_(POSSESSED_UUID_2, Optional.empty());
        this.f_19804_.m_135372_(CRUCIBLE_POS, Optional.empty());
        this.f_19804_.m_135372_(TELEPORTING_TO_POS, Optional.empty());
    }

    public float getArmsUncrossedProgress(float partialTicks) {
        return (this.prevUncrossedArmsProgress + (this.uncrossedArmsProgress - this.prevUncrossedArmsProgress) * partialTicks) * 0.2f;
    }

    public float getTeleportingProgress(float partialTicks) {
        return (this.prevTeleportingProgress + (this.teleportingProgress - this.prevTeleportingProgress) * partialTicks) * 0.025f;
    }

    public boolean areArmsVisuallyCrossed(float partialTicks) {
        return this.getArmsUncrossedProgress(partialTicks) <= 0.0f;
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevUncrossedArmsProgress = this.uncrossedArmsProgress;
        this.prevTeleportingProgress = this.teleportingProgress;
        if (!this.areArmsCrossed() && this.uncrossedArmsProgress < 5.0f) {
            this.uncrossedArmsProgress += 1.0f;
        }
        if (this.areArmsCrossed() && this.uncrossedArmsProgress > 0.0f) {
            this.uncrossedArmsProgress -= 1.0f;
        }
        if (this.getTeleportingToPos() != null && this.teleportingProgress < 40.0f) {
            this.teleportingProgress += 1.0f;
        }
        if (this.getTeleportingToPos() == null && this.teleportingProgress > 0.0f) {
            this.teleportingProgress = Math.max(0.0f, this.teleportingProgress - 10.0f);
        }
        if (this.getAnimation() == ANIMATION_SPELL_1) {
            float f = this.getAnimationTick() < 10 ? 0.2f : (this.getAnimationTick() > 40 ? -0.2f : 0.0f);
            float backAmount = this.getAnimationTick() > 40 ? 0.0f : 0.1f;
            this.m_20256_(new Vec3(0.0, (double)f, 0.0).m_82549_(new Vec3(0.0, 0.0, (double)(-backAmount)).m_82524_((float)(-Math.toRadians(this.m_146908_())))));
            this.f_19789_ = 0.0f;
        }
        if (this.updateHeldItems && !this.m_9236_().f_46443_) {
            ItemStack main = ItemStack.f_41583_;
            ItemStack offhand = ItemStack.f_41583_;
            if (this.getAnimation() == ANIMATION_SPELL_0 || this.getAnimation() == ANIMATION_SPELL_1) {
                main = new ItemStack((ItemLike)ACItemRegistry.SUGAR_STAFF.get());
            }
            if (this.getAnimation() == ANIMATION_EAT && this.getAnimationTick() < 90) {
                main = new ItemStack((ItemLike)ACBlockRegistry.CANDY_CANE.get());
            }
            if (!main.m_41619_() || this.areArmsVisuallyCrossed(1.0f)) {
                this.m_21008_(InteractionHand.MAIN_HAND, main);
            }
            if (!offhand.m_41619_() || this.areArmsVisuallyCrossed(1.0f)) {
                this.m_21008_(InteractionHand.OFF_HAND, offhand);
            }
        }
        if (this.updateFoldedArms) {
            boolean unfold = this.teleportingProgress > 0.0f || this.getAnimation() == ANIMATION_SPELL_0 || this.getAnimation() == ANIMATION_SPELL_1 || this.getAnimation() == ANIMATION_SWING_LEFT || this.getAnimation() == ANIMATION_SWING_RIGHT;
            this.setArmsCrossed(!unfold);
        }
        if (!this.m_9236_().f_46443_) {
            List<UUID> possessedIds = this.getPossessedUUIDs();
            if (this.m_9236_() instanceof ServerLevel) {
                for (UUID possessedId : possessedIds) {
                    Entity possessedEntity = ((ServerLevel)this.m_9236_()).m_8791_(possessedId);
                    if (possessedEntity == null) continue;
                    this.tickPossessedEntity(possessedEntity);
                }
            }
            if (this.m_21223_() < this.m_21233_() && this.getAnimation() == NO_ANIMATION && this.f_19797_ % 20 == 8 && this.eatCooldown == 0) {
                this.setAnimation(ANIMATION_EAT);
                this.eatCooldown = 200;
            }
            if (this.getAnimation() == ANIMATION_EAT && this.getAnimationTick() == 90) {
                this.m_5634_(5.0f);
            }
            if (this.eatCooldown > 0) {
                --this.eatCooldown;
            }
        } else if (this.getTeleportingToPos() != null && this.getTeleportingProgress(1.0f) < 1.0f) {
            Vec3 angle = new Vec3(this.f_19796_.m_188499_() ? 0.5 : -0.5, 2.0, 0.0).m_82524_((float)(-Math.toRadians(this.f_20883_)));
            Vec3 delta = new Vec3(this.f_19796_.m_188583_() * 2.0, 4.0, this.f_19796_.m_188583_()).m_82524_((float)(-Math.toRadians(this.f_20883_))).m_82549_(this.m_20182_());
            this.m_9236_().m_7106_((ParticleOptions)ACParticleRegistry.PURPLE_WITCH_MAGIC.get(), this.m_20185_() + angle.f_82479_, this.m_20186_() + angle.f_82480_, this.m_20189_() + angle.f_82481_, delta.f_82479_, delta.f_82480_, delta.f_82481_);
        } else if (this.f_19796_.m_188501_() < 0.003f) {
            for (int i = 0; i < this.f_19796_.m_188503_(2) + 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ACParticleRegistry.WITCH_COOKIE.get(), this.m_20185_() + this.f_19796_.m_188583_() * (double)0.13f, this.m_20191_().f_82292_ + 0.5 + this.f_19796_.m_188583_() * (double)0.13f, this.m_20189_() + this.f_19796_.m_188583_() * (double)0.13f, 0.0, 0.0, 0.0);
            }
        }
        if (this.teleportingProgress >= 40.0f && this.getTeleportingToPos() != null) {
            Vec3 vec3 = this.getTeleportingToPos();
            this.m_6034_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            if (!this.m_9236_().f_46443_) {
                this.setTeleportingToPos(null);
            } else {
                for (int i = 0; i < this.f_19796_.m_188503_(8) + 8; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ACParticleRegistry.PURPLE_WITCH_EXPLOSION.get(), this.m_20185_() + this.f_19796_.m_188583_() * (double)0.3f, this.m_20186_() + this.f_19796_.m_188583_() * 1.5, this.m_20189_() + this.f_19796_.m_188583_() * (double)0.3f, 0.0, 0.0, 0.0);
                }
            }
            this.m_146867_();
            this.postTeleport();
        }
        if (this.getAnimation() == ANIMATION_EAT && this.getAnimationTick() < 90 && this.getAnimationTick() % 4 == 0) {
            this.m_21137_(this.m_21120_(InteractionHand.MAIN_HAND), 2);
        }
        if (this.teleportCooldown > 0) {
            --this.teleportCooldown;
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    private void postTeleport() {
        this.teleportCooldown = 200 + this.f_19796_.m_188503_(300);
    }

    public boolean canTeleport() {
        return this.teleportCooldown <= 0;
    }

    public boolean m_6117_() {
        return this.getAnimation() == ANIMATION_EAT && this.getAnimationTick() > 10 && this.getAnimationTick() < 90 || super.m_6117_();
    }

    private void tickPossessedEntity(Entity possessedEntity) {
        if (possessedEntity instanceof PossessedByLicowitch) {
            PossessedByLicowitch possessedByLicowitch = (PossessedByLicowitch)possessedEntity;
            possessedByLicowitch.setPossessedByLicowitchId(this.m_19879_());
        }
        if (possessedEntity instanceof Mob) {
            Mob mob = (Mob)possessedEntity;
            mob.m_6710_(this.m_5448_());
        }
        if (!possessedEntity.m_6084_() || !(possessedEntity instanceof PossessedByLicowitch)) {
            this.removePossessedUUID(possessedEntity.m_20148_());
        }
    }

    public void killAllPossessedEntities() {
        if (!this.m_9236_().f_46443_) {
            List<UUID> possessedIds = this.getPossessedUUIDs();
            if (this.m_9236_() instanceof ServerLevel) {
                for (UUID possessedId : possessedIds) {
                    Entity possessedEntity = ((ServerLevel)this.m_9236_()).m_8791_(possessedId);
                    if (possessedEntity == null) continue;
                    possessedEntity.m_6469_(this.m_269291_().m_269425_(), 300.0f);
                }
            }
        }
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        this.killAllPossessedEntities();
        super.m_142687_(removalReason);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        List<UUID> list = this.getPossessedUUIDs();
        ListTag listtag = new ListTag();
        for (UUID uuid : list) {
            if (uuid == null) continue;
            listtag.add((Object)NbtUtils.m_129226_((UUID)uuid));
        }
        compoundTag.m_128365_("Possessed", (Tag)listtag);
        BlockPos cruciblePos = this.getLastCruciblePos();
        if (cruciblePos != null) {
            compoundTag.m_128405_("CrucibleX", cruciblePos.m_123341_());
            compoundTag.m_128405_("CrucibleY", cruciblePos.m_123342_());
            compoundTag.m_128405_("CrucibleZ", cruciblePos.m_123343_());
        }
        compoundTag.m_128405_("TeleportCooldown", this.teleportCooldown);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        ListTag listtag = compoundTag.m_128437_("Possessed", 11);
        for (int i = 0; i < listtag.size(); ++i) {
            this.addPossessedUUID(NbtUtils.m_129233_((Tag)listtag.get(i)));
        }
        if (compoundTag.m_128441_("CrucibleX") && compoundTag.m_128441_("CrucibleY") && compoundTag.m_128441_("CrucibleZ")) {
            this.setLastCruciblePos(new BlockPos(compoundTag.m_128451_("CrucibleX"), compoundTag.m_128451_("CrucibleY"), compoundTag.m_128451_("CrucibleZ")));
        }
        this.teleportCooldown = compoundTag.m_128451_("TeleportCooldown");
    }

    protected float m_21519_(EquipmentSlot slot) {
        return slot.m_254934_() ? super.m_21519_(slot) : 0.0f;
    }

    protected int m_5639_(float f, float f1) {
        return super.m_5639_(f, f1) - 2;
    }

    public boolean areArmsCrossed() {
        return (Boolean)this.f_19804_.m_135370_(CROSSED_ARMS);
    }

    public void setArmsCrossed(boolean crossed) {
        this.f_19804_.m_135381_(CROSSED_ARMS, (Object)crossed);
    }

    public BlockPos getLastCruciblePos() {
        return ((Optional)this.f_19804_.m_135370_(CRUCIBLE_POS)).orElse(null);
    }

    public void setLastCruciblePos(BlockPos lastAltarPos) {
        this.f_19804_.m_135381_(CRUCIBLE_POS, Optional.ofNullable(lastAltarPos));
    }

    public Vec3 getTeleportingToPos() {
        return ((Optional)this.f_19804_.m_135370_(TELEPORTING_TO_POS)).orElse(null);
    }

    public void setTeleportingToPos(Vec3 lastAltarPos) {
        this.f_19804_.m_135381_(TELEPORTING_TO_POS, Optional.ofNullable(lastAltarPos));
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_SWING_LEFT, ANIMATION_SWING_RIGHT, ANIMATION_EAT, ANIMATION_SPELL_0, ANIMATION_SPELL_1};
    }

    public boolean isFriendlyFire(LivingEntity entity) {
        if (entity instanceof PossessedByLicowitch) {
            PossessedByLicowitch possessed = (PossessedByLicowitch)entity;
            int id = possessed.getPossessedByLicowitchId();
            return id == this.m_19879_();
        }
        return entity instanceof Witch || entity.m_7306_((Entity)this);
    }

    public Vec3 getStaffPosition() {
        Vec3 angle = new Vec3(this.m_5737_() == HumanoidArm.LEFT ? (double)0.18f : (double)-0.18f, 1.625, 1.625).m_82524_((float)(-Math.toRadians(this.f_20883_)));
        return this.m_20182_().m_82549_(angle);
    }

    public Vec3 getSwingArmPosition() {
        Vec3 angle = new Vec3(this.getAnimation() == ANIMATION_SWING_LEFT ? 0.25 : -0.25, (double)1.45f, (double)0.45f).m_82524_((float)(-Math.toRadians(this.f_20883_)));
        return this.m_20182_().m_82549_(angle);
    }

    public List<UUID> getPossessedUUIDs() {
        ArrayList list = Lists.newArrayList();
        UUID uuid0 = ((Optional)this.f_19804_.m_135370_(POSSESSED_UUID_0)).orElse(null);
        UUID uuid1 = ((Optional)this.f_19804_.m_135370_(POSSESSED_UUID_1)).orElse(null);
        UUID uuid2 = ((Optional)this.f_19804_.m_135370_(POSSESSED_UUID_2)).orElse(null);
        if (uuid0 != null) {
            list.add(uuid0);
        }
        if (uuid1 != null) {
            list.add(uuid1);
        }
        if (uuid2 != null) {
            list.add(uuid2);
        }
        return list;
    }

    public void addPossessedUUID(@Nullable UUID uuid) {
        if (((Optional)this.f_19804_.m_135370_(POSSESSED_UUID_0)).isPresent()) {
            if (((Optional)this.f_19804_.m_135370_(POSSESSED_UUID_1)).isPresent()) {
                this.f_19804_.m_135381_(POSSESSED_UUID_2, Optional.ofNullable(uuid));
            } else {
                this.f_19804_.m_135381_(POSSESSED_UUID_1, Optional.ofNullable(uuid));
            }
        } else {
            this.f_19804_.m_135381_(POSSESSED_UUID_0, Optional.ofNullable(uuid));
        }
    }

    public void removePossessedUUID(@Nullable UUID uuid) {
        if (((Optional)this.f_19804_.m_135370_(POSSESSED_UUID_0)).isPresent() && uuid.equals(((Optional)this.f_19804_.m_135370_(POSSESSED_UUID_0)).get())) {
            this.f_19804_.m_135381_(POSSESSED_UUID_0, Optional.empty());
        } else if (((Optional)this.f_19804_.m_135370_(POSSESSED_UUID_1)).isPresent() && uuid.equals(((Optional)this.f_19804_.m_135370_(POSSESSED_UUID_1)).get())) {
            this.f_19804_.m_135381_(POSSESSED_UUID_1, Optional.empty());
        } else if (((Optional)this.f_19804_.m_135370_(POSSESSED_UUID_2)).isPresent() && uuid.equals(((Optional)this.f_19804_.m_135370_(POSSESSED_UUID_2)).get())) {
            this.f_19804_.m_135381_(POSSESSED_UUID_2, Optional.empty());
        }
    }

    public Mob createRandomPossessedMob() {
        float chance = this.f_19796_.m_188501_();
        if (chance < 0.1f) {
            return (Mob)((EntityType)ACEntityRegistry.CANDICORN.get()).m_20615_(this.m_9236_());
        }
        if (chance < 0.2f) {
            return (Mob)((EntityType)ACEntityRegistry.GUMMY_BEAR.get()).m_20615_(this.m_9236_());
        }
        if (chance < 0.5f) {
            return (Mob)((EntityType)ACEntityRegistry.GUMBEEPER.get()).m_20615_(this.m_9236_());
        }
        if (chance < 0.65f) {
            return (Mob)((EntityType)ACEntityRegistry.CARAMEL_CUBE.get()).m_20615_(this.m_9236_());
        }
        if (chance < 0.75f) {
            return (Mob)((EntityType)ACEntityRegistry.GINGERBREAD_MAN.get()).m_20615_(this.m_9236_());
        }
        return (Mob)((EntityType)ACEntityRegistry.CANIAC.get()).m_20615_(this.m_9236_());
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return super.m_7301_(effectInstance) && effectInstance.m_19544_() != MobEffects.f_19612_;
    }

    public void m_5993_(Entity entity, int deathScore, DamageSource damageSource) {
        super.m_5993_(entity, deathScore, damageSource);
        this.m_9236_().m_5594_((Player)null, this.m_20183_(), (SoundEvent)ACSoundRegistry.LICOWITCH_CELEBRATE.get(), SoundSource.HOSTILE, 0.3f, 0.9f + this.m_9236_().f_46441_.m_188501_() * 0.2f);
    }

    public boolean canReach(BlockPos pos) {
        int k;
        int j;
        Path path = this.m_21573_().m_7864_(pos, 0);
        if (path == null) {
            return false;
        }
        Node node = path.m_77395_();
        if (node == null) {
            return false;
        }
        int i = node.f_77271_ - pos.m_123341_();
        return (double)(i * i + (j = node.f_77272_ - pos.m_123342_()) * j + (k = node.f_77273_ - pos.m_123343_()) * k) <= 3.0;
    }

    public void m_7023_(Vec3 vec3d) {
        if (this.getTeleportingToPos() != null) {
            if (this.m_21573_().m_26570_() != null) {
                this.m_21573_().m_26573_();
            }
            vec3d = Vec3.f_82478_;
        }
        super.m_7023_(vec3d);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ACSoundRegistry.LICOWITCH_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.LICOWITCH_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.LICOWITCH_DEATH.get();
    }

    private class MoveHelper
    extends MoveControl {
        public MoveHelper() {
            super((Mob)LicowitchEntity.this);
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.STRAFE) {
                this.f_24978_ = 0.5;
            }
            super.m_8126_();
        }
    }

    private class RandomlyTeleportGoal
    extends Goal {
        private Vec3 teleportVec;

        public RandomlyTeleportGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            LivingEntity target = LicowitchEntity.this.m_5448_();
            if (LicowitchEntity.this.f_19796_.m_188503_(1000) == 0 && LicowitchEntity.this.canTeleport() && LicowitchEntity.this.getTeleportingToPos() == null && (target == null || !target.m_6084_())) {
                this.teleportVec = LandRandomPos.m_148488_((PathfinderMob)LicowitchEntity.this, (int)16, (int)16);
                if (this.teleportVec != null) {
                    this.teleportVec = this.teleportVec.m_82520_(0.0, 1.0, 0.0);
                    AABB aabb = LicowitchEntity.this.m_20191_().m_82383_(this.teleportVec.m_82546_(LicowitchEntity.this.m_20182_()));
                    return LicowitchEntity.this.m_9236_().m_5450_((Entity)LicowitchEntity.this, Shapes.m_83064_((AABB)aabb));
                }
            }
            return false;
        }

        public void m_8056_() {
            LicowitchEntity.this.setTeleportingToPos(this.teleportVec);
        }

        public boolean m_8045_() {
            return LicowitchEntity.this.canTeleport() || LicowitchEntity.this.getTeleportingToPos() != null;
        }
    }
}

