/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ai.AdvancedPathNavigateNoTeleport;
import com.github.alexmodguy.alexscaves.server.entity.ai.AnimalBreedEggsGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.AnimalLayEggGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.GrottoceratopsEatPlantsGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.GrottoceratopsMeleeGoal;
import com.github.alexmodguy.alexscaves.server.entity.living.DinosaurEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.VallumraptorEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.animation.LegSolverQuadruped;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class GrottoceratopsEntity
extends DinosaurEntity
implements IAnimatedEntity {
    private static final EntityDataAccessor<Float> TAIL_SWING_ROT = SynchedEntityData.m_135353_(GrottoceratopsEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public LegSolverQuadruped legSolver = new LegSolverQuadruped(0.0f, 1.1f, 1.15f, 1.15f, 1.0f);
    private Animation currentAnimation;
    private int animationTick;
    public static final Animation ANIMATION_SPEAK_1 = Animation.create((int)15);
    public static final Animation ANIMATION_SPEAK_2 = Animation.create((int)20);
    public static final Animation ANIMATION_CHEW_FROM_GROUND = Animation.create((int)60);
    public static final Animation ANIMATION_CHEW = Animation.create((int)40);
    public static final Animation ANIMATION_MELEE_RAM = Animation.create((int)20);
    public static final Animation ANIMATION_MELEE_TAIL_1 = Animation.create((int)20);
    public static final Animation ANIMATION_MELEE_TAIL_2 = Animation.create((int)20);
    private float prevTailSwingRot;
    private int resetAttackerCooldown = 0;

    public GrottoceratopsEntity(EntityType<? extends Animal> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22278_, 0.9).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22284_, 8.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TAIL_SWING_ROT, (Object)Float.valueOf(0.0f));
    }

    protected PathNavigation m_6037_(Level level) {
        return new AdvancedPathNavigateNoTeleport((Mob)this, level);
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        if (!this.m_6162_()) {
            this.m_5496_((SoundEvent)ACSoundRegistry.GROTTOCERATOPS_STEP.get(), 0.7f, 0.85f);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new GrottoceratopsMeleeGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new AnimalBreedEggsGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new AnimalLayEggGoal((Animal)this, 100, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ACBlockRegistry.TREE_STAR.get()}), false));
        this.f_21345_.m_25352_(5, (Goal)new GrottoceratopsEatPlantsGoal(this, 16));
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 45));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{GrottoceratopsEntity.class}).m_26044_(new Class[0]));
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        if (damageSource.m_7640_() instanceof VallumraptorEntity) {
            f *= 0.75f;
        }
        return super.m_6469_(damageSource, f);
    }

    @Override
    public void m_8119_() {
        float tailSwing;
        super.m_8119_();
        this.prevTailSwingRot = tailSwing = this.getTailSwingRot();
        if (this.getAnimation() == ANIMATION_MELEE_TAIL_1 || this.getAnimation() == ANIMATION_MELEE_TAIL_2) {
            float end;
            float start = this.getAnimation() == ANIMATION_MELEE_TAIL_1 ? 30.0f : -30.0f;
            float f = end = this.getAnimation() == ANIMATION_MELEE_TAIL_1 ? -180.0f : 180.0f;
            if (this.getAnimationTick() <= 7) {
                this.setTailSwingRot(Mth.m_14148_((float)tailSwing, (float)start, (float)5.0f));
            } else {
                this.setTailSwingRot(Mth.m_14148_((float)tailSwing, (float)end, (float)25.0f));
            }
            this.f_267362_.m_267771_(1.0f);
        } else {
            if (Math.abs(tailSwing) > 0.0f) {
                this.setTailSwingRot(Mth.m_14148_((float)tailSwing, (float)0.0f, (float)20.0f));
            }
            this.f_20883_ = Mth.m_14148_((float)this.f_20884_, (float)this.f_20883_, (float)this.m_21529_());
        }
        if ((this.getAnimation() == ANIMATION_CHEW || this.getAnimation() == ANIMATION_CHEW_FROM_GROUND) && this.getAnimationTick() > this.getAnimation().getDuration() - 1) {
            this.m_5634_(5.0f);
        }
        if (this.getAnimation() == ANIMATION_CHEW && this.getAnimationTick() == 2 || this.getAnimation() == ANIMATION_CHEW_FROM_GROUND && this.getAnimationTick() == 10) {
            this.m_216990_((SoundEvent)ACSoundRegistry.GROTTOCERATOPS_GRAZE.get());
        }
        if (this.f_19797_ % 100 == 0 && this.m_21223_() < this.m_21233_()) {
            this.m_5634_(2.0f);
        }
        if (this.resetAttackerCooldown > 0) {
            --this.resetAttackerCooldown;
        } else if (!(this.m_9236_().f_46443_ || this.m_6162_() || this.m_21188_() != null && this.m_21188_().m_6084_())) {
            this.m_6710_(this.m_21188_());
            this.resetAttackerCooldown = 600;
        }
        if (this.getAnimation() == ANIMATION_SPEAK_1 && this.getAnimationTick() == 5 || this.getAnimation() == ANIMATION_SPEAK_2 && this.getAnimationTick() == 2) {
            this.actuallyPlayAmbientSound();
        }
        this.legSolver.update((LivingEntity)this, this.f_20883_ + this.getTailSwingRot(), this.m_6134_());
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    private float getTailSwingRot() {
        return ((Float)this.f_19804_.m_135370_(TAIL_SWING_ROT)).floatValue();
    }

    public float getTailSwingRot(float f) {
        return this.prevTailSwingRot + (this.getTailSwingRot() - this.prevTailSwingRot) * f;
    }

    public void setTailSwingRot(float rot) {
        this.f_19804_.m_135381_(TAIL_SWING_ROT, (Object)Float.valueOf(rot));
    }

    @Override
    public BlockState createEggBlockState() {
        return ((Block)ACBlockRegistry.GROTTOCERATOPS_EGG.get()).m_49966_();
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return (AgeableMob)((EntityType)ACEntityRegistry.GROTTOCERATOPS.get()).m_20615_((Level)level);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_SPEAK_1, ANIMATION_SPEAK_2, ANIMATION_CHEW_FROM_GROUND, ANIMATION_CHEW, ANIMATION_MELEE_RAM, ANIMATION_MELEE_TAIL_1, ANIMATION_MELEE_TAIL_2};
    }

    public void m_8032_() {
        if (this.getAnimation() == NO_ANIMATION && !this.m_9236_().f_46443_) {
            this.setAnimation(this.f_19796_.m_188499_() ? ANIMATION_SPEAK_2 : ANIMATION_SPEAK_1);
        }
    }

    public void actuallyPlayAmbientSound() {
        SoundEvent soundevent = this.m_7515_();
        float volume = this.m_6121_();
        if (this.getAnimation() == ANIMATION_SPEAK_2) {
            soundevent = (SoundEvent)ACSoundRegistry.GROTTOCERATOPS_CALL.get();
            volume += 1.0f;
        }
        if (soundevent != null) {
            this.m_5496_(soundevent, volume, this.m_6100_());
        }
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_(((Block)ACBlockRegistry.TREE_STAR.get()).m_5456_());
    }

    public void m_267651_(boolean flying) {
        float f1 = (float)Mth.m_184648_((double)(this.m_20185_() - this.f_19854_), (double)(flying ? this.m_20186_() - this.f_19855_ : 0.0), (double)(this.m_20189_() - this.f_19856_));
        float f2 = Math.min(f1 * 8.0f, 1.0f);
        this.f_267362_.m_267566_(f2, 0.4f);
    }

    public void m_27595_(@javax.annotation.Nullable Player player) {
        super.m_27595_(player);
        if (this.getAnimation() == null || this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_CHEW);
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ACSoundRegistry.GROTTOCERATOPS_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.GROTTOCERATOPS_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.GROTTOCERATOPS_DEATH.get();
    }

    public float getStepHeight() {
        return 1.1f;
    }
}

