/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.MothBallBlock;
import com.github.alexmodguy.alexscaves.server.block.poi.ACPOIRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ai.GloomothFindLightGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.GloomothFleeMothBallsGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.GloomothFlightGoal;
import com.github.alexmodguy.alexscaves.server.entity.living.ForsakenEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.UnderzealotEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.VesperEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.WatcherEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.UnderzealotSacrifice;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class GloomothEntity
extends PathfinderMob
implements UnderzealotSacrifice {
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.m_135353_(GloomothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float flyProgress;
    private float prevFlyProgress;
    private float flapAmount;
    private float prevFlapAmount;
    private float flightPitch = 0.0f;
    private float prevFlightPitch = 0.0f;
    private float flightRoll = 0.0f;
    private float prevFlightRoll = 0.0f;
    private boolean isLandNavigator;
    public BlockPos lightPos;
    private int refreshLightPosIn = 0;
    private boolean isBeingSacrificed = false;
    private int sacrificeTime = 0;
    private int flapTime = 0;

    public GloomothEntity(EntityType entityType, Level level) {
        super(entityType, level);
        this.switchNavigator(true);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLYING, (Object)false);
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.f_21342_ = new MoveControl((Mob)this);
            this.f_21344_ = new GroundPathNavigation((Mob)this, this.m_9236_());
            this.isLandNavigator = true;
        } else {
            this.f_21342_ = new FlightMoveHelper(this);
            this.f_21344_ = this.m_6037_(this.m_9236_());
            this.isLandNavigator = false;
        }
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new FlyingPathNavigation((Mob)this, worldIn){

            public boolean m_6342_(BlockPos blockPos) {
                return this.f_26495_.m_8055_(blockPos).m_60795_();
            }
        };
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new GloomothFleeMothBallsGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new GloomothFindLightGoal(this, 32));
        this.f_21345_.m_25352_(3, (Goal)new GloomothFlightGoal(this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22276_, 4.0);
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevFlyProgress = this.flyProgress;
        this.prevFlightPitch = this.flightPitch;
        this.prevFlightRoll = this.flightRoll;
        this.prevFlapAmount = this.flapAmount;
        if (this.isFlying() && this.flyProgress < 5.0f) {
            this.flyProgress += 1.0f;
        }
        if (!this.isFlying() && this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        float yMov = (float)this.m_20184_().f_82480_;
        float xzMov = (float)this.m_20184_().m_165924_();
        if (xzMov > 0.0f) {
            if (this.flapAmount < 5.0f) {
                this.flapAmount += 1.0f;
            }
        } else if (xzMov <= 0.05f && this.flapAmount > 0.0f) {
            this.flapAmount -= 0.5f;
        }
        if (this.isFlying()) {
            if (this.isLandNavigator) {
                this.switchNavigator(false);
            }
            if (this.flapAmount > 0.0f && this.m_6084_() && this.flapTime-- <= 0) {
                this.flapTime = 8 + this.f_19796_.m_188503_(10);
                this.m_5496_((SoundEvent)ACSoundRegistry.GLOOMOTH_FLAP.get(), 0.7f, 1.0f);
            }
        } else if (!this.isLandNavigator) {
            this.switchNavigator(true);
        }
        if (this.lightPos != null && this.m_6084_() && !this.m_9236_().f_46443_ && this.refreshLightPosIn-- < 0) {
            this.refreshLightPosIn = 40 + this.f_19796_.m_188503_(100);
            if (this.m_20238_(Vec3.m_82512_((Vec3i)this.lightPos)) >= 256.0 || !this.m_9236_().m_8055_(this.lightPos).m_204336_(ACTagRegistry.GLOOMOTH_LIGHT_SOURCES) || this.m_9236_().m_7146_(this.lightPos) <= 0) {
                this.lightPos = null;
            }
        }
        this.tickRotation(yMov * 2.5f * -57.295776f);
        if (this.isBeingSacrificed && !this.m_9236_().f_46443_) {
            --this.sacrificeTime;
            if (this.sacrificeTime < 10) {
                this.m_9236_().m_7605_((Entity)this, (byte)61);
            }
            if (this.sacrificeTime < 0) {
                Entity entity;
                if (this.m_20159_() && (entity = this.m_20202_()) instanceof UnderzealotEntity) {
                    UnderzealotEntity underzealot = (UnderzealotEntity)entity;
                    underzealot.postSacrifice(this);
                    underzealot.triggerIdleDigging();
                }
                this.m_8127_();
                WatcherEntity watcherEntity = (WatcherEntity)this.m_21406_((EntityType)ACEntityRegistry.WATCHER.get(), true);
                this.m_5496_((SoundEvent)ACSoundRegistry.WATCHER_SPAWN.get(), 8.0f, 1.0f);
                if (watcherEntity != null) {
                    ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)watcherEntity);
                    watcherEntity.m_8127_();
                }
            }
        }
    }

    public void m_7822_(byte b) {
        if (b == 61) {
            for (int i = 0; i < 1 + this.f_19796_.m_188503_(4); ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ACParticleRegistry.UNDERZEALOT_EXPLOSION.get(), this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0.0, 0.0, 0.0);
            }
        } else {
            super.m_7822_(b);
        }
    }

    private void tickRotation(float yMov) {
        this.flightPitch = yMov;
        float threshold = 1.0f;
        boolean flag = false;
        if (this.isFlying() && this.f_19859_ - this.m_146908_() > threshold) {
            this.flightRoll += 10.0f;
            flag = true;
        }
        if (this.isFlying() && this.f_19859_ - this.m_146908_() < -threshold) {
            this.flightRoll -= 10.0f;
            flag = true;
        }
        if (!flag) {
            if (this.flightRoll > 0.0f) {
                this.flightRoll = Math.max(this.flightRoll - 5.0f, 0.0f);
            }
            if (this.flightRoll < 0.0f) {
                this.flightRoll = Math.min(this.flightRoll + 5.0f, 0.0f);
            }
        }
        this.flightRoll = Mth.m_14036_((float)this.flightRoll, (float)-60.0f, (float)60.0f);
    }

    public boolean isFlying() {
        return (Boolean)this.f_19804_.m_135370_(FLYING);
    }

    public void setFlying(boolean flying) {
        if (flying && this.m_6162_()) {
            flying = false;
        }
        this.f_19804_.m_135381_(FLYING, (Object)flying);
    }

    public float getFlapAmount(float partialTick) {
        return (this.prevFlapAmount + (this.flapAmount - this.prevFlapAmount) * partialTick) * 0.2f;
    }

    public float getFlyProgress(float partialTick) {
        return (this.prevFlyProgress + (this.flyProgress - this.prevFlyProgress) * partialTick) * 0.2f;
    }

    public float getFlightPitch(float partialTick) {
        return this.prevFlightPitch + (this.flightPitch - this.prevFlightPitch) * partialTick;
    }

    public float getFlightRoll(float partialTick) {
        return this.prevFlightRoll + (this.flightRoll - this.prevFlightRoll) * partialTick;
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    public AABB m_6921_() {
        return this.m_20191_().m_82377_(2.0, 2.0, 2.0);
    }

    public boolean m_6783_(double distance) {
        return Math.sqrt(distance) < 1024.0;
    }

    public void m_267651_(boolean flying) {
        float f1 = (float)Mth.m_184648_((double)(this.m_20185_() - this.f_19854_), (double)(this.m_20186_() - this.f_19855_), (double)(this.m_20189_() - this.f_19856_));
        float f2 = Math.min(f1 * 6.0f, 1.0f);
        this.f_267362_.m_267566_(f2, 0.4f);
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    protected void m_7625_(DamageSource damageSource, boolean idk) {
        if (!(damageSource.m_7639_() instanceof ForsakenEntity) && !(damageSource.m_7639_() instanceof VesperEntity)) {
            super.m_7625_(damageSource, idk);
        }
    }

    public static boolean isValidLightLevel(ServerLevelAccessor levelAccessor, BlockPos blockPos, RandomSource randomSource) {
        if (levelAccessor.m_45517_(LightLayer.SKY, blockPos) > randomSource.m_188503_(32)) {
            return false;
        }
        int lvt_3_1_ = levelAccessor.m_6018_().m_46470_() ? levelAccessor.m_46849_(blockPos, 10) : levelAccessor.m_46803_(blockPos);
        return lvt_3_1_ <= randomSource.m_188503_(8);
    }

    public static boolean canMonsterSpawnInLight(EntityType<GloomothEntity> entityType, ServerLevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return GloomothEntity.isValidLightLevel(levelAccessor, blockPos, randomSource) && GloomothEntity.m_217057_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource);
    }

    public static <T extends Mob> boolean checkGloomothSpawnRules(EntityType<GloomothEntity> entityType, ServerLevelAccessor iServerWorld, MobSpawnType reason, BlockPos pos, RandomSource random) {
        if (GloomothEntity.canMonsterSpawnInLight(entityType, iServerWorld, reason, pos, random)) {
            BlockPos.MutableBlockPos above = new BlockPos.MutableBlockPos();
            above.m_122190_((Vec3i)pos);
            int k = 0;
            while (iServerWorld.m_46859_((BlockPos)above) && above.m_123342_() < iServerWorld.m_151558_()) {
                above.m_122184_(0, 1, 0);
                if (++k <= 4) continue;
                return true;
            }
        }
        return false;
    }

    public BlockPos getNearestMothBall(ServerLevel world, BlockPos to, int range) {
        PoiManager pointofinterestmanager = world.m_8904_();
        return pointofinterestmanager.m_148658_(poiTypeHolder -> poiTypeHolder.m_203565_(ACPOIRegistry.MOTH_BALL.getKey()), blockPos -> this.isWithinMothBallRange((BlockPos)blockPos, range), to, range, PoiManager.Occupancy.ANY).orElse(null);
    }

    private boolean isWithinMothBallRange(BlockPos blockPos, int range) {
        BlockState state = this.m_9236_().m_8055_(blockPos);
        if (state.m_60713_((Block)ACBlockRegistry.MOTH_BALL.get())) {
            float balls = (float)((Integer)state.m_61143_((Property)MothBallBlock.BALLS)).intValue() / 5.0f;
            int distance = (int)Math.sqrt(blockPos.m_123331_((Vec3i)this.m_20183_()));
            return (float)distance < balls * (float)range;
        }
        return false;
    }

    @Override
    public void triggerSacrificeIn(int time) {
        this.isBeingSacrificed = true;
        this.sacrificeTime = time;
    }

    @Override
    public boolean isValidSacrifice(int distanceFromGround) {
        return distanceFromGround < 4;
    }

    private void doInitialPosing(LevelAccessor world) {
        BlockPos above = this.m_20183_();
        int upBy = 3 + this.f_19796_.m_188503_(5);
        for (int k = 0; world.m_46859_(above) && above.m_123342_() < this.m_9236_().m_151558_() && k < upBy; ++k) {
            above = above.m_7494_();
        }
        this.setFlying(true);
        this.m_6034_((float)above.m_123341_() + 0.5f, above.m_123342_(), (float)above.m_123343_() + 0.5f);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (reason == MobSpawnType.NATURAL) {
            this.doInitialPosing((LevelAccessor)worldIn);
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.GLOOMOTH_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.GLOOMOTH_DEATH.get();
    }

    class FlightMoveHelper
    extends MoveControl {
        public FlightMoveHelper(GloomothEntity gloomoth) {
            super((Mob)gloomoth);
        }

        public void m_8126_() {
            int maxRotChange = 10;
            boolean flag = false;
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.f_24974_.m_21573_().m_26571_()) {
                double d0 = this.f_24975_ - this.f_24974_.m_20185_();
                double d1 = this.f_24976_ - this.f_24974_.m_20186_();
                double d2 = this.f_24977_ - this.f_24974_.m_20189_();
                double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d1 * d1 + d2 * d2)));
                double d4 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
                this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
                float f1 = (float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_) * 3.0);
                float rotBy = maxRotChange;
                this.f_24974_.m_20256_(this.f_24974_.m_20184_().m_82520_(0.0, (double)f1 * (d1 /= d3) * 0.025, 0.0));
                if (d4 < (double)(this.f_24974_.m_20205_() + 1.4f)) {
                    f1 *= 0.7f;
                    rotBy = d4 < (double)0.3f ? 0.0f : (float)Math.max(40, maxRotChange);
                } else {
                    flag = true;
                }
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), f, rotBy));
                if (d3 > 0.3) {
                    this.f_24974_.m_7910_(f1);
                    flag = true;
                } else {
                    this.f_24974_.m_7910_(0.0f);
                }
            } else {
                this.f_24974_.m_7910_(0.0f);
            }
            this.f_24974_.m_20242_(flag);
        }
    }
}

