/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.ai;

import com.github.alexmodguy.alexscaves.server.entity.living.TremorsaurusEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.EnumSet;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.FlyingAnimal;

public class TremorsaurusMeleeGoal
extends Goal {
    private TremorsaurusEntity tremorsaurus;

    public TremorsaurusMeleeGoal(TremorsaurusEntity tremorsaurus) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.tremorsaurus = tremorsaurus;
    }

    public boolean m_8036_() {
        return this.tremorsaurus.m_5448_() != null && this.tremorsaurus.m_5448_().m_6084_() && !this.tremorsaurus.isDancing();
    }

    public void m_8056_() {
        this.tremorsaurus.setRunning(!this.tremorsaurus.m_20160_());
    }

    public void m_8041_() {
        this.tremorsaurus.setRunning(false);
    }

    public void m_8037_() {
        LivingEntity target = this.tremorsaurus.m_5448_();
        if (target != null) {
            boolean grab = this.isFlyingTarget();
            this.tremorsaurus.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
            this.tremorsaurus.tryRoar();
            double dist = this.tremorsaurus.m_20270_((Entity)target);
            this.tremorsaurus.m_21573_().m_5624_((Entity)target, 1.0);
            if (dist < (double)(this.tremorsaurus.m_20205_() + target.m_20205_()) + 1.0 && this.tremorsaurus.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                if ((this.tremorsaurus.m_217043_().m_188499_() || Math.max(target.m_20206_(), target.m_20205_()) >= 2.0f) && !grab || this.tremorsaurus.m_6162_()) {
                    this.tryAnimation(TremorsaurusEntity.ANIMATION_BITE);
                } else {
                    this.tryAnimation(TremorsaurusEntity.ANIMATION_SHAKE_PREY);
                }
            }
            if (this.tremorsaurus.getAnimation() == TremorsaurusEntity.ANIMATION_BITE && this.tremorsaurus.getAnimationTick() > 10 && this.tremorsaurus.getAnimationTick() <= 12) {
                this.checkAndDealDamage(target);
            }
        }
    }

    private void checkAndDealDamage(LivingEntity target) {
        if (this.tremorsaurus.m_142582_((Entity)target) && (double)this.tremorsaurus.m_20270_((Entity)target) < (double)(this.tremorsaurus.m_20205_() + target.m_20205_()) + 2.0) {
            this.tremorsaurus.m_216990_((SoundEvent)ACSoundRegistry.TREMORSAURUS_BITE.get());
            target.m_6469_(target.m_269291_().m_269333_((LivingEntity)this.tremorsaurus), (float)this.tremorsaurus.m_21051_(Attributes.f_22281_).m_22135_());
            target.m_147240_(0.5, this.tremorsaurus.m_20185_() - target.m_20185_(), this.tremorsaurus.m_20189_() - target.m_20189_());
        }
    }

    private boolean isFlyingTarget() {
        return this.tremorsaurus.m_5448_() instanceof FlyingAnimal;
    }

    private boolean tryAnimation(Animation animation) {
        if (this.tremorsaurus.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
            this.tremorsaurus.setAnimation(animation);
            return true;
        }
        return false;
    }
}

