/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.ai;

import com.github.alexmodguy.alexscaves.server.entity.living.SubterranodonEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.PackAnimal;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SubterranodonFlightGoal
extends Goal {
    private SubterranodonEntity entity;
    private double x;
    private double y;
    private double z;
    private boolean isFlying;

    public SubterranodonFlightGoal(SubterranodonEntity subterranodon) {
        this.entity = subterranodon;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        Vec3 target;
        if (this.entity.m_20160_() || this.entity.m_5448_() != null && this.entity.m_5448_().m_6084_() || this.entity.m_20159_() || this.entity.isDancing() || this.entity.m_21825_()) {
            return false;
        }
        boolean flag = false;
        if (this.entity.isPackFollower() && ((SubterranodonEntity)this.entity.getPackLeader()).m_29443_()) {
            this.isFlying = true;
            flag = true;
        }
        if (!flag) {
            if (this.entity.m_217043_().m_188503_(70) != 0 && !this.entity.m_29443_()) {
                return false;
            }
            if (this.entity.m_20096_()) {
                this.isFlying = this.entity.m_217043_().m_188503_(3) == 0;
            } else {
                boolean bl = this.isFlying = this.entity.m_217043_().m_188503_(8) > 0 && this.entity.timeFlying < 200;
            }
        }
        if ((target = this.getPosition()) == null) {
            return false;
        }
        this.x = target.f_82479_;
        this.y = target.f_82480_;
        this.z = target.f_82481_;
        return true;
    }

    public void m_8037_() {
        if (this.isFlying) {
            if (this.entity.resetFlightAIFlag || this.entity.f_19862_ && this.entity.timeFlying % 10 == 0 || this.entity.m_20275_(this.x, this.y, this.z) < 9.0) {
                Vec3 target = this.getPosition();
                if (target != null) {
                    this.x = target.f_82479_;
                    this.y = target.f_82480_;
                    this.z = target.f_82481_;
                }
                this.entity.resetFlightAIFlag = false;
            }
            this.entity.m_21566_().m_6849_(this.x, this.y, this.z, 1.0);
        } else {
            if (this.entity.m_29443_() || ((SubterranodonEntity)this.entity.getPackLeader()).landingFlag) {
                this.entity.landingFlag = true;
            }
            this.entity.m_21573_().m_26519_(this.x, this.y, this.z, 1.0);
        }
        if (!this.isFlying && this.entity.m_29443_() && this.entity.m_20096_()) {
            this.entity.setFlying(false);
        }
        if (this.entity.m_29443_() && this.entity.m_20096_() && this.entity.timeFlying > 40) {
            this.entity.setFlying(false);
        }
    }

    @Nullable
    protected Vec3 getPosition() {
        if (this.isOverWaterOrVoid()) {
            this.isFlying = true;
        }
        Vec3 vec3 = this.findOrFollowFlightPos();
        if (this.isFlying) {
            if ((this.entity.timeFlying < 2000 || this.isLeaderStillGoing() || this.isOverWaterOrVoid()) && !this.entity.m_21827_()) {
                return vec3;
            }
            if (this.entity.m_21536_() && !this.entity.f_19862_) {
                return Vec3.m_82512_((Vec3i)this.entity.m_21534_());
            }
            return this.groundPosition(vec3);
        }
        return this.entity.m_29443_() ? this.groundPosition(vec3).m_82520_(0.0, -1.0, 0.0) : LandRandomPos.m_148488_((PathfinderMob)this.entity, (int)10, (int)7);
    }

    private Vec3 findFlightPos() {
        Vec3 targetVec;
        if (this.entity.m_21536_() && this.entity.m_21534_() != null) {
            maxRot = 360.0f;
            Vec3 center = Vec3.m_82512_((Vec3i)this.entity.m_21534_());
            float xRotOffset = (float)Math.toRadians(this.entity.m_217043_().m_188501_() * (maxRot - maxRot / 2.0f) * 0.5f);
            float yRotOffset = (float)Math.toRadians(this.entity.m_217043_().m_188501_() * maxRot - maxRot / 2.0f);
            Vec3 distVec = new Vec3(0.0, 0.0, (double)(15 + this.entity.m_217043_().m_188503_(15))).m_82496_(xRotOffset).m_82524_(yRotOffset);
            targetVec = center.m_82549_(distVec);
        } else {
            maxRot = this.entity.f_19862_ ? 360.0f : 90.0f;
            float xRotOffset = (float)Math.toRadians(this.entity.m_217043_().m_188501_() * (maxRot - maxRot / 2.0f) * 0.5f);
            float yRotOffset = (float)Math.toRadians(this.entity.m_217043_().m_188501_() * maxRot - maxRot / 2.0f);
            Vec3 lookVec = this.entity.m_20154_().m_82490_((double)(15 + this.entity.m_217043_().m_188503_(15))).m_82496_(xRotOffset).m_82524_(yRotOffset);
            targetVec = this.entity.m_20182_().m_82549_(lookVec);
        }
        if (!this.entity.m_9236_().m_46749_(BlockPos.m_274446_((Position)targetVec))) {
            return this.entity.m_20182_();
        }
        Vec3 heightAdjusted = targetVec;
        if (this.entity.m_9236_().m_45527_(BlockPos.m_274446_((Position)heightAdjusted))) {
            ground = this.groundPosition(heightAdjusted);
            heightAdjusted = new Vec3(heightAdjusted.f_82479_, ground.f_82480_ + 5.0 + (double)this.entity.m_217043_().m_188503_(10), heightAdjusted.f_82481_);
        } else {
            ground = this.groundPosition(heightAdjusted);
            BlockPos ceiling = BlockPos.m_274446_((Position)ground).m_6630_(2);
            while (ceiling.m_123342_() < this.entity.m_9236_().m_151558_() && !this.entity.m_9236_().m_8055_(ceiling).m_280296_()) {
                ceiling = ceiling.m_7494_();
            }
            float randCeilVal = 0.5f + this.entity.m_217043_().m_188501_() * 0.2f;
            heightAdjusted = new Vec3(heightAdjusted.f_82479_, ground.f_82480_ + ((double)ceiling.m_123342_() - ground.f_82480_) * (double)randCeilVal, heightAdjusted.f_82481_);
        }
        BlockHitResult result = this.entity.m_9236_().m_45547_(new ClipContext(this.entity.m_146892_(), heightAdjusted, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.entity));
        if (result.m_6662_() == HitResult.Type.MISS) {
            this.entity.lastFlightTargetPos = heightAdjusted;
            return heightAdjusted;
        }
        return result.m_82450_();
    }

    private Vec3 findOrFollowFlightPos() {
        SubterranodonEntity leader = (SubterranodonEntity)this.entity.getPackLeader();
        if (leader == this.entity || leader.lastFlightTargetPos == null) {
            Vec3 randOffsetMove = new Vec3((double)(this.entity.m_217043_().m_188501_() - 0.5f), (double)(this.entity.m_217043_().m_188501_() - 0.5f), (double)(this.entity.m_217043_().m_188501_() - 0.5f)).m_82490_(2.0);
            return this.findFlightPos().m_82549_(randOffsetMove);
        }
        int index = this.getPackPosition(this.entity, 0);
        int halfIndex = (int)Math.ceil((float)index / 2.0f);
        float xOffset = 6.0f + this.entity.m_217043_().m_188501_() * 2.0f;
        float zOffset = 4.0f + this.entity.m_217043_().m_188501_() * 3.0f;
        Vec3 offset = new Vec3((double)(((float)(index % 2) - 0.5f) * xOffset * (float)halfIndex), 0.0, (double)((float)halfIndex * zOffset)).m_82524_((float)Math.toRadians(180.0f - leader.f_20883_));
        return leader.lastFlightTargetPos.m_82549_(offset);
    }

    private boolean isLeaderStillGoing() {
        return this.entity.isPackFollower() && ((SubterranodonEntity)this.entity.getPackLeader()).m_29443_();
    }

    private int getPackPosition(PackAnimal subterranodon, int index) {
        if (index < 16 && subterranodon.getPriorPackMember() != null) {
            return this.getPackPosition(subterranodon.getPriorPackMember(), index + 1);
        }
        return index;
    }

    private boolean isOverWaterOrVoid() {
        BlockPos position = this.entity.m_20183_();
        while (position.m_123342_() > this.entity.m_9236_().m_141937_() && this.entity.m_9236_().m_46859_(position) && this.entity.m_9236_().m_6425_(position).m_76178_()) {
            position = position.m_7495_();
        }
        return !this.entity.m_9236_().m_6425_(position).m_76178_() || this.entity.m_9236_().m_8055_(position).m_60713_(Blocks.f_50191_) || position.m_123342_() <= this.entity.m_9236_().m_141937_();
    }

    public Vec3 groundPosition(Vec3 airPosition) {
        BlockPos.MutableBlockPos ground = new BlockPos.MutableBlockPos();
        ground.m_122169_(airPosition.f_82479_, airPosition.f_82480_, airPosition.f_82481_);
        boolean flag = false;
        while (ground.m_123342_() < this.entity.m_9236_().m_151558_() && !this.entity.m_9236_().m_8055_((BlockPos)ground).m_280296_() && this.entity.m_9236_().m_6425_((BlockPos)ground).m_76178_()) {
            ground.m_122184_(0, 1, 0);
            flag = true;
        }
        ground.m_122184_(0, -1, 0);
        while (ground.m_123342_() > this.entity.m_9236_().m_141937_() && !this.entity.m_9236_().m_8055_((BlockPos)ground).m_280296_() && this.entity.m_9236_().m_6425_((BlockPos)ground).m_76178_()) {
            ground.m_122184_(0, -1, 0);
        }
        return Vec3.m_82512_((Vec3i)(flag ? ground.m_7494_() : ground.m_7495_()));
    }

    public boolean m_8045_() {
        if (this.isFlying) {
            return this.entity.m_29443_() && this.entity.m_20275_(this.x, this.y, this.z) > 5.0 && !this.entity.isDancing();
        }
        return !this.entity.m_21573_().m_26571_() && !this.entity.m_20160_() && !this.entity.isDancing();
    }

    public void m_8056_() {
        if (this.isFlying) {
            this.entity.setFlying(true);
            this.entity.m_21566_().m_6849_(this.x, this.y, this.z, this.entity.isPackFollower() ? 2.0 : 1.0);
        } else {
            this.entity.m_21573_().m_26519_(this.x, this.y, this.z, 1.0);
        }
    }

    public void m_8041_() {
        this.entity.m_21573_().m_26573_();
        this.entity.landingFlag = false;
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        super.m_8041_();
    }
}

