/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block.fluid;

import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class AcidFluidType
extends FluidType {
    public static final ResourceLocation FLUID_STILL = new ResourceLocation("alexscaves:block/acid_still");
    public static final ResourceLocation FLUID_FLOWING = new ResourceLocation("alexscaves:block/acid_flowing");
    public static final ResourceLocation OVERLAY = new ResourceLocation("alexscaves:textures/misc/under_acid.png");

    public AcidFluidType(FluidType.Properties properties) {
        super(properties);
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return FLUID_STILL;
            }

            public ResourceLocation getFlowingTexture() {
                return FLUID_FLOWING;
            }

            public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                return OVERLAY;
            }
        });
    }

    public boolean move(FluidState state, LivingEntity entity, Vec3 movementVector, double gravity) {
        boolean flag;
        double d9 = entity.m_20186_();
        float f4 = 0.8f;
        float f5 = 0.02f;
        float f6 = EnchantmentHelper.m_44922_((LivingEntity)entity);
        double d0 = 0.08;
        boolean bl = flag = entity.m_20184_().f_82480_ <= 0.0;
        if (f6 > 3.0f) {
            f6 = 3.0f;
        }
        if (!entity.m_20096_()) {
            f6 *= 0.5f;
        }
        if (f6 > 0.0f) {
            f4 += (0.54600006f - f4) * f6 / 3.0f;
            f5 += (entity.m_6113_() - f5) * f6 / 3.0f;
        }
        if (entity.m_21023_(MobEffects.f_19593_)) {
            f4 = 0.96f;
        }
        entity.m_19920_(f5 *= (float)entity.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22135_(), movementVector);
        entity.m_6478_(MoverType.SELF, entity.m_20184_());
        Vec3 vec36 = entity.m_20184_();
        if (entity.f_19862_ && entity.m_6147_()) {
            vec36 = new Vec3(vec36.f_82479_, 0.2, vec36.f_82481_);
        }
        entity.m_20256_(vec36.m_82542_((double)f4, (double)0.8f, (double)f4));
        Vec3 vec32 = entity.m_20994_(d0, flag, entity.m_20184_());
        entity.m_20256_(vec32);
        if (entity.f_19862_ && entity.m_20229_(vec32.f_82479_, vec32.f_82480_ + (double)0.6f - entity.m_20186_() + d9, vec32.f_82481_)) {
            entity.m_20334_(vec32.f_82479_, (double)0.3f, vec32.f_82481_);
        }
        return true;
    }

    public boolean isVaporizedOnPlacement(Level level, BlockPos pos, FluidStack stack) {
        return level.m_6042_().f_63857_();
    }

    public void onVaporize(@Nullable Player player, Level level, BlockPos pos, FluidStack stack) {
        SoundEvent sound = this.getSound(player, (BlockGetter)level, pos, SoundActions.FLUID_VAPORIZE);
        level.m_5594_(player, pos, sound != null ? sound : SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.8f);
        for (int l = 0; l < 8; ++l) {
            level.m_7107_((ParticleOptions)ACParticleRegistry.RADGILL_SPLASH.get(), (double)pos.m_123341_() + Math.random(), (double)pos.m_123342_() + Math.random(), (double)pos.m_123343_() + Math.random(), (Math.random() - 0.5) * 0.25, Math.random() * 0.25, (Math.random() - 0.5) * 0.25);
        }
        level.m_46597_(pos, ((Block)ACBlockRegistry.UNREFINED_WASTE.get()).m_49966_());
    }
}

