/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block.blockentity;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.blockentity.ACBlockEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.item.SubmarineEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class EnigmaticEngineBlockEntity
extends BlockEntity {
    private int checkTime;

    public EnigmaticEngineBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ACBlockEntityRegistry.ENIGMATIC_ENGINE.get(), pos, state);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, EnigmaticEngineBlockEntity entity) {
        if (entity.checkTime-- <= 0) {
            entity.checkTime = 30 + level.f_46441_.m_188503_(30);
            entity.attemptAssembly();
        }
    }

    public boolean attemptAssembly() {
        Direction assembleIn = null;
        for (Direction direction : ACMath.HORIZONTAL_DIRECTIONS) {
            if (!this.isAssembledInDirection(direction)) continue;
            assembleIn = direction;
            break;
        }
        if (assembleIn != null) {
            for (BlockPos pos : BlockPos.m_121976_((int)(this.m_58899_().m_123341_() - 1), (int)(this.m_58899_().m_123342_() - 1), (int)(this.m_58899_().m_123343_() - 1), (int)(this.m_58899_().m_123341_() + 1), (int)(this.m_58899_().m_123342_() + 1), (int)(this.m_58899_().m_123343_() + 1))) {
                if (!this.f_58857_.m_8055_(pos).m_60713_((Block)ACBlockRegistry.DEPTH_GLASS.get()) && !this.f_58857_.m_8055_(pos).m_204336_(ACTagRegistry.SUBMARINE_ASSEMBLY_BLOCKS) && !this.f_58857_.m_8055_(pos).m_60713_((Block)ACBlockRegistry.ENIGMATIC_ENGINE.get())) continue;
                this.f_58857_.m_46597_(pos, Blocks.f_50016_.m_49966_());
            }
            if (!this.f_58857_.f_46443_) {
                SubmarineEntity submarine = (SubmarineEntity)((EntityType)ACEntityRegistry.SUBMARINE.get()).m_20615_(this.f_58857_);
                Vec3 vec31 = Vec3.m_82512_((Vec3i)this.m_58899_()).m_82520_(0.0, -1.0, 0.0);
                submarine.m_146922_(assembleIn.m_122435_());
                submarine.m_6034_(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_);
                submarine.setOxidizationLevel(0);
                this.f_58857_.m_7967_((Entity)submarine);
            }
            return true;
        }
        return false;
    }

    private boolean isAssembledInDirection(Direction direction) {
        ArrayList<BlockPos> windowPos = new ArrayList<BlockPos>();
        for (int i = -1; i <= 1; ++i) {
            for (int j = 0; j <= 1; ++j) {
                BlockPos at = this.m_58899_().m_121945_(direction).m_5484_(direction.m_122427_(), i).m_6630_(j);
                if (!this.f_58857_.m_8055_(at).m_60713_((Block)ACBlockRegistry.DEPTH_GLASS.get())) {
                    return false;
                }
                windowPos.add(at);
            }
        }
        if (windowPos.size() == 6) {
            for (BlockPos pos : BlockPos.m_121976_((int)(this.m_58899_().m_123341_() - 1), (int)(this.m_58899_().m_123342_() - 1), (int)(this.m_58899_().m_123343_() - 1), (int)(this.m_58899_().m_123341_() + 1), (int)(this.m_58899_().m_123342_() + 1), (int)(this.m_58899_().m_123343_() + 1))) {
                if (windowPos.contains(pos) || pos.equals((Object)this.m_58899_()) || this.f_58857_.m_8055_(pos).m_204336_(ACTagRegistry.SUBMARINE_ASSEMBLY_BLOCKS)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

