/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block;

import com.github.alexmodguy.alexscaves.server.block.ACSoundTypes;
import com.github.alexmodguy.alexscaves.server.block.blockentity.ACBlockEntityRegistry;
import com.github.alexmodguy.alexscaves.server.block.blockentity.MagnetBlockEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MagnetBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    private final boolean azure;
    private static final VoxelShape SHAPE_UP = ACMath.buildShape(Block.m_49796_((double)0.0, (double)6.0, (double)5.0, (double)6.0, (double)16.0, (double)11.0), Block.m_49796_((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)6.0, (double)11.0), Block.m_49796_((double)10.0, (double)6.0, (double)5.0, (double)16.0, (double)16.0, (double)11.0));
    private static final VoxelShape SHAPE_DOWN = ACMath.buildShape(Block.m_49796_((double)0.0, (double)0.0, (double)5.0, (double)6.0, (double)10.0, (double)11.0), Block.m_49796_((double)0.0, (double)10.0, (double)5.0, (double)16.0, (double)16.0, (double)11.0), Block.m_49796_((double)10.0, (double)0.0, (double)5.0, (double)16.0, (double)10.0, (double)11.0));
    private static final VoxelShape SHAPE_NORTH = ACMath.buildShape(Block.m_49796_((double)0.0, (double)5.0, (double)0.0, (double)6.0, (double)11.0, (double)10.0), Block.m_49796_((double)0.0, (double)5.0, (double)10.0, (double)16.0, (double)11.0, (double)16.0), Block.m_49796_((double)10.0, (double)5.0, (double)0.0, (double)16.0, (double)11.0, (double)10.0));
    private static final VoxelShape SHAPE_SOUTH = ACMath.buildShape(Block.m_49796_((double)10.0, (double)5.0, (double)6.0, (double)16.0, (double)11.0, (double)16.0), Block.m_49796_((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)11.0, (double)6.0), Block.m_49796_((double)0.0, (double)5.0, (double)6.0, (double)6.0, (double)11.0, (double)16.0));
    private static final VoxelShape SHAPE_EAST = ACMath.buildShape(Block.m_49796_((double)6.0, (double)5.0, (double)0.0, (double)16.0, (double)11.0, (double)6.0), Block.m_49796_((double)0.0, (double)5.0, (double)0.0, (double)6.0, (double)11.0, (double)16.0), Block.m_49796_((double)6.0, (double)5.0, (double)10.0, (double)16.0, (double)11.0, (double)16.0));
    private static final VoxelShape SHAPE_WEST = ACMath.buildShape(Block.m_49796_((double)0.0, (double)5.0, (double)10.0, (double)10.0, (double)11.0, (double)16.0), Block.m_49796_((double)10.0, (double)5.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0), Block.m_49796_((double)0.0, (double)5.0, (double)0.0, (double)10.0, (double)11.0, (double)6.0));

    protected MagnetBlock(boolean azure) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60999_().m_60913_(4.0f, 12.0f).m_60918_(ACSoundTypes.NEODYMIUM).m_60955_().m_60988_().m_60953_(i -> 3).m_60991_((state, level, pos) -> true));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        this.azure = azure;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.m_61104_(new Property[]{FACING, POWERED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_())).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(context.m_43725_().m_276867_(context.m_8083_())));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case DOWN: {
                return SHAPE_DOWN;
            }
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case WEST: {
                return SHAPE_WEST;
            }
            case EAST: {
                return SHAPE_EAST;
            }
        }
        return SHAPE_UP;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_152180_, BlockState p_152181_, BlockEntityType<T> p_152182_) {
        return MagnetBlock.m_152132_(p_152182_, (BlockEntityType)((BlockEntityType)ACBlockEntityRegistry.MAGNET.get()), MagnetBlockEntity::tick);
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.f_46443_) {
            this.updateState(state, worldIn, pos, blockIn);
        }
    }

    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (!worldIn.f_46443_) {
            this.updateState(state, (Level)worldIn, pos, state.m_60734_());
        }
    }

    public void updateState(BlockState state, Level worldIn, BlockPos pos, Block blockIn) {
        boolean flag = (Boolean)state.m_61143_((Property)POWERED);
        boolean flag1 = worldIn.m_276867_(pos);
        if (flag1 != flag) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(flag1)), 3);
            worldIn.m_46672_(pos.m_7495_(), (Block)this);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(handIn);
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof MagnetBlockEntity) {
            MagnetBlockEntity magnet = (MagnetBlockEntity)blockEntity;
            if (!player.m_6144_()) {
                if (magnet.canAddRange() && magnet.isExtenderItem(heldItem)) {
                    magnet.increaseRange(1);
                    if (!player.m_7500_()) {
                        heldItem.m_41774_(1);
                    }
                    player.m_6674_(handIn);
                    return InteractionResult.SUCCESS;
                }
                if (magnet.canRemoveRange() && magnet.isRetracterItem(heldItem)) {
                    magnet.increaseRange(-1);
                    if (!player.m_7500_()) {
                        heldItem.m_41774_(1);
                    }
                    player.m_6674_(handIn);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileentity = worldIn.m_7702_(pos);
        if (tileentity instanceof MagnetBlockEntity) {
            MagnetBlockEntity magnetBlockEntity = (MagnetBlockEntity)tileentity;
            if (newState.m_60734_() != state.m_60734_()) {
                magnetBlockEntity.dropIngots(this.azure);
                worldIn.m_46717_(pos, (Block)this);
            }
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new MagnetBlockEntity(pos, state);
    }
}

