/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block;

import com.github.alexmodguy.alexscaves.server.block.blockentity.ACBlockEntityRegistry;
import com.github.alexmodguy.alexscaves.server.block.blockentity.AbyssalAltarBlockEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class AbyssalAltarBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final VoxelShape SHAPE = ACMath.buildShape(Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0), Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    public static final ToIntFunction<BlockState> LIGHT_EMISSION = blockState -> (Boolean)blockState.m_61143_((Property)ACTIVE) != false ? 5 : 0;

    public AbyssalAltarBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283743_).m_60988_().m_60913_(2.5f, 10.0f).m_60918_(SoundType.f_154677_).m_60953_(LIGHT_EMISSION));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.m_61104_(new Property[]{WATERLOGGED, ACTIVE});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new AbyssalAltarBlockEntity(pos, state);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState state1, boolean b) {
        if (!state.m_60713_(state1.m_60734_())) {
            BlockEntity blockentity = level.m_7702_(pos);
            if (blockentity instanceof Container) {
                Containers.m_19002_((Level)level, (BlockPos)pos, (Container)((Container)blockentity));
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, state1, b);
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState state1, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos1) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return super.m_7417_(state, direction, state1, levelAccessor, blockPos, blockPos1);
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level levelaccessor = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelaccessor.m_6425_(blockpos).m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(handIn);
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof AbyssalAltarBlockEntity) {
            AbyssalAltarBlockEntity altarBlockEntity = (AbyssalAltarBlockEntity)blockEntity;
            if (!player.m_6144_()) {
                ItemStack copy = heldItem.m_41777_();
                copy.m_41764_(1);
                if (altarBlockEntity.m_8020_(0).m_41619_()) {
                    altarBlockEntity.m_6836_(0, copy);
                    altarBlockEntity.onEntityInteract((LivingEntity)player, false);
                    if (!player.m_7500_()) {
                        heldItem.m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (altarBlockEntity.queueItemDrop(altarBlockEntity.m_8020_(0).m_41777_())) {
                    altarBlockEntity.onEntityInteract((LivingEntity)player, true);
                    altarBlockEntity.m_6836_(0, ItemStack.f_41583_);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return AbyssalAltarBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ACBlockEntityRegistry.ABYSSAL_ALTAR.get()), AbyssalAltarBlockEntity::tick);
    }
}

